/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service.newnote;

import java.time.LocalDate;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.abc.dc.ext.ResponseFileUtils;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.note.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.note.banks.abc.dc.service.CommNotePacker;
import kd.ebg.note.banks.abc.dc.service.newnote.util.NewNoteUtil;
import kd.ebg.note.business.notePayable.util.AbstractNoteImpl;
import kd.ebg.note.common.framework.utils.ParserUtils;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class DetailNoteImpl
extends AbstractNoteImpl {
    public String getDetail(NotePayableInfo notePayableInfo, BankAcnt acnt) {
        String str = this.packPay(notePayableInfo, acnt);
        String rep = this.doBussiness(str);
        return this.parse(rep);
    }

    public String getDetail(NoteReceivableInfo notePayableInfo, BankAcnt acnt) {
        String str = this.packPay(notePayableInfo, acnt);
        String rep = this.doBussiness(str);
        return this.parse(rep);
    }

    public String packPay(NotePayableInfo notePayableInfo, BankAcnt acnt) {
        return this.packPay(notePayableInfo.getCurrency(), notePayableInfo.getDraftType(), notePayableInfo.getBillNo(), notePayableInfo.getStartNo(), notePayableInfo.getEndNo(), notePayableInfo.getIssueDate(), notePayableInfo.getDueDate(), acnt);
    }

    public String packPay(NoteReceivableInfo notePayableInfo, BankAcnt acnt) {
        return this.packPay(notePayableInfo.getCurrency(), notePayableInfo.getDraftType(), notePayableInfo.getBillNo(), notePayableInfo.getStartNo(), notePayableInfo.getEndNo(), notePayableInfo.getIssueDate(), notePayableInfo.getDueDate(), acnt);
    }

    public String packPay(String currency, String draftType, String billNo, String startNo, String endNo, LocalDate issueDate, LocalDate dueDate, BankAcnt acnt) {
        Element root = ABC_DC_Packer.createABCRoot4New("CQRD32");
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(acnt.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByAcnt(acnt));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)currency);
        Element hermes = CommNotePacker.packHermes(root, "CH1003", "SPIN1015", "");
        JDomUtils.addChild((Element)hermes, (String)"DistTp", (String)"DT02");
        JDomUtils.addChild((Element)hermes, (String)"CdType", (String)draftType);
        JDomUtils.addChild((Element)hermes, (String)"CdNo", (String)billNo);
        JDomUtils.addChild((Element)hermes, (String)"CdRangeStart", (String)NewNoteUtil.getBankNoteSubrange(startNo));
        JDomUtils.addChild((Element)hermes, (String)"CdRangeEnd", (String)NewNoteUtil.getBankNoteSubrange(endNo));
        JDomUtils.addChild((Element)hermes, (String)"IssDtFr", (String)"");
        JDomUtils.addChild((Element)hermes, (String)"IssDtTo", (String)"");
        String busiType = RequestContextUtils.getRunningParam((String)"BusiType");
        JDomUtils.addChild((Element)hermes, (String)"BusiType", (String)busiType);
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public String parse(String rspStr) {
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        String RespInfo = root.getChildTextTrim("RespInfo");
        if (ResManager.loadKDString((String)"\u65e0\u6ee1\u8db3\u6761\u4ef6\u7684\u8bb0\u5f55", (String)"DetailNoteImpl_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]).equals(RespInfo) || ResManager.loadKDString((String)"\u67e5\u8be2\u65e0\u6570\u636e", (String)"DetailNoteImpl_1", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]).equals(RespInfo)) {
            return null;
        }
        if (!"0000".equals(rsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u519c\u884c\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 ,\u94f6\u884c\u8fd4\u56de :%s", (String)"DetailNoteImpl_2", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{rsp.getResponseCode(), rsp.getResponseMessage()}));
            EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element cme = root.getChild("Cme");
        String fieldNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"FieldNum");
        String recordNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"RecordNum");
        int recordNum = Integer.parseInt(recordNumStr);
        if (0 == recordNum) {
            return null;
        }
        String fileFlag = ParserUtils.checkUnNullableElement((Element)root, (String)"FileFlag");
        String[] splits = new String[]{};
        Element cmp = root.getChild("Cmp");
        if ("1".equals(fileFlag)) {
            String fileName = ParserUtils.checkUnNullableElement((Element)cmp, (String)"BatchFileName");
            splits = ResponseFileUtils.getDetailRspRecordsNew(fileName, "");
        } else {
            String respPrvData = ParserUtils.checkUnNullableElement((Element)cmp, (String)"RespPrvData");
            splits = StringUtils.split((String)respPrvData, (String)"|_|");
        }
        int fieldNum = Integer.parseInt(fieldNumStr);
        return splits[fieldNum - 1];
    }
}

