/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service.newnote.detail;

import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.abc.dc.ext.ResponseFileUtils;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.note.banks.abc.dc.service.newnote.detail.NoteDetailUtil;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.util.NoteRngNoUtils;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.framework.utils.ParserUtils;
import org.jdom2.Element;

public class NoteDetailParser {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(NoteDetailParser.class);

    public List<Detail> parseReplyDetail(BankNoteDetailRequest rqst, String rspStr, BankAcnt ancAcnt) {
        LinkedList<Detail> result = new LinkedList<Detail>();
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        String RespInfo = root.getChildTextTrim("RxtInfo");
        if (ResManager.loadKDString((String)"\u65e0\u6ee1\u8db3\u6761\u4ef6\u7684\u8bb0\u5f55", (String)"NoteDetailParser_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]).equals(RespInfo) || ResManager.loadKDString((String)"\u67e5\u8be2\u65e0\u6570\u636e", (String)"NoteDetailParser_1", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]).equals(RespInfo)) {
            return result;
        }
        if (!"0000".equals(rsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u519c\u884c\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 ,\u94f6\u884c\u8fd4\u56de :%s", (String)"NoteDetailParser_4", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{rsp.getResponseCode(), rsp.getResponseMessage()}));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element cme = root.getChild("Cme");
        String fieldNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"FieldNum");
        String recordNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"RecordNum");
        int recordNum = Integer.parseInt(recordNumStr);
        if (0 == recordNum) {
            return result;
        }
        String[] splits = new String[]{};
        Element cmp = root.getChild("Cmp");
        String fileName = ParserUtils.checkUnNullableElement((Element)cmp, (String)"BatchFileName");
        splits = ResponseFileUtils.getDetailRspRecordsNew(fileName, "");
        int fieldNum = Integer.parseInt(fieldNumStr);
        for (int i = recordNum - 1; i >= 0; --i) {
            String billNo = splits[fieldNum * i];
            String startNo = splits[fieldNum * i + 1];
            String endNo = splits[fieldNum * i + 2];
            String billAmount = splits[fieldNum * i + 3];
            String appDate = splits[fieldNum * i + 4];
            String appTime = splits[fieldNum * i + 5];
            String appName = splits[fieldNum * i + 6];
            String billType = splits[fieldNum * i + 7];
            String transferFlag = splits[fieldNum * i + 8];
            String issueDate = splits[fieldNum * i + 9];
            String dueDate = splits[fieldNum * i + 10];
            String accName = splits[fieldNum * i + 11];
            String accNo = splits[fieldNum * i + 12];
            String accBankScnaps = splits[fieldNum * i + 13];
            String accBankScnapsName = splits[fieldNum * i + 14];
            String acceptName = splits[fieldNum * i + 15];
            String acceptNo = splits[fieldNum * i + 16];
            String acceptScnaps = splits[fieldNum * i + 17];
            String acceptScnapsName = splits[fieldNum * i + 18];
            String payeeName = splits[fieldNum * i + 19];
            String payeeNo = splits[fieldNum * i + 20];
            String payeeScnaps = splits[fieldNum * i + 21];
            String payeeScnapsName = splits[fieldNum * i + 22];
            String busCode = splits[fieldNum * i + 23];
            String holdAccno = splits[fieldNum * i + 25];
            String holdAccname = splits[fieldNum * i + 26];
            String status = splits[fieldNum * i + 30];
            String ciscus = splits[fieldNum * i + 31];
            Detail info = new Detail();
            info.setNoteNo(billNo);
            if (!StringUtils.isEmpty((String)billAmount)) {
                info.setAmount(billAmount);
            }
            info.setDraftType(billType);
            if (StringUtils.isNotEmpty((String)startNo) && StringUtils.isNotEmpty((String)endNo) && !"0".equals(startNo)) {
                startNo = NoteRngNoUtils.getForMatBillNoRng((String)startNo);
                endNo = NoteRngNoUtils.getForMatBillNoRng((String)endNo);
            }
            info.setSubRange(startNo + "," + endNo);
            info.setStartNo(startNo);
            info.setEndNo(endNo);
            info.setIsNewECDS("0");
            if (!StringUtils.isEmpty((String)startNo) && !StringUtils.isEmpty((String)endNo)) {
                info.setGrdBag("1");
            }
            if ("0".equals(startNo) && "0".equals(endNo)) {
                info.setGrdBag("0");
            }
            info.setDrawerAccName(accName);
            info.setDrawerAccNo(accNo);
            info.setDrawerCnapsCode(accBankScnaps);
            info.setDrawerBankName(accBankScnapsName);
            info.setAcceptorAccName(acceptName);
            info.setAcceptorAccNo(acceptNo);
            info.setAcceptorCnapsCode(acceptScnaps);
            info.setAcceptorBankName(acceptScnapsName);
            info.setPayeeAccName(payeeName);
            info.setPayeeAccNo(payeeNo);
            info.setPayeeCnapsCode(payeeScnaps);
            info.setPayeeBankName(payeeScnapsName);
            info.setTransferFlag(transferFlag);
            info.setBankRefKey(busCode);
            info.setIssueDate(issueDate.replaceAll("-", ""));
            info.setDueDate(dueDate.replaceAll("-", ""));
            String tranType = rqst.getBody().getTranType();
            info.setTransferFlag(transferFlag);
            info.setNoteStatus(status);
            info.setCirStatus(ciscus);
            info.setApplicantAcNo(holdAccno);
            info.setApplicantAcName(holdAccname);
            info.setHolderAccNo(holdAccno);
            info.setPreHolderName(holdAccname);
            try {
                new NoteDetailUtil().queryNoteDetails(info, ancAcnt);
            }
            catch (Exception e) {
                info.setIsNoteSidesError("Y");
            }
            result.add(info);
        }
        return result;
    }
}

