/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service.newnote.receivable.signin;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.note.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.note.banks.abc.dc.service.CommNotePacker;
import kd.ebg.note.banks.abc.dc.service.newnote.NewNoteParser;
import kd.ebg.note.banks.abc.dc.service.newnote.receivable.QueryReceivableNoteImpl;
import kd.ebg.note.banks.abc.dc.service.newnote.util.NewNoteUtil;
import kd.ebg.note.banks.abc.dc.service.newnote.util.TypeConvertUtils;
import kd.ebg.note.banks.abc.dc.utils.TypeInfo;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class ReceivableSigninNoteImpl
extends AbstractNoteReceivableImpl {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryReceivableNoteImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7968\u636e\u7b7e\u6536", (String)"ReceivableSigninNoteImpl_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return false;
    }

    public String pack(BankNoteReceivableRequest bankNoteReceivableRequest, String s) {
        NoteReceivableInfo[] receivableInfos = bankNoteReceivableRequest.getNotePayableInfosAsArray();
        String transType = receivableInfos[0].getOperationCode();
        String subBizType = "reply";
        String typeCode = subBizType + transType;
        TypeInfo typeInfo = TypeConvertUtils.getReplayPackerTypeInfo(typeCode);
        if (null == typeInfo) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u53ef\u56de\u590d\u7c7b\u5b50\u4e1a\u52a1\u7c7b\u578b: %1$s\u7684\u4e1a\u52a1\u79cd\u7c7b\uff1a%2$s\u65e0\u6cd5\u8fdb\u884c\u5339\u914d\u3002\u4e0d\u652f\u6301\u8be5\u4e1a\u52a1\u3002", (String)"ReceivableSigninNoteImpl_5", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), subBizType, typeCode));
        }
        BankAcnt acnt = bankNoteReceivableRequest.getAcnt();
        Element root = ABC_DC_Packer.createABCRoot4New(typeInfo.getHandleTransCode(), receivableInfos[0].getBankBatchSeqId());
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(acnt.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByAcnt(acnt));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)acnt.getCurrency());
        Element hermes = CommNotePacker.packHermes(root, "CH1003", typeInfo.getHandleMsgType(), "");
        Element ResInf = JDomUtils.addChild((Element)hermes, (String)"ResInf");
        JDomUtils.addChild((Element)ResInf, (String)"SgnUpMk", (String)receivableInfos[0].getOtherInfo());
        JDomUtils.addChild((Element)ResInf, (String)"ResDt", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)ResInf, (String)"UcondlConsgnmtMrk", (String)"CC00");
        JDomUtils.addChild((Element)ResInf, (String)"Note", (String)receivableInfos[0].getExplanation());
        JDomUtils.addChild((Element)hermes, (String)"BusiNo", (String)receivableInfos[0].getBankRefKey());
        Element CustInf = JDomUtils.addChild((Element)hermes, (String)"CustInf");
        JDomUtils.addChild((Element)CustInf, (String)"DistTp", (String)"DT02");
        JDomUtils.addChild((Element)CustInf, (String)"AcctSvcr", (String)acnt.getCnaps());
        Element BillInf = JDomUtils.addChild((Element)hermes, (String)"BillInf");
        JDomUtils.addChild((Element)BillInf, (String)"CdNo", (String)receivableInfos[0].getBillNo());
        JDomUtils.addChild((Element)BillInf, (String)"CdRangeStart", (String)NewNoteUtil.getBankNoteSubrange(receivableInfos[0].getStartNo()));
        JDomUtils.addChild((Element)BillInf, (String)"CdRangeEnd", (String)NewNoteUtil.getBankNoteSubrange(receivableInfos[0].getEndNo()));
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest bankNoteReceivableRequest, String s) {
        NewNoteParser.parse(bankNoteReceivableRequest, s);
        return bankNoteReceivableRequest.getNoteReceivableInfos();
    }
}

