/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service.note.receivable.discount;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.note.banks.abc.dc.service.CommNotePacker;
import kd.ebg.note.banks.abc.dc.service.note.receivable.discount.QueryDiscountNoteReceivableImpl;
import kd.ebg.note.banks.abc.dc.utils.MatchUtils;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class DiscountNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryDiscountNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "CFRT56";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d34\u73b0\u7533\u8bf7(CFRT56)", (String)"DiscountNoteReceivableImpl_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        NoteReceivableInfo info2;
        List noteReceivableInfos = request.getNoteReceivableInfos();
        for (NoteReceivableInfo info2 : noteReceivableInfos) {
            if (null != info2.getDisCountAmount()) continue;
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8d34\u73b0\u5b9e\u4ed8\u91d1\u989d\u4e3a\u7a7a\u3002", (String)"DiscountNoteReceivableImpl_1", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
        }
        BankAcnt acnt = RequestContextUtils.getRequestContext().getAcnt();
        info2 = (NoteReceivableInfo)noteReceivableInfos.get(0);
        Element root = ABC_DC_Packer.createABCRoot4New("CFRT56");
        Element hermes = CommNotePacker.packNoteHeader(root, "0110");
        Element cmp = CommNotePacker.packCmpElement(root, acnt);
        if (MatchUtils.isSameBank(info2) && info2.getPayeeAccNo().length() == 15) {
            String areaCode = MatchUtils.getAreaCode(info2);
            JDomUtils.addChild((Element)cmp, (String)"CrAccNo", (String)(areaCode + info2.getPayeeAccNo()));
            JDomUtils.addChild((Element)cmp, (String)"CrProv", (String)areaCode);
        } else {
            JDomUtils.addChild((Element)cmp, (String)"CrAccNo", (String)info2.getPayeeAccNo());
            JDomUtils.addChild((Element)cmp, (String)"CrProv", (String)"");
        }
        JDomUtils.addChild((Element)root, (String)"Amt", (String)info2.getAmount().toString());
        Element eblist = JDomUtils.addChild((Element)root, (String)"EBList");
        Element ebinfo = JDomUtils.addChild((Element)eblist, (String)"EBInfo");
        JDomUtils.addChild((Element)ebinfo, (String)"IdNb", (String)info2.getBillNo());
        JDomUtils.addChild((Element)ebinfo, (String)"BillTyp", (String)info2.getDraftType());
        if (null == info2.getIssueDate()) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7968\u636e\u51fa\u7968\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"DiscountNoteReceivableImpl_2", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
        }
        if (null == info2.getDueDate()) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7968\u636e\u5230\u671f\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"DiscountNoteReceivableImpl_3", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
        }
        String IssDat = info2.getIssueDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        String duedate = info2.getDueDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        JDomUtils.addChild((Element)ebinfo, (String)"IssDat", (String)IssDat);
        JDomUtils.addChild((Element)ebinfo, (String)"DueDat", (String)duedate);
        if (!StringUtils.isEmpty((String)info2.getContractNo())) {
            JDomUtils.addChild((Element)ebinfo, (String)"ContNo", (String)info2.getContractNo());
        }
        JDomUtils.addChild((Element)ebinfo, (String)"BillAmt", (String)info2.getAmount().toString());
        JDomUtils.addChild((Element)ebinfo, (String)"PayAmt", (String)info2.getDisCountAmount());
        String batchNo = DiscountNoteReceivableImpl.genDateAnd6NumSequence();
        JDomUtils.addChild((Element)hermes, (String)"BatchNo", (String)batchNo);
        info2.setSequence(batchNo);
        Element dscnt = JDomUtils.addChild((Element)hermes, (String)"Dscnt");
        if (null == info2.getBookingDate()) {
            JDomUtils.addChild((Element)dscnt, (String)"AppDat", (String)DateUtil.formatTime4yyyyMMdd((Date)new Date()));
        } else {
            String bookingDate = info2.getBookingDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            JDomUtils.addChild((Element)dscnt, (String)"AppDat", (String)bookingDate);
        }
        JDomUtils.addChild((Element)dscnt, (String)"TXTyp", (String)"RM00");
        BigDecimal rate = new BigDecimal(info2.getDisCountRate()).divide(new BigDecimal("100"));
        JDomUtils.addChild((Element)dscnt, (String)"Rate", (String)rate.toPlainString());
        JDomUtils.addChild((Element)dscnt, (String)"TotalPayAmt", (String)info2.getDisCountAmount());
        JDomUtils.addChild((Element)dscnt, (String)"AccountFlg", (String)info2.getOtherInfo());
        JDomUtils.addChild((Element)dscnt, (String)"TransFlg", (String)info2.getTransferFlag());
        Element dscntBk = JDomUtils.addChild((Element)hermes, (String)"DscntBk");
        JDomUtils.addChild((Element)dscntBk, (String)"DBKAccNo", (String)"0");
        JDomUtils.addChild((Element)dscntBk, (String)"DBKNam", (String)info2.getPayeeAccName());
        JDomUtils.addChild((Element)dscntBk, (String)"DBKOpBnk", (String)info2.getPayeeBankCnaps());
        JDomUtils.addChild((Element)dscntBk, (String)"DBKOpBnkNam", (String)info2.getPayeeBankName());
        Element aoaccInf = JDomUtils.addChild((Element)hermes, (String)"AOAccnInf");
        JDomUtils.addChild((Element)aoaccInf, (String)"AOABnk", (String)info2.getAcceptorBankCnaps());
        JDomUtils.addChild((Element)aoaccInf, (String)"AOABnkNam", (String)info2.getAcceptorBankName());
        Element dscntPropsr = JDomUtils.addChild((Element)hermes, (String)"DscntPropsr");
        JDomUtils.addChild((Element)dscntPropsr, (String)"DscNam", (String)acnt.getAccName());
        JDomUtils.addChild((Element)dscntPropsr, (String)"DscTyp", (String)"RC01");
        JDomUtils.addChild((Element)dscntPropsr, (String)"DscOpBnk", (String)acnt.getCnaps());
        JDomUtils.addChild((Element)dscntPropsr, (String)"DscOpBnkNam", (String)acnt.getBankName());
        JDomUtils.addChild((Element)hermes, (String)"Note", (String)info2.getExplanation());
        Element corp = JDomUtils.addChild((Element)root, (String)"Corp");
        JDomUtils.addChild((Element)corp, (String)"CorpNo", (String)RequestContextUtils.getBankParameterValue((String)"CorpNo"));
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest bankNoteReceivableRequest, String s) {
        List noteReceivableInfos = bankNoteReceivableRequest.getNoteReceivableInfos();
        CommNotePacker.parserNoteReq(noteReceivableInfos, s);
        return noteReceivableInfos;
    }

    public static String genDateAnd6NumSequence() {
        String prefix = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        prefix = prefix.substring(2);
        String autoincrementNumber = Sequence.getAutoincrementNumber((int)4);
        return prefix + autoincrementNumber;
    }
}

