/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.spdb.dc.services.codeless.detail;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.note.banks.spdb.dc.services.codeless.detail.EndorseImpl;
import kd.ebg.note.banks.spdb.dc.services.util.Check;
import kd.ebg.note.banks.spdb.dc.services.util.Packer;
import kd.ebg.note.banks.spdb.dc.services.util.Parser;
import kd.ebg.note.banks.spdb.dc.services.util.Signature;
import kd.ebg.note.business.noteDetail.atomic.AbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequestBody;
import kd.ebg.note.business.noteDetail.util.PageUtil;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import kd.ebg.note.common.entity.biz.notedetail.NoteSidesInfo;
import org.jdom2.Element;

public class CodelssNoteHoldImpl
extends AbstractNoteDetailImpl {
    public static String totalPage = "0";

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "PJ21";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7968\u636e\u4fe1\u606f\u67e5\u8be2", (String)"CodelssNoteInfoImpl_0", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteDetailRequest noteDetailRequest) {
        return false;
    }

    public String pack(BankNoteDetailRequest request, String pagetag) {
        BankNoteDetailRequestBody body = request.getBody();
        Element root = new Element("body");
        JDomUtils.addChild((Element)root, (String)"eBillType", (String)body.getDraftType());
        JDomUtils.addChild((Element)root, (String)"transMasterID", (String)BankBusinessConfig.getPayMasterID(request.getAcnt().getAccNo()));
        JDomUtils.addChild((Element)root, (String)"beginDate", (String)LocalDateUtil.formatDate((LocalDate)LocalDate.now().plusMonths(-6L)));
        JDomUtils.addChild((Element)root, (String)"endDate", (String)LocalDateUtil.formatDate((LocalDate)LocalDate.now()));
        JDomUtils.addChild((Element)root, (String)"eBillStatus", (String)"2");
        JDomUtils.addChild((Element)root, (String)"eBillAcct", (String)request.getAcnt().getAccNo());
        int page = Integer.parseInt(pagetag) - 1;
        pagetag = page * 20 + 1 + "";
        JDomUtils.addChild((Element)root, (String)"beginNumber", (String)pagetag);
        JDomUtils.addChild((Element)root, (String)"queryNumber", (String)"20");
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("PJ21", signedMsg);
    }

    public List<Detail> parse(BankNoteDetailRequest rqst, String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse rsp = Parser.parseResponse(root);
        if (!"AAAAAAA".equals(rsp.getResponseCode())) {
            String errorMsg = StringUtils.catWithSpace((String[])new String[]{rsp.getResponseCode(), rsp.getResponseMessage()});
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        String rspData = Signature.getInstance().validateSignedData(rspStr);
        Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
        String totalNumber = body.getChildTextTrim("totalNumber");
        Element lists = Check.checkNoNullChildElement(body, "lists");
        List localList = lists.getChildren("list");
        ArrayList<Detail> result = new ArrayList<Detail>(16);
        for (Element element : localList) {
            Detail detailInfo = new Detail();
            String eBillStatus = element.getChildTextTrim("billStatusCode");
            detailInfo.setNoteStatus(eBillStatus);
            if ("CS05".equals(eBillStatus) || "CS06".equals(eBillStatus)) continue;
            result.add(detailInfo);
            String billPackageNo = element.getChildTextTrim("billPackageNo");
            detailInfo.setNoteNo(billPackageNo);
            String sonBillRngLow = element.getChildTextTrim("sonBillRngLow");
            detailInfo.setStartNo(sonBillRngLow);
            String sonBillRngHight = element.getChildTextTrim("sonBillRngHight");
            detailInfo.setEndNo(sonBillRngHight);
            String voteDate = element.getChildTextTrim("voteDate");
            detailInfo.setIssueDate(voteDate);
            String expiryDate = element.getChildTextTrim("expiryDate");
            detailInfo.setDueDate(expiryDate);
            String unpackFlag = element.getChildTextTrim("unpackFlag");
            detailInfo.setGrdBag(unpackFlag);
            String eBillType = element.getChildTextTrim("eBillType");
            detailInfo.setDraftType(eBillType);
            String eBillAmount = element.getChildTextTrim("eBillAmount");
            detailInfo.setAmount(eBillAmount);
            String canTransferFlag = element.getChildTextTrim("canTransferFlag");
            detailInfo.setTransferFlag(canTransferFlag);
            String billCirulateFlag = element.getChildTextTrim("billCirulateFlag");
            detailInfo.setIsNewECDS("0");
            detailInfo.setCirStatus(billCirulateFlag);
            String eDrawerName = element.getChildTextTrim("eDrawerName");
            String eDrawerAcctNo = element.getChildTextTrim("eDrawerAcctNo");
            String eDrawerBankNo = element.getChildTextTrim("eDrawerBankNo");
            String eDrawerBankName = element.getChildTextTrim("eDrawerBankName");
            detailInfo.setDrawerAccName(eDrawerName);
            detailInfo.setDrawerAccNo(eDrawerAcctNo);
            detailInfo.setDrawerCnapsCode(eDrawerBankNo);
            detailInfo.setDrawerBankName(eDrawerBankName);
            String acceptorName = element.getChildTextTrim("acceptorName");
            String acceptorAcctNo = element.getChildTextTrim("acceptorAcctNo");
            String acceptorBankNo = element.getChildTextTrim("acceptorBankNo");
            String acceptorBankName = element.getChildTextTrim("acceptorBankName");
            detailInfo.setAcceptorAccName(acceptorName);
            detailInfo.setAcceptorAccNo(acceptorAcctNo);
            detailInfo.setAcceptorCnapsCode(acceptorBankNo);
            detailInfo.setAcceptorBankName(acceptorBankName);
            String takerName = element.getChildTextTrim("ePayeeAcctName");
            String takerAcctNo = element.getChildTextTrim("ePayeeAcctNo");
            String takerBankNo = element.getChildTextTrim("ePayeeBankNo");
            String takerBankName = element.getChildTextTrim("ePayeeBankName");
            detailInfo.setPayeeAccName(takerName);
            detailInfo.setPayeeAccNo(takerAcctNo);
            detailInfo.setPayeeCnapsCode(takerBankNo);
            detailInfo.setPayeeBankName(takerBankName);
            String settleType = element.getChildTextTrim("settleType");
            detailInfo.setSettleWay(settleType);
            String liquidityType = element.getChildTextTrim("liquidityType");
            detailInfo.setClearType(liquidityType);
            try {
                EndorseImpl impl = new EndorseImpl();
                List<NoteSidesInfo> sides = impl.getMessage(billPackageNo, sonBillRngLow, sonBillRngHight);
                detailInfo.setNoteSidesInfo(sides);
            }
            catch (Exception e) {
                detailInfo.setIsNoteSidesError("Y");
            }
        }
        return result;
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse rsp = Parser.parseResponse(root);
        if (!"AAAAAAA".equals(rsp.getResponseCode())) {
            return null;
        }
        String rspData = Signature.getInstance().validateSignedData(rspStr);
        Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
        String totalNumber = body.getChildTextTrim("totalNumber");
        totalPage = PageUtil.totalPage((String)totalNumber, (int)20);
        Integer page = Integer.parseInt(pageTag);
        if (page >= Integer.parseInt(totalPage)) {
            return null;
        }
        return page * 20 + 1 + "";
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        return StringUtils.isEmpty((String)pageTag);
    }
}

