/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.spdb.dc.services.codeless.payable.register;

import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.spdb.dc.services.codeless.payable.QueryResultUtil;
import kd.ebg.note.banks.spdb.dc.services.util.Check;
import kd.ebg.note.banks.spdb.dc.services.util.Parser;
import kd.ebg.note.banks.spdb.dc.services.util.Signature;
import kd.ebg.note.business.notePayable.atomic.AbstractQueryNotePayableImpl;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.business.util.NoteStatusUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class QueryRegisterImpl
extends AbstractQueryNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryRegisterImpl.class);

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "PJ28";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5e94\u4ed8\u4ea4\u6613\u540c\u6b65\u63a5\u53e3", (String)"QueryPayableImpl_0", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return false;
    }

    public String pack(BankNotePayableRequest bankNotePayableRequest, String s) {
        return QueryResultUtil.packerPayable(bankNotePayableRequest.getNotePayableInfosAsArray());
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String rspStr) {
        List infos = request.getNotePayableInfoList();
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse rsp = Parser.parseResponse(root);
        String code = rsp.getResponseCode();
        if (!"AAAAAAA".equals(code)) {
            EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)code, (String)rsp.getResponseMessage());
        } else {
            String rspData = Signature.getInstance().validateSignedData(rspStr);
            Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
            Element lists = Check.checkNoNullChildElement(body, "lists");
            List localList = lists.getChildren("list");
            for (Element element : localList) {
                String seqNo = element.getChildTextTrim("seqNo");
                this.logger.info("\u5f00\u59cb\u5339\u914d\u5e8f\u53f7:" + seqNo);
                NotePayableInfo info = this.selectPayableInfo(infos, seqNo);
                if (info == null) continue;
                this.logger.info("\u5339\u914d\u6210\u529f\u6d41\u6c34\u53f7:" + info.getDetailSeqId());
                String eBillStatus = element.getChildTextTrim("eBillStatus");
                String billCirulateFlag = element.getChildTextTrim("billCirulateFlag");
                info.setNoteStatus(eBillStatus);
                info.setCirStatus(billCirulateFlag);
                String pcsStatusMsg = element.getChildTextTrim("pcsStatusMsg");
                String failReason = element.getChildTextTrim("failReason");
                String businessSeqNo = element.getChildTextTrim("businessSeqNo");
                info.setBankRefKey(businessSeqNo);
                String status = element.getChildTextTrim("status");
                String billPackageNo = element.getChildTextTrim("billPackageNo");
                String sonBillRngLow = element.getChildTextTrim("sonBillRngLow");
                String sonBillRngHight = element.getChildTextTrim("sonBillRngHight");
                info.setBillNo(billPackageNo);
                info.setStartNo(sonBillRngLow);
                info.setEndNo(sonBillRngHight);
                if ("04".equals(pcsStatusMsg) || "08".equals(pcsStatusMsg) || "09".equals(pcsStatusMsg)) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.FAIL, (String)pcsStatusMsg, (String)failReason);
                    continue;
                }
                if ("06".equals(pcsStatusMsg)) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)pcsStatusMsg, (String)failReason);
                    continue;
                }
                NoteStatusUtils.parseOldNoteStatus(Collections.singletonList(info), (String)info.getObssid());
            }
        }
        return infos;
    }

    public NotePayableInfo selectPayableInfo(List<NotePayableInfo> infos, String seqNo) {
        for (NotePayableInfo info : infos) {
            if (!String.format("%04d", Integer.parseInt(info.getBankSerialNo())).equals(seqNo)) continue;
            return info;
        }
        return null;
    }

    public int getBatchSize() {
        return 0;
    }
}

