/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.spdb.dc.services.note.payable.register;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.spdb.dc.services.note.payable.EE28Utils;
import kd.ebg.note.banks.spdb.dc.services.util.Parser;
import kd.ebg.note.banks.spdb.dc.services.util.Signature;
import kd.ebg.note.business.notePayable.atomic.AbstractQueryNotePayableImpl;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.framework.utils.ParserUtils;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class QueryRegisterNotePayableImpl
extends AbstractQueryNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryRegisterNotePayableImpl.class);

    public String pack(BankNotePayableRequest request, String pageTag) {
        this.logger.info("\u6ce8\u518a\u67e5\u8a62\u6253\u5305");
        return EE28Utils.Pack(request, pageTag);
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String rspStr) {
        this.logger.info("\u6ce8\u518a\u89e3\u6790\u5f00\u59cb");
        List notePayable = request.getNotePayableInfoList();
        NotePayableInfo payableInfo = (NotePayableInfo)notePayable.get(0);
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse rsp = Parser.parseResponse(root);
        if (!"AAAAAAA".equals(rsp.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)payableInfo, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            String rspData = Signature.getInstance().validateSignedData(rspStr);
            Element body = JDomUtils.string2Root((String)rspData, (String)encoding);
            Element dtlListElement = body.getChild("lists");
            List dtlLists = dtlListElement.getChildren("list");
            for (Element p : dtlLists) {
                int index = dtlLists.indexOf(p);
                String status = p.getChildText("status");
                String eBillStatus = ParserUtils.checkUnNullableElement((Element)p, (String)"eBillStatus");
                String billNo = p.getChildText("billNo");
                String transJnlNo = p.getChildText("transJnlNo");
                payableInfo = (NotePayableInfo)notePayable.get(index);
                payableInfo.setBillNo(billNo);
                payableInfo.setReserved1(transJnlNo);
                if (eBillStatus.equals("-")) {
                    payableInfo.setNoteStatus("");
                } else {
                    payableInfo.setNoteStatus(eBillStatus);
                }
                switch (status) {
                    case "00": {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)payableInfo, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u94f6\u884c\u672a\u5904\u7406", (String)"QueryRegisterNotePayableImpl_0", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                        break;
                    }
                    case "01": {
                        if (eBillStatus.equals("020001") || eBillStatus.equals("030001")) {
                            EBGNotePayableUtils.setPaymentState((NotePayableInfo)payableInfo, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u4e00\u952e\u5f00\u7968\u5904\u7406\u6210\u529f\uff0c\u8bf7\u7a0d\u540e\u7b7e\u6536\u518d\u540c\u6b65\u72b6\u6001\u3002", (String)"QueryRegisterNotePayableImpl_1", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                            break;
                        }
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)payableInfo, (PaymentState)PaymentState.SUCCESS, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u5904\u7406\u6210\u529f", (String)"QueryRegisterNotePayableImpl_2", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                        break;
                    }
                    case "02": {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)payableInfo, (PaymentState)PaymentState.FAIL, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25", (String)"QueryRegisterNotePayableImpl_3", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                        break;
                    }
                    case "03": {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)payableInfo, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u5df2\u53d1\u9001", (String)"QueryRegisterNotePayableImpl_4", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                        break;
                    }
                    case "04": {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)payableInfo, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"QueryRegisterNotePayableImpl_5", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                        break;
                    }
                    case "05": {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)payableInfo, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5ba1\u6838\u4e2d", (String)"QueryRegisterNotePayableImpl_6", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                        break;
                    }
                    case "06": {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)payableInfo, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u88ab\u94f6\u884c\u62d2\u7edd", (String)"QueryRegisterNotePayableImpl_7", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                    }
                }
            }
        }
        return notePayable;
    }

    public int getBatchSize() {
        return 1;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u51fa\u7968\u540c\u6b65", (String)"QueryRegisterNotePayableImpl_8", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }
}

