/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.spdb.dc.services.note.receivable.discount;

import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.note.banks.spdb.dc.services.note.receivable.discount.QueryDiscountNoteReceivableImpl;
import kd.ebg.note.banks.spdb.dc.services.util.Packer;
import kd.ebg.note.banks.spdb.dc.services.util.Parser;
import kd.ebg.note.banks.spdb.dc.services.util.Signature;
import kd.ebg.note.banks.spdb.dc.services.util.Utils;
import kd.ebg.note.business.SameBankUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class DiscountNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryDiscountNoteReceivableImpl.class;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List receivableInfos = request.getNoteReceivableInfos();
        int length = receivableInfos.size();
        BankAcnt acnt = request.getAcnt();
        BigDecimal totalAmount = BigDecimal.ZERO;
        NoteReceivableInfo info = (NoteReceivableInfo)receivableInfos.get(0);
        Element body = new Element("body");
        String transID = BankBusinessConfig.getPayMasterID(request.getAcnt().getAccNo());
        if (transID == null) {
            JDomUtils.addChild((Element)body, (String)"transMasterID", (String)RequestContextUtils.getBankParameterValue((String)"masterIds"));
        } else {
            JDomUtils.addChild((Element)body, (String)"transMasterID", (String)transID);
        }
        JDomUtils.addChild((Element)body, (String)"totalNumber", (String)Utils.fixed(length + "", " ", 4, false));
        boolean isSameBank = false;
        if (info.getPayeeBankName() != null) {
            if (SameBankUtil.isSameBank((String)EBContext.getContext().getBankVersionID(), (String)info.getPayeeBankName()).equals("1")) {
                isSameBank = true;
                JDomUtils.addChild((Element)body, (String)"discountBankType", (String)"00");
            } else {
                JDomUtils.addChild((Element)body, (String)"discountBankType", (String)"01");
            }
        }
        JDomUtils.addChild((Element)body, (String)"discountType", (String)"RM00");
        JDomUtils.addChild((Element)body, (String)"applyDiscountDate", (String)info.getBookingDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"discountTxType", (String)"TT00");
        if (isSameBank) {
            JDomUtils.addChild((Element)body, (String)"discountRate");
        } else {
            JDomUtils.addChild((Element)body, (String)"discountRate", (String)info.getDisCountRate());
        }
        JDomUtils.addChild((Element)body, (String)"interestType", (String)info.getDiscountType());
        JDomUtils.addChild((Element)body, (String)"recordedAcctNo", (String)info.getAcceptorAccNo());
        if (isSameBank) {
            JDomUtils.addChild((Element)body, (String)"recordedBankNo");
        } else {
            JDomUtils.addChild((Element)body, (String)"recordedBankNo", (String)info.getAcceptorBankCnaps());
        }
        JDomUtils.addChild((Element)body, (String)"discounterType", (String)"RC01");
        JDomUtils.addChild((Element)body, (String)"discounterName", (String)acnt.getAccName());
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)body, (String)"discounterBankNo", (String)acnt.getCnaps());
        if (isSameBank) {
            JDomUtils.addChild((Element)body, (String)"discounteeName", (String)"0");
            JDomUtils.addChild((Element)body, (String)"discounteeAcctNo", (String)"0");
            JDomUtils.addChild((Element)body, (String)"discounteeBankNo", (String)"0");
        } else {
            JDomUtils.addChild((Element)body, (String)"discounteeName", (String)info.getPayeeAccName());
            JDomUtils.addChild((Element)body, (String)"discounteeAcctNo", (String)info.getPayeeAccNo());
            JDomUtils.addChild((Element)body, (String)"discounteeBankNo", (String)info.getPayeeBankCnaps());
        }
        if ("0".equals(info.getAutoAccept())) {
            JDomUtils.addChild((Element)body, (String)"liquidationType", (String)"SM00");
        } else {
            JDomUtils.addChild((Element)body, (String)"liquidationType", (String)"SM01");
        }
        JDomUtils.addChild((Element)body, (String)"liquidationType", (String)info.getOtherInfo());
        JDomUtils.addChild((Element)body, (String)"remark");
        JDomUtils.addChild((Element)body, (String)"agentMark", (String)"0");
        JDomUtils.addChild((Element)body, (String)"agentMasterId");
        JDomUtils.addChild((Element)body, (String)"agentName");
        JDomUtils.addChild((Element)body, (String)"agentAcctNo");
        JDomUtils.addChild((Element)body, (String)"batchType");
        Element cycle = Packer.creatCycleMessage();
        JDomUtils.addChild((Element)body, (Element)cycle);
        for (NoteReceivableInfo p : receivableInfos) {
            Element list = JDomUtils.addChild((Element)cycle, (String)"list");
            JDomUtils.addChild((Element)list, (String)"sequenceNo", (String)String.format("%04d", receivableInfos.indexOf(p)));
            JDomUtils.addChild((Element)list, (String)"billNo", (String)p.getBillNo());
            JDomUtils.addChild((Element)list, (String)"eBillAmount", (String)p.getAmount().toPlainString());
            if (SameBankUtil.isSameBank((String)EBContext.getContext().getBankVersionID(), (String)p.getPayeeBankName()).equals("1")) {
                JDomUtils.addChild((Element)list, (String)"discountAmount");
            } else {
                JDomUtils.addChild((Element)list, (String)"discountAmount", (String)p.getDisCountAmount());
            }
            JDomUtils.addChild((Element)list, (String)"bargainNo", (String)p.getContractNo());
            JDomUtils.addChild((Element)list, (String)"invoiceNo");
            JDomUtils.addChild((Element)list, (String)"canTransferFlag", (String)p.getTransferFlag());
            JDomUtils.addChild((Element)list, (String)"redemptionOpenDate");
            JDomUtils.addChild((Element)list, (String)"redemptionEndDate");
            JDomUtils.addChild((Element)list, (String)"redemptionRate");
            JDomUtils.addChild((Element)list, (String)"redemptionAmount");
            Double rate = Double.parseDouble(p.getDisCountRate());
            JDomUtils.addChild((Element)list, (String)"discountYearRate", (String)String.format("%.7f", rate));
            JDomUtils.addChild((Element)list, (String)"interestWay");
            JDomUtils.addChild((Element)list, (String)"interestRatio");
            totalAmount = p.getAmount().add(totalAmount);
        }
        JDomUtils.addChild((Element)body, (String)"totalAmount", (String)(totalAmount + ""));
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("EE07", signedMsg);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List infos = request.getNoteReceivableInfos();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = Parser.parseResponse(root);
        if (rsp.getResponseCode().startsWith("EYY")) {
            Element body = root.getChild("body");
            String message = body.getChildTextTrim("returnMsg");
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)message);
            return infos;
        }
        String rspData = Signature.getInstance().validateSignedData(responseStr);
        Element body = JDomUtils.string2Root((String)rspData, (String)encoding);
        if ("AAAAAAA".equals(rsp.getResponseCode())) {
            String businessId = body.getChildText("businessId");
            if (StringUtils.isEmpty((String)businessId)) {
                EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u65b0\u589e\u7968\u636e\u94f6\u884c\u672a\u8fd4\u56debusinessId,\u94f6\u4f01\u7968\u636e\u6d41\u7a0b\u65e0\u6cd5\u7ee7\u7eed", (String)"DiscountNoteReceivableImpl_2", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
            } else {
                ((NoteReceivableInfo)infos.get(0)).setBankRefKey(businessId);
                EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"DiscountNoteReceivableImpl_3", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
            }
        } else {
            String message = body.getChildTextTrim("returnMsg");
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)message);
        }
        return infos;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return false;
    }

    public long getBankInterval() {
        return 0L;
    }
}

