/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.spdb.dc.services.note.receivable.endorse;

import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.note.banks.spdb.dc.services.note.receivable.endorse.QueryEndorseNoteReceivableImpl;
import kd.ebg.note.banks.spdb.dc.services.util.Packer;
import kd.ebg.note.banks.spdb.dc.services.util.Parser;
import kd.ebg.note.banks.spdb.dc.services.util.Signature;
import kd.ebg.note.banks.spdb.dc.services.util.Utils;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class EndorseNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryEndorseNoteReceivableImpl.class;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List receivableInfos = request.getNoteReceivableInfos();
        BankAcnt acnt = request.getAcnt();
        int length = receivableInfos.size();
        NoteReceivableInfo info = (NoteReceivableInfo)receivableInfos.get(0);
        BigDecimal totalAmount = BigDecimal.ZERO;
        Element body = new Element("body");
        String transID = BankBusinessConfig.getPayMasterID(request.getAcnt().getAccNo());
        if (transID == null) {
            JDomUtils.addChild((Element)body, (String)"transMasterID", (String)RequestContextUtils.getBankParameterValue((String)"masterIds"));
        } else {
            JDomUtils.addChild((Element)body, (String)"transMasterID", (String)transID);
        }
        JDomUtils.addChild((Element)body, (String)"totalNumber", (String)Utils.fixed(length + "", " ", 4, false));
        JDomUtils.addChild((Element)body, (String)"remark");
        Element cycle = Packer.creatCycleMessage();
        JDomUtils.addChild((Element)body, (Element)cycle);
        for (NoteReceivableInfo p : receivableInfos) {
            Element list = JDomUtils.addChild((Element)cycle, (String)"list");
            JDomUtils.addChild((Element)list, (String)"sequenceNo", (String)String.format("%04d", receivableInfos.indexOf(p)));
            JDomUtils.addChild((Element)list, (String)"billNo", (String)info.getBillNo());
            BigDecimal eBillAmount = p.getAmount();
            JDomUtils.addChild((Element)list, (String)"eBillAmount", (String)eBillAmount.toPlainString());
            JDomUtils.addChild((Element)list, (String)"endorsederName", (String)acnt.getAccName());
            JDomUtils.addChild((Element)list, (String)"endorsederType", (String)"RC01");
            JDomUtils.addChild((Element)list, (String)"endorsederAcctNo", (String)acnt.getAccNo());
            JDomUtils.addChild((Element)list, (String)"endorsedApplyDate", (String)p.getBookingDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            JDomUtils.addChild((Element)list, (String)"endorsedeeName", (String)p.getPayeeAccName());
            JDomUtils.addChild((Element)list, (String)"endorsedeeAcctNo", (String)p.getPayeeAccNo());
            JDomUtils.addChild((Element)list, (String)"endorsedeeBankNo", (String)p.getPayeeBankCnaps());
            JDomUtils.addChild((Element)list, (String)"canTransferFlag", (String)p.getTransferFlag());
            totalAmount = eBillAmount.add(totalAmount);
        }
        JDomUtils.addChild((Element)body, (String)"totalAmount", (String)totalAmount.toPlainString());
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("EE12", signedMsg);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List infos = request.getNoteReceivableInfos();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = Parser.parseResponse(root);
        if (rsp.getResponseCode().startsWith("EYY")) {
            Element body = root.getChild("body");
            String message = body.getChildTextTrim("returnMsg");
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)message);
            return infos;
        }
        String rspData = Signature.getInstance().validateSignedData(responseStr);
        Element body = JDomUtils.string2Root((String)rspData, (String)encoding);
        if ("AAAAAAA".equals(rsp.getResponseCode())) {
            String businessId = body.getChildText("businessId");
            if (StringUtils.isEmpty((String)businessId)) {
                EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u65b0\u589e\u7968\u636e\u94f6\u884c\u672a\u8fd4\u56debusinessId,\u94f6\u4f01\u7968\u636e\u6d41\u7a0b\u65e0\u6cd5\u7ee7\u7eed", (String)"EndorseNoteReceivableImpl_0", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
            } else {
                ((NoteReceivableInfo)infos.get(0)).setBankRefKey(businessId);
                EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"EndorseNoteReceivableImpl_1", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
            }
        } else {
            String message = body.getChildTextTrim("returnMsg");
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)message);
        }
        return infos;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u80cc\u4e66", (String)"EndorseNoteReceivableImpl_2", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return false;
    }

    public long getBankInterval() {
        return 0L;
    }
}

