/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.bocom.dc.service.news.detail.endorsInfo;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.bocom.dc.service.BankBusinessConfig;
import kd.ebg.note.banks.bocom.dc.service.news.detail.endorsInfo.NoteInfoPacker;
import kd.ebg.note.banks.bocom.dc.service.news.detail.endorsInfo.NoteInfoParser;
import kd.ebg.note.banks.bocom.dc.service.news.detail.endorsInfo.ZLNoteInfoPacker;
import kd.ebg.note.banks.bocom.dc.service.news.detail.endorsInfo.ZLNoteInfoParser;
import kd.ebg.note.banks.bocom.dc.service.note.util.BOCOM_DC_Parser;
import kd.ebg.note.business.noteDetail.atomic.AbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequestBody;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import kd.ebg.note.common.entity.biz.notedetail.NoteSidesInfo;
import org.jdom2.Element;

public class EndorseInfoImpl
extends AbstractNoteDetailImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(EndorseInfoImpl.class);

    public List<NoteSidesInfo> getMessage(String billNo, String accNo, String startNo, String endNo) {
        ArrayList<NoteSidesInfo> list = new ArrayList<NoteSidesInfo>();
        try {
            NoteInfoParser parse;
            NoteInfoPacker packer;
            String bankParameterValue = BankBusinessConfig.getNOTEBACKINFO();
            if ("420102".equals(bankParameterValue)) {
                packer = new NoteInfoPacker();
                parse = new NoteInfoParser();
            } else {
                packer = new ZLNoteInfoPacker();
                parse = new ZLNoteInfoParser();
            }
            String rspStr = "";
            String rqstStr = packer.packNoteInfoRequest(billNo, accNo, startNo, endNo);
            this.logger.info("\u53d1\u9001\u6570\u636e" + rqstStr);
            ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
            IConnection conn = factory.createExchangeConnection();
            conn.openConnection();
            try (OutputStream os = conn.getOutputStream();){
                IOUtils.sendFully((OutputStream)os, (String)rqstStr);
                try (InputStream is = conn.getInputStream();){
                    rspStr = IOUtils.readFully((InputStream)is);
                    this.logger.info("\u63a5\u6536\u5230\u6570\u636e" + rspStr);
                    list.addAll(parse.parseNoteInfoResponse(rspStr));
                    conn.closeConnection();
                }
                catch (Exception e) {
                    String errorMsg = ResManager.loadKDString((String)"\u80cc\u9762\u4fe1\u606f\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38\u3002", (String)"EndorseInfoImpl_0", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]);
                    if (!StringUtils.isEmpty((String)e.getMessage())) {
                        errorMsg = String.format(ResManager.loadKDString((String)"\u80cc\u9762\u4fe1\u606f\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38:%s", (String)"EndorseInfoImpl_1", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]), e.getMessage());
                    }
                    throw EBExceiptionUtil.serviceException((String)errorMsg, (Throwable)e);
                }
            }
            catch (Exception e) {
                String errorMsg = ResManager.loadKDString((String)"\u80cc\u9762\u4fe1\u606f\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38\u3002", (String)"EndorseInfoImpl_0", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]);
                if (!StringUtils.isEmpty((String)e.getMessage())) {
                    errorMsg = String.format(ResManager.loadKDString((String)"\u80cc\u9762\u4fe1\u606f\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38:%s", (String)"EndorseInfoImpl_1", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]), e.getMessage());
                }
                throw EBExceiptionUtil.serviceException((String)errorMsg, (Throwable)e);
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return list;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "420102";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7968\u9762\u4fe1\u606f\u67e5\u8be2", (String)"EndorseInfoImpl_2", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteDetailRequest noteDetailRequest) {
        return true;
    }

    public String pack(BankNoteDetailRequest request, String s) {
        String bankParameterValue = BankBusinessConfig.getNOTEBACKINFO();
        NoteInfoPacker packer = "420102".equals(bankParameterValue) ? new NoteInfoPacker() : new ZLNoteInfoPacker();
        BankNoteDetailRequestBody info = request.getBody();
        return packer.packNoteInfoRequest(info.getNoteNo(), request.getAcnt().getAccNo(), info.getStartNo(), info.getEndNo());
    }

    public List<Detail> parse(BankNoteDetailRequest bankNoteDetailRequest, String rspStr) {
        ArrayList<Detail> result = new ArrayList<Detail>(1);
        Detail detail = new Detail();
        result.add(detail);
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element body = ap.getChild("body");
        BankResponse rsp = BOCOM_DC_Parser.parseRoot(ap);
        if (!rsp.getResponseCode().equals("0000")) {
            this.logger.info("\u7968\u9762\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38");
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7968\u9762\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38%s\u3002", (String)"EndorseInfoImpl_3", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]), rsp.getResponseMessage()));
        }
        String bankParameterValue = BankBusinessConfig.getNOTEBACKINFO();
        NoteInfoParser parse = "420102".equals(bankParameterValue) ? new NoteInfoParser() : new ZLNoteInfoParser();
        List<NoteSidesInfo> noteSidesInfos = parse.parseNoteInfoResponse(rspStr);
        detail.setNoteSidesInfo(noteSidesInfos);
        String transType = body.getChildTextTrim("Tp");
        detail.setDraftType(transType);
        String isseAmt = body.getChildTextTrim("IsseAmt");
        detail.setAmount(isseAmt);
        String ccy = body.getChildTextTrim("Ccy");
        detail.setCurrency(ccy);
        String isseDt = body.getChildTextTrim("IsseDt");
        detail.setIssueDate(isseDt);
        String dueDt = body.getChildTextTrim("DueDt");
        detail.setDueDate(dueDt);
        String banEndrsmtMk = body.getChildTextTrim("BanEndrsmtMk");
        detail.setTransferFlag(banEndrsmtMk);
        String sts = body.getChildTextTrim("Sts");
        detail.setNoteStatus(sts);
        String drwrAcctId = body.getChildTextTrim("DrwrAcctId");
        detail.setDrawerAccNo(drwrAcctId);
        String drwrNm = body.getChildTextTrim("DrwrNm");
        detail.setDrawerAccName(drwrNm);
        String drwrAcctSvcrNm = body.getChildTextTrim("DrwrAcctSvcrNm");
        detail.setDrawerBankName(drwrAcctSvcrNm);
        String pyeeAcctId = body.getChildTextTrim("PyeeAcctId");
        detail.setPayeeAccNo(pyeeAcctId);
        String pyeeAcctNm = body.getChildTextTrim("PyeeAcctNm");
        detail.setPayeeAccName(pyeeAcctNm);
        String pyeeAcctSvcrNm = body.getChildTextTrim("PyeeAcctSvcrNm");
        detail.setPayeeBankName(pyeeAcctSvcrNm);
        String accptrAcctId = body.getChildTextTrim("AccptrAcctId");
        detail.setAcceptorAccNo(accptrAcctId);
        String accptrNm = body.getChildTextTrim("AccptrNm");
        detail.setAcceptorAccName(accptrNm);
        String accptrAcctSvcrNm = body.getChildTextTrim("AccptrAcctSvcrNm");
        detail.setAcceptorBankName(accptrAcctSvcrNm);
        String hldrAcctId = body.getChildTextTrim("HldrAcctId");
        detail.setHolderAccNo(hldrAcctId);
        String hldrAcctSvcrNm = body.getChildTextTrim("HldrAcctSvcrNm");
        detail.setHolderBankName(hldrAcctSvcrNm);
        String drwrAcctSvcr = body.getChildTextTrim("DrwrAcctSvcr");
        detail.setDrawerCnapsCode(drwrAcctSvcr);
        String pyeeAcctSvcr = body.getChildTextTrim("PyeeAcctSvcr");
        detail.setPayeeCnapsCode(pyeeAcctSvcr);
        String accptrAcctSvcr = body.getChildTextTrim("AccptrAcctSvcr");
        detail.setAcceptorCnapsCode(accptrAcctSvcr);
        String hldrAcctSvcr = body.getChildTextTrim("HldrAcctSvcr");
        detail.setHolderCnapsCode(hldrAcctSvcr);
        String noteFlag = body.getChildTextTrim("NoteFlag");
        detail.setGrdBag(noteFlag);
        String noteStart = body.getChildTextTrim("NoteStart");
        detail.setStartNo(noteStart);
        String noteEnd = body.getChildTextTrim("NoteEnd");
        detail.setEndNo(noteEnd);
        String flowFlag = body.getChildTextTrim("FlowFlag");
        detail.setCirStatus(flowFlag);
        return result;
    }
}

