/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.bocom.dc.service.news.util;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.bocom.dc.service.news.util.BOCOM_DC_Parser;
import kd.ebg.note.banks.bocom.dc.service.news.util.NotestatusUtil;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class BOCOM_DC_NoteParser {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BOCOM_DC_NoteParser.class);

    public static void acceptReceiveCancleParse(List<NotePayableInfo> notePayableInfos, String rspStr) {
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot(ap);
        if ("0000".equals(rsp.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
    }

    public static void parseQueryPay(List<NoteReceivableInfo> noteReceivableInfos, String rspStr) {
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot(ap);
        if (!"0000".equals(rsp.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState(noteReceivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            Element body = ap.getChild("body");
            String mesgtype = body.getChildTextTrim("mesgtype");
            String credtim = body.getChildTextTrim("credtim");
            String prccd = body.getChildTextTrim("prccd");
            String prcmsg = body.getChildTextTrim("prcmsg");
            String IdNb = body.getChildTextTrim("IdNb");
            String noteStart = body.getChildTextTrim("NoteStart");
            String noteEnd = body.getChildTextTrim("NoteEnd");
            if ("0021".equals(prccd)) {
                EBGNoteReceivableUtils.setPaymentState(noteReceivableInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u8d34\u73b0\u529e\u7406\u5728\u9014\u4e2d\u5c1a\u672a\u5b8c\u6210", (String)"BOCOM_DC_NoteParser_0", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]), (String)"");
            } else if ("PE1I0000".equals(prccd)) {
                NoteReceivableInfo info = noteReceivableInfos.get(0);
                info.setStartNo(noteStart);
                info.setEndNo(noteEnd);
                info.setSubRange(noteStart + ',' + noteEnd);
                NotestatusUtil statusUtil = new NotestatusUtil();
                List<String> status = statusUtil.getStatus(info.getBillNo(), info.getDrawerAccNo(), noteStart, noteEnd);
                if (status != null) {
                    info.setNoteStatus(status.get(0));
                    info.setCirStatus(status.get(1));
                }
                if (StringUtils.isNotEmpty((String)prcmsg)) {
                    String[] split = prcmsg.split("\\|");
                    if (split[0].equals("R1") || split[0].equals("C1") || split[0].equals("C2") || split[0].equals("E1") || split[0].equals("E2")) {
                        EBGNoteReceivableUtils.setPaymentState(noteReceivableInfos, (PaymentState)PaymentState.FAIL, (String)prccd, (String)prcmsg);
                        info.setIsRefuse("1");
                    } else if (split[0].equals("A1") || split[0].equals("W1")) {
                        EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)prccd, (String)prcmsg);
                    } else if (split[0].equals("S1")) {
                        info.setCirStatus("TF0301");
                        EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)prccd, (String)prcmsg);
                    } else {
                        EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)prccd, (String)prcmsg);
                    }
                }
            } else if ("P0000000".equals(prccd)) {
                EBGNoteReceivableUtils.setPaymentState(noteReceivableInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BOCOM_DC_NoteParser_1", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u7968\u4ea4\u6240\u5904\u7406\u4e2d", (String)"BOCOM_DC_NoteParser_2", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]));
            } else if (StringUtils.isEmpty((String)prccd)) {
                EBGNoteReceivableUtils.setPaymentState(noteReceivableInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BOCOM_DC_NoteParser_1", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u7968\u4ea4\u6240\u5904\u7406\u4e2d", (String)"BOCOM_DC_NoteParser_2", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]));
            } else {
                EBGNoteReceivableUtils.setPaymentState(noteReceivableInfos, (PaymentState)PaymentState.FAIL, (String)prccd, (String)prcmsg);
                noteReceivableInfos.get(0).setIsRefuse("0");
            }
        }
    }

    public static void parseQueryRegister(List<NotePayableInfo> notePayableInfos, String rspStr) {
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot(ap);
        if (!"0000".equals(rsp.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            Element body = ap.getChild("body");
            String mesgtype = body.getChildTextTrim("mesgtype");
            String credtim = body.getChildTextTrim("credtim");
            String prccd = body.getChildTextTrim("prccd");
            String prcmsg = body.getChildTextTrim("prcmsg");
            String IdNb = body.getChildTextTrim("IdNb");
            String noteStart = body.getChildTextTrim("NoteStart");
            String noteEnd = body.getChildTextTrim("NoteEnd");
            notePayableInfos.get(0).setStartNo(noteStart);
            notePayableInfos.get(0).setEndNo(noteEnd);
            if ("P0000000".equals(prccd)) {
                EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BOCOM_DC_NoteParser_1", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BOCOM_DC_NoteParser_1", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]));
            } else if ("PE1I0000".equals(prccd)) {
                if (!StringUtils.isEmpty((String)IdNb)) {
                    EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.SUCCESS, (String)"", (String)ResManager.loadKDString((String)"\u51fa\u7968\u5df2\u6210\u529f", (String)"BOCOM_DC_NoteParser_3", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]));
                    for (NotePayableInfo info : notePayableInfos) {
                        info.setNoteStatus("CS01");
                        info.setCirStatus("TF0101");
                        info.setBillNo(IdNb);
                    }
                } else {
                    EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BOCOM_DC_NoteParser_1", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BOCOM_DC_NoteParser_1", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]));
                }
            } else {
                EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"BOCOM_DC_NoteParser_4", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"BOCOM_DC_NoteParser_4", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]));
            }
        }
    }

    public static void queryAcceptReceiveCancleParser(List<NotePayableInfo> notePayableInfos, String rspStr) {
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot(ap);
        if (!"0000".equals(rsp.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            Element body = ap.getChild("body");
            String mesgtype = body.getChildTextTrim("mesgtype");
            String credtim = body.getChildTextTrim("credtim");
            String prccd = body.getChildTextTrim("prccd");
            String prcmsg = body.getChildTextTrim("prcmsg");
            String IdNb = body.getChildTextTrim("IdNb");
            String noteStart = body.getChildTextTrim("NoteStart");
            String noteEnd = body.getChildTextTrim("NoteEnd");
            NotestatusUtil statusUtil = new NotestatusUtil();
            for (NotePayableInfo info : notePayableInfos) {
                info.setStartNo(noteStart);
                info.setEndNo(noteEnd);
                info.setSubRange(noteStart + ',' + noteEnd);
                List<String> status = statusUtil.getStatus(info.getBillNo(), info.getDrawerAccNo(), noteStart, noteEnd);
                if (status == null) continue;
                info.setNoteStatus(status.get(0));
                info.setCirStatus(status.get(1));
                info.setStatusMsg(prcmsg);
            }
            if (prccd.equals("0021")) {
                EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u8d34\u73b0\u529e\u7406\u5728\u9014\u4e2d\u5c1a\u672a\u5b8c\u6210", (String)"BOCOM_DC_NoteParser_0", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]), (String)"");
            } else if ("PE1I0000".equals(prccd)) {
                String[] split;
                for (NotePayableInfo info : notePayableInfos) {
                    if (info.getCirStatus().equals("TF0302")) {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)prccd, (String)prcmsg);
                        continue;
                    }
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)prccd, (String)prcmsg);
                }
                if (StringUtils.isNotEmpty((String)prcmsg) && (split = prcmsg.split("\\|"))[0].equals("R1")) {
                    EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.FAIL, (String)prccd, (String)prcmsg);
                }
            } else if ("P0000000".equals(prccd)) {
                EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BOCOM_DC_NoteParser_1", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u7968\u4ea4\u6240\u5904\u7406\u4e2d", (String)"BOCOM_DC_NoteParser_2", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]));
            } else {
                EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.FAIL, (String)prccd, (String)prcmsg);
            }
        }
    }
}

