/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.bocom.dc.service.note.util;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.bocom.dc.service.note.util.BOCOM_DC_Parser;
import kd.ebg.note.banks.bocom.dc.service.note.util.NotestatusUtil;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.model.NoteReceivableInfo;
import kd.ebg.note.common.utils.PropertiesConstantsUtils;
import org.jdom2.Element;

public class BOCOM_DC_NoteParser {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BOCOM_DC_NoteParser.class);

    public static void acceptReceiveCancleParse(List<NotePayableInfo> notePayableInfos, String rspStr) {
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot(ap);
        if ("0000".equals(rsp.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
    }

    public static void parseQueryPay(List<NoteReceivableInfo> noteReceivableInfos, String rspStr) {
        block9: {
            String prcmsg;
            String prccd;
            block10: {
                block11: {
                    String status;
                    Element ap;
                    block8: {
                        String encoding = RequestContextUtils.getCharset();
                        ap = JDomUtils.string2Root((String)rspStr, (String)encoding);
                        BankResponse rsp = BOCOM_DC_Parser.parseRoot(ap);
                        if ("0000".equals(rsp.getResponseCode())) break block8;
                        EBGNoteReceivableUtils.setPaymentState(noteReceivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
                        break block9;
                    }
                    Element body = ap.getChild("body");
                    String mesgtype = body.getChildTextTrim("mesgtype");
                    String credtim = body.getChildTextTrim("credtim");
                    prccd = body.getChildTextTrim("prccd");
                    prcmsg = body.getChildTextTrim("prcmsg");
                    String IdNb = body.getChildTextTrim("IdNb");
                    if (!"PE1I0000".equals(prccd)) break block10;
                    if (mesgtype.equals("031010")) {
                        for (NoteReceivableInfo info : noteReceivableInfos) {
                            info.setNoteStatus("100006");
                        }
                    } else {
                        for (NoteReceivableInfo info : noteReceivableInfos) {
                            status = new NotestatusUtil().getStatus(info.getBillNo(), info.getDrawerAccNo());
                            info.setNoteStatus(status);
                            info.setStatusMsg(prcmsg);
                        }
                    }
                    if (!prcmsg.equals(PropertiesConstantsUtils.getValue((String)"signRefuse"))) break block11;
                    EBGNoteReceivableUtils.setPaymentState(noteReceivableInfos, (PaymentState)PaymentState.FAIL, (String)prccd, (String)prcmsg);
                    if (!mesgtype.equals("031010")) break block9;
                    for (NoteReceivableInfo info : noteReceivableInfos) {
                        status = new NotestatusUtil().getStatus(info.getBillNo(), info.getDrawerAccNo());
                        info.setNoteStatus(status);
                        info.setStatusMsg(prcmsg);
                    }
                    break block9;
                }
                EBGNoteReceivableUtils.setPaymentState(noteReceivableInfos, (PaymentState)PaymentState.SUCCESS, (String)prccd, (String)prcmsg);
                break block9;
            }
            if ("P0000000".equals(prccd)) {
                EBGNoteReceivableUtils.setPaymentState(noteReceivableInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BOCOM_DC_NoteParser_1", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u7968\u4ea4\u6240\u5904\u7406\u4e2d", (String)"BOCOM_DC_NoteParser_10", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]));
            } else {
                EBGNoteReceivableUtils.setPaymentState(noteReceivableInfos, (PaymentState)PaymentState.FAIL, (String)prccd, (String)prcmsg);
                for (NoteReceivableInfo info : noteReceivableInfos) {
                    String status = new NotestatusUtil().getStatus(info.getBillNo(), info.getDrawerAccNo());
                    info.setNoteStatus(status);
                    info.setStatusMsg(prcmsg);
                }
            }
        }
    }

    public static void parseQueryRegister(List<NotePayableInfo> notePayableInfos, String rspStr) {
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot(ap);
        if (!"0000".equals(rsp.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            Element body = ap.getChild("body");
            String mesgtype = body.getChildTextTrim("mesgtype");
            String credtim = body.getChildTextTrim("credtim");
            String prccd = body.getChildTextTrim("prccd");
            String prcmsg = body.getChildTextTrim("prcmsg");
            String IdNb = body.getChildTextTrim("IdNb");
            if ("P0000000".equals(prccd)) {
                EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BOCOM_DC_NoteParser_1", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BOCOM_DC_NoteParser_1", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]));
            } else if ("PE1I0000".equals(prccd)) {
                if (!StringUtils.isEmpty((String)IdNb)) {
                    EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.SUCCESS, (String)"", (String)ResManager.loadKDString((String)"\u51fa\u7968\u5df2\u6210\u529f", (String)"BOCOM_DC_NoteParser_3", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]));
                    for (NotePayableInfo info : notePayableInfos) {
                        info.setNoteStatus("010004");
                        info.setBillNo(IdNb);
                    }
                } else {
                    EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BOCOM_DC_NoteParser_1", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BOCOM_DC_NoteParser_1", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]));
                }
            } else {
                EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"BOCOM_DC_NoteParser_4", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"BOCOM_DC_NoteParser_4", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]));
            }
        }
    }

    public static void queryAcceptReceiveCancleParser(List<NotePayableInfo> notePayableInfos, String rspStr) {
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse rsp = BOCOM_DC_Parser.parseRoot(ap);
        NotePayableInfo info = notePayableInfos.get(0);
        if (!"0000".equals(rsp.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            Element body = ap.getChild("body");
            String Sts = body.getChildTextTrim("Sts");
            logger.info("\u7968\u636e\u72b6\u6001Sts:" + Sts);
            if (!StringUtils.isEmpty((String)Sts)) {
                if ("020001".equals(Sts)) {
                    EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BOCOM_DC_NoteParser_1", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BOCOM_DC_NoteParser_1", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]));
                    info.setNoteStatus("020001");
                } else if ("020006".equals(Sts)) {
                    EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u6210\u529f", (String)"BOCOM_DC_NoteParser_5", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u6210\u529f", (String)"BOCOM_DC_NoteParser_5", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]));
                    info.setNoteStatus("020006");
                } else if ("030001".equals(Sts)) {
                    EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BOCOM_DC_NoteParser_1", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BOCOM_DC_NoteParser_1", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]));
                    info.setNoteStatus("030001");
                } else if ("030006".equals(Sts)) {
                    EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u6210\u529f", (String)"BOCOM_DC_NoteParser_5", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u6210\u529f", (String)"BOCOM_DC_NoteParser_5", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]));
                    info.setNoteStatus("030006");
                } else if ("000002".equals(Sts)) {
                    EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u6210\u529f", (String)"BOCOM_DC_NoteParser_5", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u6210\u529f", (String)"BOCOM_DC_NoteParser_5", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]));
                    info.setNoteStatus("000002");
                } else if ("010004".equals(Sts)) {
                    EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u6210\u529f", (String)"BOCOM_DC_NoteParser_5", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u6210\u529f", (String)"BOCOM_DC_NoteParser_5", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]));
                    info.setNoteStatus("010004");
                } else {
                    EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"BOCOM_DC_NoteParser_7", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]), Sts), (String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"BOCOM_DC_NoteParser_7", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]), Sts));
                }
            } else {
                EBGNotePayableUtils.setPaymentState(notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"BOCOM_DC_NoteParser_7", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]), Sts), (String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%s\u3002", (String)"BOCOM_DC_NoteParser_7", (String)"ebg-note-banks-bocom-dc", (Object[])new Object[0]), Sts));
            }
        }
    }
}

