/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.common.framework.properties;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.constant.PropertiesOptions;
import kd.ebg.note.common.framework.properties.BusinessPropertyConfigType;
import kd.ebg.note.common.framework.properties.PropertyChecker;
import kd.ebg.note.common.framework.properties.PropertyConfig;
import kd.ebg.note.common.framework.properties.PropertyConfigItem;
import kd.ebg.note.common.framework.properties.PropertyName;

@Component
public class BusinessPropertyConfig
implements PropertyConfig {
    static final PropertyConfigItem PAY_FAIL_ON_NETWORK_ERROR = PropertyConfigItem.builder().key("pay_fail_on_network_error").name(ResManager.loadKDString((String)"\u4ed8\u6b3e\u4e0d\u91cd\u53d1", (String)"BusinessPropertyConfig_0", (String)"ebg-note-common", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u7f51\u7edc\u539f\u56e0(\u94f6\u4f01\u4e0e\u524d\u7f6e\u673a\u901a\u8baf\u5f02\u5e38)\u5bfc\u81f4\u6570\u636e\u63d0\u4ea4\u5931\u8d25\u65f6\uff0c\u8be5\u7b14\u4ed8\u6b3e\u4e0d\u518d\u63d0\u4ea4\uff0c\u4f1a\u88ab\u7f6e\u4e3a\u4ea4\u6613\u5931\u8d25\u3002", (String)"BusinessPropertyConfig_1", (String)"ebg-note-common", (Object[])new Object[0])).sourceNames(trueFalseCN).sourceValues(trueFalseEN).defaultValues(defaultTrue).checkers(Lists.newArrayList((Object[])new PropertyChecker[]{trueFalseChecker})).minValueNum(1).maxValueNum(1).type(BusinessPropertyConfigType.PAY_PARAM.getName()).mustInput(true).build();
    public static final PropertyConfigItem PAY_PRIORITY = PropertyConfigItem.builder().key("pay_priority").name(ResManager.loadKDString((String)"\u4ed8\u6b3e\u4f18\u5148\u5f00\u5173", (String)"BusinessPropertyConfig_2", (String)"ebg-note-common", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u914d\u7f6e\u4e3a'\u5f00'\u65f6,\u4ed8\u6b3e\u8bf7\u6c42\u4f18\u5148\u7ea7\u9ad8.\u914d\u7f6e\u4e3a'\u5173'\u65f6,\u5219\u4f18\u5148\u7ea7\u4e3a\u9ed8\u8ba4\u7684", (String)"BusinessPropertyConfig_3", (String)"ebg-note-common", (Object[])new Object[0])).sourceNames(onOffCN).sourceValues(onOffEN).defaultValues(defaultOff).minValueNum(1).maxValueNum(1).checkers(Lists.newArrayList((Object[])new PropertyChecker[]{onOffChecker})).type(BusinessPropertyConfigType.PAY_PARAM.getName()).mustInput(true).build();
    static final PropertyConfigItem USECN_TRANSFER = PropertyConfigItem.builder().key("usecn_transfer").name(ResManager.loadKDString((String)"\u7528\u9014\u8f6c\u5316\u5f00\u5173", (String)"BusinessPropertyConfig_4", (String)"ebg-note-common", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u7528\u9014\u8f6c\u5316\u5373\u4eceERP\u4e0a\u4f20\u7684\u6458\u8981\u4e2d\u83b7\u53d6\u7528\u9014\uff0c\u8fdb\u800c\u8f6c\u5316\u4e3a\u94f6\u884c\u7528\u9014\uff0c\u5982\u679c\u5f00\u542f\u5219\u6309\u6b64\u89c4\u5219\u8f6c\u5316\uff0c\u5173\u95ed\u7684\u8bdd\u53d6ERP\u4e0a\u4f20\u7684\u9ed8\u8ba4\u7528\u9014\u3002", (String)"BusinessPropertyConfig_5", (String)"ebg-note-common", (Object[])new Object[0])).sourceNames(onOffCN).sourceValues(onOffEN).defaultValues(defaultOff).minValueNum(1).maxValueNum(1).checkers(Lists.newArrayList((Object[])new PropertyChecker[]{onOffChecker})).type(BusinessPropertyConfigType.PAY_PARAM.getName()).mustInput(true).build();
    static final PropertyConfigItem PAYMENT_EXCEPTION_NOTICE_ENABLE = PropertyConfigItem.builder().key("payment_exception_notice_enable").name(ResManager.loadKDString((String)"\u5f02\u5e38\u652f\u4ed8\u63d0\u9192\u5f00\u5173\u3002", (String)"BusinessPropertyConfig_6", (String)"ebg-note-common", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u914d\u7f6e\u4e3a'\u5f00'\u65f6,\u5f53\u5b58\u5728\u7591\u4f3c\u91cd\u590d\u4ed8\u6b3e\u64cd\u4f5c\u65f6\uff0c\u5c06\u77ed\u4fe1\u63d0\u9192\u4ed8\u6b3e\u5f02\u5e38\u4fe1\u606f\u5230\u7528\u6237\u7ba1\u7406\u5458", (String)"BusinessPropertyConfig_7", (String)"ebg-note-common", (Object[])new Object[0])).sourceNames(onOffCN).sourceValues(onOffEN).defaultValues(defaultOn).minValueNum(1).maxValueNum(1).checkers(Lists.newArrayList((Object[])new PropertyChecker[]{onOffChecker})).type(BusinessPropertyConfigType.PAY_PARAM.getName()).mustInput(true).build();
    static final PropertyConfigItem PAYMENT_INCOME_ACCNOS = PropertyConfigItem.builder().key("payment_income_accnos").name(ResManager.loadKDString((String)"\u6536\u6b3e\u8d26\u53f7\u767d\u540d\u5355\u3002", (String)"BusinessPropertyConfig_8", (String)"ebg-note-common", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u5982\u679c\u6709\u586b\u6536\u6b3e\u8d26\u53f7\u767d\u540d\u5355\uff0c\u90a3\u4e48\u672c\u5ba2\u6237\u7684\u4ed8\u6b3e\u4e1a\u52a1\uff0c\u53ea\u80fd\u5bf9\u914d\u7f6e\u7684\u6536\u6b3e\u8d26\u53f7\u53d1\u8d77\u4ed8\u6b3e\u3002", (String)"BusinessPropertyConfig_9", (String)"ebg-note-common", (Object[])new Object[0])).minValueNum(0).maxValueNum(200).type(BusinessPropertyConfigType.PAY_PARAM.getName()).build();
    static final PropertyConfigItem NO_LONGER_QUERY_PAY_INTERVAL = PropertyConfigItem.builder().key("no_longer_query_pay_interval").name(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u4e0d\u518d\u540c\u6b65\u72b6\u6001\u7684\u65f6\u95f4\u3002", (String)"BusinessPropertyConfig_10", (String)"ebg-note-common", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u72b6\u6001\u540c\u6b65\u65f6\uff0c'\u4ea4\u6613\u672a\u786e\u5b9a'\u7684\u4ed8\u6b3e\u5355\u5728\u4e00\u5b9a\u65f6\u95f4(\u4ee5\u63d2\u5165\u65f6\u95f4\u4e3a\u57fa\u51c6,\u9ed8\u8ba430\u5929)\u540e\u4e0d\u518d\u5411\u94f6\u884c\u53d1\u51fa\u540c\u6b65\u8bf7\u6c42\u3002", (String)"BusinessPropertyConfig_11", (String)"ebg-note-common", (Object[])new Object[0])).defaultValues(Lists.newArrayList((Object[])new String[]{"30"})).minValueNum(1).maxValueNum(1).checkers(Lists.newArrayList((Object[])new PropertyChecker[]{positiveIntegerChecker})).type(BusinessPropertyConfigType.SYNC_PAY_PARAM.getName()).build();
    static final PropertyConfigItem BIGMONEY_PAYMENT_NOTICE_AMOUNT = PropertyConfigItem.builder().key("bigmoney_payment_notice_amount").name(ResManager.loadKDString((String)"\u5355\u7b14\u5927\u989d\u652f\u4ed8\u63d0\u9192\u989d\u5ea6\u3002", (String)"BusinessPropertyConfig_12", (String)"ebg-note-common", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u8bbe\u7f6e\u4e3a0\u5c06\u65e0\u6548,\u5f53\u5355\u7b14\u5927\u989d\u652f\u4ed8\u91d1\u989d\u8d85\u8fc7\u8be5\u989d\u5ea6\u65f6\uff0c\u5c06\u77ed\u4fe1\u63d0\u9192\u81f3\u7528\u6237\u7ba1\u7406\u5458", (String)"BusinessPropertyConfig_13", (String)"ebg-note-common", (Object[])new Object[0])).type(BusinessPropertyConfigType.BIG_PAY_PARAM.getName()).build();
    static final PropertyConfigItem BIGMONEY_PAYMENT_NOTICE_ENABLE = PropertyConfigItem.builder().key("bigmoney_payment_notice_enable").name(ResManager.loadKDString((String)"\u5355\u7b14\u5927\u989d\u652f\u4ed8\u63d0\u9192\u5f00\u5173\u3002", (String)"BusinessPropertyConfig_14", (String)"ebg-note-common", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u914d\u7f6e\u4e3a'\u5f00'\u65f6,\u5f53\u89e6\u53d1\u5927\u989d\u652f\u4ed8\u65f6\uff0c\u5c06\u77ed\u4fe1\u63d0\u9192\u4ed8\u6b3e\u4fe1\u606f\u81f3\u7528\u6237\u7ba1\u7406\u5458", (String)"BusinessPropertyConfig_15", (String)"ebg-note-common", (Object[])new Object[0])).sourceNames(onOffCN).sourceValues(onOffEN).defaultValues(defaultOff).minValueNum(1).maxValueNum(1).checkers(Lists.newArrayList((Object[])new PropertyChecker[]{onOffChecker})).type(BusinessPropertyConfigType.BIG_PAY_PARAM.getName()).mustInput(true).build();
    static final PropertyConfigItem TODAY_DETAIL_LIMITTIME = PropertyConfigItem.builder().key("today_detail_limitTime").name(ResManager.loadKDString((String)"\u5f53\u65e5\u660e\u7ec6\u9650\u5236\u67e5\u8be2\u65f6\u95f4\u95f4\u9694", (String)"BusinessPropertyConfig_16", (String)"ebg-note-common", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u67e5\u8be2\u5f53\u65e5\u660e\u7ec6\uff0c\u53ef\u901a\u8fc7\u9650\u5236\u65f6\u95f4\u95f4\u9694\u6765\u63a7\u5236\u8bf7\u6c42\u9891\u7387\uff0c\u51cf\u5c11\u5bf9\u524d\u7f6e\u673a\u8d44\u6e90\u7684\u5360\u7528\u3002", (String)"BusinessPropertyConfig_17", (String)"ebg-note-common", (Object[])new Object[0])).defaultValues(Lists.newArrayList((Object[])new String[]{"30"})).sourceNames(Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u5173\u95ed", (String)"BusinessPropertyConfig_18", (String)"ebg-note-common", (Object[])new Object[0]), ResManager.loadKDString((String)"1\u5206\u949f", (String)"BusinessPropertyConfig_19", (String)"ebg-note-common", (Object[])new Object[0]), ResManager.loadKDString((String)"5\u5206\u949f", (String)"BusinessPropertyConfig_20", (String)"ebg-note-common", (Object[])new Object[0]), ResManager.loadKDString((String)"10\u5206\u949f", (String)"BusinessPropertyConfig_21", (String)"ebg-note-common", (Object[])new Object[0]), ResManager.loadKDString((String)"20\u5206\u949f", (String)"BusinessPropertyConfig_22", (String)"ebg-note-common", (Object[])new Object[0]), ResManager.loadKDString((String)"30\u5206\u949f", (String)"BusinessPropertyConfig_23", (String)"ebg-note-common", (Object[])new Object[0])})).sourceValues(Lists.newArrayList((Object[])new String[]{"0", "1", "5", "10", "20", "30"})).minValueNum(1).maxValueNum(1).mustInput(true).build();
    public static final PropertyConfigItem QUERY_PAY_COUNT_LIMIT = PropertyConfigItem.builder().key("QUERY_PAY_COUNT_LIMIT").name(ResManager.loadKDString((String)"\u4ed8\u6b3e\u540c\u6b65\u6b21\u6570\u6700\u5927\u503c", (String)"BusinessPropertyConfig_24", (String)"ebg-note-common", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u540c\u6b65\u6b21\u6570\u6700\u5927\u503c\uff0c\u5f53\u540c\u6b65\u6b21\u6570\u8fbe\u5230\u914d\u7f6e\u7684\u6700\u5927\u503c\u65f6\u4e0d\u518d\u540c\u6b65\u8be5\u7b14\u4ed8\u6b3e\u72b6\u6001\u3002", (String)"BusinessPropertyConfig_25", (String)"ebg-note-common", (Object[])new Object[0])).defaultValues(Lists.newArrayList((Object[])new String[]{"200"})).type(BusinessPropertyConfigType.SYNC_PAY_PARAM.getName()).build();
    public static final PropertyConfigItem PAYMENT_IS_SAME_IN_TIME_LIMITED = PropertyConfigItem.builder().key("PAYMENT_IS_SAME_IN_TIME_LIMITED").name(ResManager.loadKDString((String)"\u63d0\u4ea4\u94f6\u884c\u4ed8\u6b3e\u662f\u5426\u8fdb\u884c\u91cd\u590d\u8bb0\u5f55\u6821\u9a8c\u3002", (String)"BusinessPropertyConfig_26", (String)"ebg-note-common", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u914d\u7f6e\u4e3a'\u662f'\u65f6\uff0c\u94f6\u4f01\u4e91\u5e73\u53f0\u4f1a\u5f3a\u5236\u6821\u9a8c\u6458\u8981\u5373\u63d0\u4ea4\u94f6\u4f01\u5e73\u53f0\u7684\u4ed8\u6b3e\u6458\u8981\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u94f6\u4f01\u5e73\u53f0\u4f1a\u68c0\u67e5\u662f\u5426\u6709\u91cd\u590d\u7684\u4ed8\u6b3e\u8bb0\u5f55\u3002", (String)"BusinessPropertyConfig_27", (String)"ebg-note-common", (Object[])new Object[0])).sourceNames(trueFalseCN).sourceValues(trueFalseEN).defaultValues(defaultFalse).mustInput(true).build();
    public static final PropertyConfigItem PROXY_CERT_CHAIN_SWITCH = PropertyConfigItem.builder().key("PROXY_CERT_CHAIN_SWITCH").name(ResManager.loadKDString((String)"\u5b89\u5168\u4ee3\u7406\u81ea\u52a8\u67e5\u627e\u8bc1\u4e66\u94fe\u5f00\u5173", (String)"BusinessPropertyConfig_28", (String)"ebg-note-common", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u914d\u7f6e\u4e3a'\u662f'\uff0c\u94f6\u4f01\u4e91\u5e73\u53f0\u4f1a\u6839\u636e\u8bc1\u4e66\u94fe\u81ea\u52a8\u5bfb\u627e\u9a8c\u7b7e\u8bc1\u4e66\u3002\u914d\u7f6e\u4e3a'\u5426'\uff0c\u94f6\u4f01\u4e91\u5e73\u53f0\u4f1a\u9ed8\u8ba4\u8bc1\u4e66\u94fe\u7684\u7b2c\u4e00\u4e2a\u8bc1\u4e66\u7528\u4f5c\u9a8c\u7b7e", (String)"BusinessPropertyConfig_29", (String)"ebg-note-common", (Object[])new Object[0])).sourceNames(trueFalseCN).sourceValues(trueFalseEN).defaultValues(defaultFalse).mustInput(true).build();
    public static final String cosmicAppIdKey = "cosmic_app_id";
    public static final String cosmicApiUrlKey = "cosmic_api_url";
    public static final String cosmicAppSecuretKey = "cosmic_app_securet";
    public static final String cosmicUserNameKey = "cosmic_user_name";
    public static final String receiptFileUploadWayKey = "receipt_file_upload_way";
    public static final PropertyConfigItem receiptFileUploadWay = PropertyConfigItem.builder().key("receipt_file_upload_way").name(ResManager.loadKDString((String)"\u56de\u5355\u6587\u4ef6\u4e0a\u4f20\u65b9\u5f0f\u3002", (String)"BusinessPropertyConfig_30", (String)"ebg-note-common", (Object[])new Object[0])).sourceNames(Lists.newArrayList((Object[])new String[]{PropertiesOptions.getUploadWayCangqiong(), PropertiesOptions.getUploadWayKingdeeCloud()})).sourceValues(Lists.newArrayList((Object[])new String[]{PropertiesOptions.getUploadWayCangqiong(), PropertiesOptions.getUploadWayKingdeeCloud()})).defaultValues(Lists.newArrayList((Object[])new String[]{PropertiesOptions.getUploadWayCangqiong()})).type(BusinessPropertyConfigType.RECEIPT_UPLOAD_PARAM.getName()).mustInput(true).build();
    public static final PropertyConfigItem cosmicAppId = PropertyConfigItem.builder().key("cosmic_app_id").name(ResManager.loadKDString((String)"\u82cd\u7a79\u5f00\u653e\u5e73\u53f0appId\u3002", (String)"BusinessPropertyConfig_31", (String)"ebg-note-common", (Object[])new Object[0])).type(BusinessPropertyConfigType.RECEIPT_UPLOAD_PARAM.getName()).build();
    public static final PropertyConfigItem cosmicApiUrl = PropertyConfigItem.builder().key("cosmic_api_url").name(ResManager.loadKDString((String)"\u82cd\u7a79\u5f00\u653e\u5e73\u53f0api\u5730\u5740", (String)"BusinessPropertyConfig_32", (String)"ebg-note-common", (Object[])new Object[0])).type(BusinessPropertyConfigType.RECEIPT_UPLOAD_PARAM.getName()).build();
    public static final PropertyConfigItem cosmicAppSecuret = PropertyConfigItem.builder().key("cosmic_app_securet").name(ResManager.loadKDString((String)"\u82cd\u7a79\u5f00\u653e\u5e73\u53f0\u79d8\u94a5\u3002", (String)"BusinessPropertyConfig_33", (String)"ebg-note-common", (Object[])new Object[0])).type(BusinessPropertyConfigType.RECEIPT_UPLOAD_PARAM.getName()).build();
    public static final PropertyConfigItem cosmicUserName = PropertyConfigItem.builder().key("cosmic_user_name").name(ResManager.loadKDString((String)"\u82cd\u7a79\u5f00\u653e\u5e73\u53f0\u767b\u5f55\u7528\u6237\u540d", (String)"BusinessPropertyConfig_34", (String)"ebg-note-common", (Object[])new Object[0])).type(BusinessPropertyConfigType.RECEIPT_UPLOAD_PARAM.getName()).build();
    public static final PropertyConfigItem uploadPeriod = PropertyConfigItem.builder().key("upload_period").name(ResManager.loadKDString((String)"\u56de\u5355\u6587\u4ef6\u4e0a\u4f20\u5929\u6570\u3002", (String)"BusinessPropertyConfig_35", (String)"ebg-note-common", (Object[])new Object[0])).desc(ResManager.loadKDString((String)"\u8bbe\u7f6e\u4e00\u4e2a\u5929\u6570\u6bcf\u6b21\u6267\u884c\u65f6\u68c0\u67e5\u8fd9\u5929\u6570\u5185\u7684\u6587\u4ef6\u662f\u5426\u8981\u4e0a\u4f20\u5230\u9644\u4ef6\u670d\u52a1\u5668\uff0c\u9ed8\u8ba4\u4e3a180\u5929\u3002\u8bf7\u52ff\u968f\u610f\u4fee\u6539\u3002", (String)"BusinessPropertyConfig_36", (String)"ebg-note-common", (Object[])new Object[0])).defaultValues(Lists.newArrayList((Object[])new String[]{"180"})).type(BusinessPropertyConfigType.RECEIPT_UPLOAD_PARAM.getName()).mustInput(true).build();

    public static boolean isCertChain() {
        return PROXY_CERT_CHAIN_SWITCH.getCurrentValueAsBoolean();
    }

    public static int getTodayDetailLimitTime() {
        return TODAY_DETAIL_LIMITTIME.getCurrentValueAsInt();
    }

    public static int getBalanceLimitTime() {
        return 0;
    }

    public static boolean isOpenUseTransFer() {
        return USECN_TRANSFER.getCurrentValueAsBoolean();
    }

    public static boolean isBigPaymentNoticeEnable() {
        return BIGMONEY_PAYMENT_NOTICE_ENABLE.getCurrentValueAsBoolean();
    }

    public static boolean isPaymentExceptionNoticeEnable() {
        return PAYMENT_EXCEPTION_NOTICE_ENABLE.getCurrentValueAsBoolean();
    }

    public static BigDecimal getBigMoneyPaymentNoticeAmount() {
        String amount = BIGMONEY_PAYMENT_NOTICE_AMOUNT.getCurrentValue();
        try {
            return new BigDecimal(amount);
        }
        catch (Exception exception) {
            return new BigDecimal(0);
        }
    }

    public static List<String> getAllowedIncomeAccnos() {
        return PAYMENT_INCOME_ACCNOS.getCurrentValues();
    }

    public static int getQueryPayLimitNum() {
        try {
            int limitNum = Integer.parseInt(QUERY_PAY_COUNT_LIMIT.getCurrentValue());
            return limitNum;
        }
        catch (Exception e) {
            return 200;
        }
    }

    public static int getQueryPayDefaultNum() {
        try {
            return Integer.parseInt(QUERY_PAY_COUNT_LIMIT.getDefaultValues().get(0));
        }
        catch (Exception e) {
            return 200;
        }
    }

    public static final String getReceiptProxySftpPort() {
        return "0";
    }

    public static final String getReceiptProxySftpUser() {
        return "";
    }

    public static final String getReceiptProxySftpPwd() {
        return "";
    }

    public static final boolean isPaymentIsSameInTimeLimited() {
        return PAYMENT_IS_SAME_IN_TIME_LIMITED.getCurrentValueAsBoolean();
    }

    public static boolean isPayPriorityOpen() {
        return PAY_PRIORITY.getCurrentValueAsBoolean();
    }

    @Override
    public List<PropertyConfigItem> getAllPropertyConfigItems() {
        return Lists.newArrayList((Object[])new PropertyConfigItem[]{PAY_FAIL_ON_NETWORK_ERROR, USECN_TRANSFER, NO_LONGER_QUERY_PAY_INTERVAL, PAYMENT_INCOME_ACCNOS, BIGMONEY_PAYMENT_NOTICE_ENABLE, BIGMONEY_PAYMENT_NOTICE_AMOUNT, PAYMENT_EXCEPTION_NOTICE_ENABLE, TODAY_DETAIL_LIMITTIME, QUERY_PAY_COUNT_LIMIT, PAYMENT_IS_SAME_IN_TIME_LIMITED, PROXY_CERT_CHAIN_SWITCH, PAY_PRIORITY, receiptFileUploadWay, cosmicApiUrl, cosmicAppId, cosmicAppSecuret, cosmicUserName, uploadPeriod});
    }

    @Override
    public String getPropertyConfigID() {
        return "common_business";
    }

    @Override
    public PropertyName getPropertyName() {
        return PropertyName.COMMON_BUSINESS;
    }

    @Override
    public String getConfigName() {
        return ResManager.loadKDString((String)"\u4e1a\u52a1\u914d\u7f6e", (String)"BusinessPropertyConfig_37", (String)"ebg-note-common", (Object[])new Object[0]);
    }

    @Override
    public String getConfigDesc() {
        return ResManager.loadKDString((String)"\u901a\u7528\u4e1a\u52a1\u914d\u7f6e", (String)"BusinessPropertyConfig_38", (String)"ebg-note-common", (Object[])new Object[0]);
    }
}

