/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.common.framework.properties;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.framework.service.properties.ObjectPropertyService;
import kd.ebg.egf.common.model.properties.ObjectPropertiesKey;
import kd.ebg.note.common.framework.properties.BankPropertyConfig;
import kd.ebg.note.common.framework.properties.BusinessPropertyConfigType;
import kd.ebg.note.common.framework.properties.PropertyConfig;
import kd.ebg.note.common.framework.properties.PropertyConfigItem;
import kd.ebg.note.common.utils.SpringContextUtil;
import org.springframework.context.ApplicationContext;

@Component
public final class GlobalPropertyConfig {
    static ApplicationContext applicationContext;
    private final List<PropertyConfig> propertyConfigList;
    private List<PropertyConfig> bankPropertyConfig = Lists.newArrayList();
    private final BankAcntService bankAcntService;
    private final ObjectPropertyService objectPropertyService;
    private boolean init = false;

    public GlobalPropertyConfig(ApplicationContext context, List<PropertyConfig> propertyConfigList, BankAcntService bankAcntService, ObjectPropertyService objectPropertyService) {
        applicationContext = context;
        this.propertyConfigList = propertyConfigList;
        this.bankAcntService = bankAcntService;
        this.objectPropertyService = objectPropertyService;
    }

    public static GlobalPropertyConfig getInstance() {
        return SpringContextUtil.getBean(GlobalPropertyConfig.class);
    }

    public List<PropertyConfig> getPropertyConfigList() {
        return this.propertyConfigList;
    }

    public List<PropertyConfig> getBankPropertyConfig() {
        return this.bankPropertyConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configInit() {
        GlobalPropertyConfig globalPropertyConfig = this;
        synchronized (globalPropertyConfig) {
            if (!this.init) {
                for (PropertyConfig propertyConfig : this.propertyConfigList) {
                    if (BankPropertyConfig.class.isAssignableFrom(propertyConfig.getClass())) continue;
                    this.dealPropertyConfig(propertyConfig);
                }
            }
            this.init = true;
        }
    }

    private void dealPropertyConfig(PropertyConfig propertyConfig) {
        List<PropertyConfigItem> configItems = propertyConfig.getAllPropertyConfigItems();
        for (PropertyConfigItem item : configItems) {
            item.set_propertyConfig(propertyConfig);
        }
    }

    private void checkConfigItem(PropertyConfigItem configItem) {
        Preconditions.checkNotNull((Object)configItem, (Object)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u914d\u7f6e\u9879\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GlobalPropertyConfig_0", (String)"ebg-note-common", (Object[])new Object[0]));
        Preconditions.checkState((boolean)Objects.nonNull(configItem.get_propertyConfig()), (Object)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u914d\u7f6e\u9879\u6ca1\u6709\u521d\u59cb\u5316\u3002", (String)"GlobalPropertyConfig_1", (String)"ebg-note-common", (Object[])new Object[0]));
    }

    private ObjectPropertiesKey getKey(PropertyConfigItem configItem) {
        this.checkConfigItem(configItem);
        String customID = RequestContext.get().getTenantId();
        String objectID = configItem.get_propertyConfig().getPropertyConfigID();
        Preconditions.checkArgument((!"NAN".equalsIgnoreCase(objectID) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u8be5\u914d\u7f6e\u9700\u8981\u4f20\u5165 objectID\u3002", (String)"GlobalPropertyConfig_2", (String)"ebg-note-common", (Object[])new Object[0]));
        String objectName = configItem.get_propertyConfig().getPropertyName().name();
        if ("common_business".equalsIgnoreCase(objectID)) {
            objectName = BusinessPropertyConfigType.RECEIPT_UPLOAD_PARAM.getType().equals(configItem.getType()) ? "receipt" : "ebg";
        }
        String attrKey = configItem.getKey();
        ObjectPropertiesKey key = new ObjectPropertiesKey();
        key.setAttrKey(attrKey);
        key.setCustomID(customID);
        key.setObjectID(objectID);
        key.setObjectName(objectName);
        return key;
    }

    private ObjectPropertiesKey getKey(PropertyConfigItem configItem, String objectID) {
        this.checkConfigItem(configItem);
        String customID = RequestContext.get().getTenantId();
        String objectName = configItem.get_propertyConfig().getPropertyName().name();
        if ("common_business".equalsIgnoreCase(objectID)) {
            objectName = BusinessPropertyConfigType.RECEIPT_UPLOAD_PARAM.getType().equals(configItem.getType()) ? "receipt" : "ebg";
        }
        String attrKey = configItem.getKey();
        ObjectPropertiesKey key = new ObjectPropertiesKey();
        key.setAttrKey(attrKey);
        key.setCustomID(customID);
        key.setObjectID(objectID);
        key.setObjectName(objectName);
        return key;
    }

    public List<String> getConfigValues(PropertyConfigItem configItem) {
        this.configInit();
        List result = null;
        result = this.objectPropertyService.getPropertyValues(this.getKey(configItem));
        if (Objects.isNull(result) || result.isEmpty()) {
            result = configItem.getDefaultValues();
        }
        if (Objects.isNull(result)) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    public void setConfigValue(PropertyConfigItem configValue, String value) {
    }

    public void setConfigValues(PropertyConfigItem configValues, List<String> values) {
    }

    public String getConfigValue(PropertyConfigItem configItem) {
        List<String> result = this.getConfigValues(configItem);
        return result.isEmpty() ? "" : result.get(0);
    }

    public List<String> getConfigValues(PropertyConfigItem configItem, String objectID) {
        this.configInit();
        List<String> result = null;
        result = this.objectPropertyService.getPropertyValues(this.getKey(configItem, objectID));
        if (result.isEmpty()) {
            result = configItem.getDefaultValues();
        }
        return result;
    }

    public String getConfigValue(PropertyConfigItem configItem, String objectID) {
        List<String> result = this.getConfigValues(configItem, objectID);
        return result == null ? "" : (result.isEmpty() ? "" : result.get(0));
    }

    public boolean getConfigValueAsBoolean(PropertyConfigItem configItem) {
        return Boolean.parseBoolean(this.getConfigValue(configItem));
    }

    public synchronized void registryPropertyConfig(PropertyConfig propertyConfig) {
        this.bankPropertyConfig.add(propertyConfig);
        this.dealPropertyConfig(propertyConfig);
    }
}

