/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.common.framework.services;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.ebg.egf.common.annotation.Autowired;
import kd.ebg.egf.common.annotation.Service;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.zookeeper.node.SingleNodeIDGetter;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import kd.ebg.note.common.model.repository.NoteReceivableInfoRepository;
import kd.ebg.note.common.utils.SpringContextUtil;

@Service
public class NoteReceivableInfoService {
    private final String nodeId;
    EBGLogger log = EBGLogger.getInstance().getLogger(NoteReceivableInfoService.class);
    @Autowired
    private NoteReceivableInfoRepository noteReceivableInfoRepository;

    public NoteReceivableInfoService(SingleNodeIDGetter nodeIDGetter) {
        this.nodeId = nodeIDGetter.nodeID();
    }

    public static NoteReceivableInfoService getInstance() {
        return SpringContextUtil.getBean(NoteReceivableInfoService.class);
    }

    public List<NoteReceivableInfo> selectByBatchSeqID(String batchSeqID) {
        return this.noteReceivableInfoRepository.findByBatchSeqId(batchSeqID);
    }

    public boolean batchSeqIDExist(String batchSeqID) {
        return this.noteReceivableInfoRepository.countByBatchSeqId(batchSeqID) > 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<NoteReceivableInfo> save(List<NoteReceivableInfo> noteReceivableInfos) {
        List<NoteReceivableInfo> list;
        noteReceivableInfos.forEach(receivableInfo -> receivableInfo.setUpdateTime(LocalDateTime.now()));
        TXHandle h = TX.requiresNew();
        try {
            List<NoteReceivableInfo> result;
            list = result = this.noteReceivableInfoRepository.save(noteReceivableInfos);
        }
        catch (Exception e) {
            try {
                this.log.error("\u4ed8\u6b3e\u8bb0\u5f55\u5199\u5165\u51fa\u73b0\u5f02\u5e38" + e.getMessage());
                h.markRollback();
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u8bb0\u5f55\u5199\u5165\u51fa\u73b0\u5f02\u5e38\u3002", (String)"NoteReceivableInfoService_0", (String)"ebg-note-common", (Object[])new Object[0]), (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    h.close();
                    throw throwable;
                }
                catch (Throwable e2) {
                    this.log.error("\u5f02\u5e38", new Object[]{e2.getMessage()});
                }
                throw throwable;
            }
        }
        try {
            h.close();
            return list;
        }
        catch (Throwable e) {
            this.log.error("\u5f02\u5e38", new Object[]{e.getMessage()});
        }
        return list;
    }

    public boolean isBatchOwnMe(String bankBatchSeqId) {
        List<NoteReceivableInfo> noteReceivableInfos = this.noteReceivableInfoRepository.findByBankBatchSeqId(bankBatchSeqId);
        for (NoteReceivableInfo info : noteReceivableInfos) {
            if (Objects.equals(info.getEbgID(), this.nodeId)) continue;
            return false;
        }
        return true;
    }

    public List<NoteReceivableInfo> selectBankBatchSeqId(String bankBatchSeqId) {
        List<NoteReceivableInfo> noteReceivableInfos = this.noteReceivableInfoRepository.findByBankBatchSeqId(bankBatchSeqId);
        return noteReceivableInfos;
    }

    public List<NoteReceivableInfo> compareAndStateState(List<NoteReceivableInfo> noteReceivableInfos, PaymentState expectedState, PaymentState state) {
        for (NoteReceivableInfo info : noteReceivableInfos) {
            if (info.getStatus().intValue() != expectedState.getId()) {
                this.log.info("\u4ed8\u6b3e :{} \u7684\u72b6\u6001:{} \u4e0e\u9884\u671f\u7684\u72b6\u6001: {}\u4e0d\u4e00\u81f4", new Object[]{info.getId(), info.getStatus(), expectedState.getId()});
                return null;
            }
            info.setStatus(state.getId());
            info.setStatusMsg(state.getCnName());
            info.setStatusName(state.getEnName());
            info.setSubmitSuccessTime(LocalDateTime.now());
        }
        try {
            return this.save(noteReceivableInfos);
        }
        catch (Exception e) {
            String bankBatchSeqID = noteReceivableInfos.get(0).getBankBatchSeqId();
            this.log.warn("\u94f6\u884c\u6279\u6b21\u53f7\u4e3a:{}", new Object[]{bankBatchSeqID});
            this.log.warn("\u5c1d\u8bd5\u4fee\u6539\u72b6\u6001\u5931\u8d25", new Object[]{e});
            return null;
        }
    }

    private static NoteReceivableInfo format4Update(NoteReceivableInfo noteReceivableInfo) {
        NoteReceivableInfo cloned = new NoteReceivableInfo();
        cloned.setId(noteReceivableInfo.getId());
        EBContext context = EBContext.getContext();
        if (null != context) {
            cloned.setUpdateBatchSeq(context.getBankRequestSeq());
            cloned.setUpdateOperation(context.getSubBizName());
        }
        cloned.setUpdateTime(LocalDateTime.now());
        cloned.setStatus(noteReceivableInfo.getStatus());
        cloned.setBakStatus(noteReceivableInfo.getBakStatus());
        cloned.setSubmitCount(noteReceivableInfo.getSubmitCount());
        cloned.setSyncCount(noteReceivableInfo.getSyncCount());
        cloned.setTotalCount(noteReceivableInfo.getTotalCount());
        return cloned;
    }

    private static NoteReceivableInfo setNotePayableState(NoteReceivableInfo noteReceivalbeInfo, PaymentState status) {
        NoteReceivableInfo cloned = new NoteReceivableInfo();
        cloned.setId(noteReceivalbeInfo.getId());
        cloned.setStatus(status.getId());
        cloned.setBankStatus(noteReceivalbeInfo.getBankStatus());
        cloned.setBankMsg(noteReceivalbeInfo.getBankMsg());
        cloned.setReversedBizField(noteReceivalbeInfo.getReversedBizField());
        cloned.setReversedSysField(noteReceivalbeInfo.getReversedSysField());
        cloned.setReversed1(noteReceivalbeInfo.getReversed1());
        cloned.setReversed2(noteReceivalbeInfo.getReversed2());
        cloned.setReversed3(noteReceivalbeInfo.getReversed3());
        cloned.setReversed4(noteReceivalbeInfo.getReversed4());
        return cloned;
    }

    public List<NoteReceivableInfo> selectByBatchSeqIDAndDetailSeqID(String batchSeqID, String detailSeqID) {
        return this.noteReceivableInfoRepository.findByBatchSeqIDAndDetailSeqID(batchSeqID, detailSeqID);
    }
}

