/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.common.framework.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.note.common.framework.utils.HttpsException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

public class HttpsClientUtil {
    private static HttpClient httpClient = null;
    private static InputStream keyMaterialStream;
    private static InputStream trustMaterialStream;

    public void init(File keyMaterial, String keyPass, File trustMaterial, String trustPass) throws HttpsException {
        if (httpClient == null) {
            httpClient = this.createSSLClient(keyMaterial, keyPass, trustMaterial, trustPass);
        }
    }

    public void init(InputStream keyMaterial, String keyPass, InputStream trustMaterial, String trustPass) throws HttpsException {
        keyMaterialStream = keyMaterial;
        trustMaterialStream = trustMaterial;
        if (httpClient == null) {
            httpClient = this.createSSLClient(keyPass, trustPass);
        }
    }

    private HttpClient createSSLClient(String keyPass, String trustPass) throws HttpsException {
        try {
            KeyStore keyStore;
            SSLContext sc = null;
            if (trustPass == null || trustPass.trim().length() == 0) {
                keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                if (null == keyMaterialStream) {
                    throw new HttpsException(ResManager.loadKDString((String)"\u79c1\u94a5\u5185\u5bb9\u4e3a\u7a7a", (String)"HttpsClientUtil_0", (String)"ebg-note-common", (Object[])new Object[0]));
                }
                keyStore.load(keyMaterialStream, keyPass.toCharArray());
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                kmf.init(keyStore, keyPass.toCharArray());
                sc = SSLContext.getInstance("TLSv1.2");
                sc.init(kmf.getKeyManagers(), new TrustManager[]{new TrustAnyTrustManager()}, new SecureRandom());
            } else {
                keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                if (null == keyMaterialStream) {
                    throw new HttpsException(ResManager.loadKDString((String)"\u79c1\u94a5\u5185\u5bb9\u4e3a\u7a7a", (String)"HttpsClientUtil_0", (String)"ebg-note-common", (Object[])new Object[0]));
                }
                keyStore.load(keyMaterialStream, keyPass.toCharArray());
                if (null == trustMaterialStream) {
                    throw new HttpsException(ResManager.loadKDString((String)"\u516c\u94a5\u5185\u5bb9\u4e3a\u7a7a", (String)"HttpsClientUtil_1", (String)"ebg-note-common", (Object[])new Object[0]));
                }
                KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                try {
                    trustStore.load(trustMaterialStream, trustPass.toCharArray());
                }
                catch (Exception e) {
                    throw new HttpsException(ResManager.loadKDString((String)"\u516c\u94a5\u521d\u59cb\u5316\u52a0\u8f7d\u51fa\u9519\uff1a", (String)"HttpsClientUtil_2", (String)"ebg-note-common", (Object[])new Object[0]), e);
                }
                sc = SSLContexts.custom().loadKeyMaterial(keyStore, keyPass.toCharArray()).loadTrustMaterial(trustStore, null).useProtocol("SSL").build();
            }
            SSLConnectionSocketFactory s = new SSLConnectionSocketFactory(sc, (HostnameVerifier)new DefaultHostnameVerifier());
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)s).build();
        }
        catch (Exception e) {
            throw new HttpsException(ResManager.loadKDString((String)"\u521b\u5efa\u901a\u9053\u5931\u8d25", (String)"HttpsClientUtil_3", (String)"ebg-note-common", (Object[])new Object[0]), e);
        }
    }

    private HttpClient createSSLClient(File keyMaterial, String keyPass, File trustMaterial, String trustPass) throws HttpsException {
        try {
            KeyStore keyStore;
            SSLContext sc = null;
            if (trustMaterial == null) {
                keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                try (FileInputStream inputStream = new FileInputStream(keyMaterial);){
                    keyStore.load(inputStream, keyPass.toCharArray());
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                    kmf.init(keyStore, keyPass.toCharArray());
                    sc = SSLContext.getInstance("TLSv1.2");
                    sc.init(kmf.getKeyManagers(), new TrustManager[]{new TrustAnyTrustManager()}, new SecureRandom());
                }
            }
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            try (FileInputStream inputStrea = new FileInputStream(keyMaterial);){
                keyStore.load(inputStrea, keyPass.toCharArray());
                sc = SSLContexts.custom().loadKeyMaterial(keyStore, keyPass.toCharArray()).loadTrustMaterial(trustMaterial, trustPass.toCharArray()).useProtocol("SSL").build();
            }
            SSLConnectionSocketFactory s = new SSLConnectionSocketFactory(sc, (HostnameVerifier)new DefaultHostnameVerifier());
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)s).build();
        }
        catch (Exception e) {
            throw new HttpsException(ResManager.loadKDString((String)"\u521b\u5efa\u901a\u9053\u5931\u8d25", (String)"HttpsClientUtil_3", (String)"ebg-note-common", (Object[])new Object[0]), e);
        }
    }

    public String sendDataUseSSL(String url, String data, String charset) throws HttpsException {
        return this.sendData(url, data, charset);
    }

    public String sendDataUseSSL(String url, String data) throws HttpsException {
        return this.sendData(url, data, "utf-8");
    }

    private String sendData(String url, String data, String charset) throws HttpsException {
        if (httpClient == null) {
            throw new HttpsException(ResManager.loadKDString((String)"\u672a\u521d\u59cb\u5316", (String)"HttpsClientUtil_4", (String)"ebg-note-common", (Object[])new Object[0]));
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(3000).setConnectionRequestTimeout(3000).setSocketTimeout(3000).setRedirectsEnabled(true).build();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(requestConfig);
        httpPost.setHeader("Connection", "close");
        try {
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(data.getBytes(charset)));
            HttpResponse result = httpClient.execute((HttpUriRequest)httpPost);
            if (result != null) {
                String sb = null;
                if (result.getStatusLine().getStatusCode() == 200) {
                    sb = EntityUtils.toString((HttpEntity)result.getEntity());
                    return sb;
                }
                sb = "Error Response: " + result.getStatusLine().toString();
                return sb;
            }
            return ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25\uff0c\u670d\u52a1\u5668\u65e0\u54cd\u5e94\u3002", (String)"HttpsClientUtil_5", (String)"ebg-note-common", (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new HttpsException(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25:%s\u3002", (String)"HttpsClientUtil_7", (String)"ebg-note-common", (Object[])new Object[0]), e.getMessage()), e);
        }
    }

    public static void close() {
        httpClient = null;
    }

    private static class TrustAnyTrustManager
    implements X509TrustManager {
        private TrustAnyTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

