/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.common.model.repository;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.note.common.model.InstanceReg;

@Component
public class InstanceRegRepository {
    static final String entity = "aqap_instance_reg";
    static final String properties = "id,cluster_name,app_name,config_app_name,instance_name,ip_address,web_port,monitor_port,start_time,valid,node_path,host_name,type";
    final DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.S");

    public void save(List<InstanceReg> instanceRegList) {
        ArrayList<InstanceReg> insertList = new ArrayList<InstanceReg>(16);
        ArrayList<InstanceReg> updateList = new ArrayList<InstanceReg>(16);
        for (InstanceReg instanceReg : instanceRegList) {
            if (QueryServiceHelper.exists((String)entity, (Object)instanceReg.getId())) {
                updateList.add(instanceReg);
                continue;
            }
            insertList.add(instanceReg);
        }
        this.update(updateList);
        this.insert(insertList);
    }

    public List<InstanceReg> findAll() {
        ArrayList<InstanceReg> instanceRegs = new ArrayList<InstanceReg>(16);
        QFilter filter = QFilter.of((String)"type=?", (Object[])new Object[]{"ebg_aqap"});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)entity, (String)properties, (QFilter[])filter.toArray());
        if (dynamicObjects != null) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                InstanceReg instanceReg = new InstanceReg();
                instanceReg.setId(dynamicObject.getString("id"));
                instanceReg.setAppName(dynamicObject.getString("app_name"));
                instanceReg.setClusterName(dynamicObject.getString("cluster_name"));
                instanceReg.setConfigAppName(dynamicObject.getString("config_app_name"));
                instanceReg.setHostName(dynamicObject.getString("host_name"));
                instanceReg.setInstanceId(dynamicObject.getString("instance_name"));
                instanceReg.setIp(dynamicObject.getString("ip_address"));
                instanceReg.setWebPort(dynamicObject.getInt("web_port"));
                instanceReg.setMonitorPort(dynamicObject.getInt("monitor_port"));
                instanceReg.setNodePath(dynamicObject.getString("node_path"));
                instanceReg.setValid(dynamicObject.getBoolean("valid"));
                instanceReg.setType(dynamicObject.getString("type"));
                String time = dynamicObject.getString("start_time");
                instanceReg.setStartTime(LocalDateTime.parse(time, this.dtf));
                instanceRegs.add(instanceReg);
            }
        }
        return instanceRegs;
    }

    private void update(List<InstanceReg> instanceRegList) {
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(16);
        for (InstanceReg instanceReg : instanceRegList) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entity);
            dynamicObject.set("id", (Object)instanceReg.getId());
            dynamicObject.set("cluster_name", (Object)instanceReg.getClusterName());
            dynamicObject.set("app_name", (Object)instanceReg.getAppName());
            dynamicObject.set("config_app_name", (Object)instanceReg.getConfigAppName());
            dynamicObject.set("instance_name", (Object)instanceReg.getInstanceId());
            dynamicObject.set("ip_address", (Object)instanceReg.getIp());
            dynamicObject.set("web_port", (Object)instanceReg.getWebPort());
            dynamicObject.set("monitor_port", (Object)instanceReg.getMonitorPort());
            if (instanceReg.getStartTime() != null) {
                Date time = Date.from(instanceReg.getStartTime().atZone(ZoneId.systemDefault()).toInstant());
                dynamicObject.set("start_time", (Object)time);
            }
            dynamicObject.set("valid", (Object)instanceReg.isValid());
            dynamicObject.set("node_path", (Object)instanceReg.getNodePath());
            dynamicObject.set("host_name", (Object)instanceReg.getHostName());
            dynamicObject.set("type", (Object)instanceReg.getType());
            dynamicObject.set("status", (Object)"A");
            dynamicObjectList.add(dynamicObject);
        }
        DynamicObject[] dynamicObjects = dynamicObjectList.toArray(new DynamicObject[0]);
        SaveServiceHelper.update((DynamicObject[])dynamicObjects);
    }

    private void insert(List<InstanceReg> instanceRegList) {
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(16);
        for (InstanceReg instanceReg : instanceRegList) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entity);
            dynamicObject.set("cluster_name", (Object)instanceReg.getClusterName());
            dynamicObject.set("app_name", (Object)instanceReg.getAppName());
            dynamicObject.set("config_app_name", (Object)instanceReg.getConfigAppName());
            dynamicObject.set("instance_name", (Object)instanceReg.getInstanceId());
            dynamicObject.set("ip_address", (Object)instanceReg.getIp());
            dynamicObject.set("web_port", (Object)instanceReg.getWebPort());
            dynamicObject.set("monitor_port", (Object)instanceReg.getMonitorPort());
            if (instanceReg.getStartTime() != null) {
                Date time = Date.from(instanceReg.getStartTime().atZone(ZoneId.systemDefault()).toInstant());
                dynamicObject.set("start_time", (Object)time);
            }
            dynamicObject.set("valid", (Object)instanceReg.isValid());
            dynamicObject.set("node_path", (Object)instanceReg.getNodePath());
            dynamicObject.set("host_name", (Object)instanceReg.getHostName());
            dynamicObject.set("type", (Object)instanceReg.getType());
            dynamicObject.set("status", (Object)"A");
            dynamicObjectList.add(dynamicObject);
        }
        DynamicObject[] dynamicObjects = dynamicObjectList.toArray(new DynamicObject[0]);
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }
}

