/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cmbc.dc.services.note.payable.cancel;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cmbc.dc.services.note.payable.cancel.QueryCancleNotePayableImpl;
import kd.ebg.note.banks.cmbc.dc.services.util.NoteCancelUtil;
import kd.ebg.note.banks.cmbc.dc.services.util.Packer;
import kd.ebg.note.banks.cmbc.dc.services.util.Parser;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.bank.EBBankNotePayableResponse;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class CancleNotePayableImpl
extends AbstractNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(CancleNotePayableImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryCancleNotePayableImpl.class;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        List notePayableInfos = request.getNotePayableInfoList();
        NotePayableInfo info = (NotePayableInfo)notePayableInfos.get(0);
        String code = info.getOperationCode();
        this.logger.info("\u8fdb\u5165\u64a4\u9500\u5904\u7406\u7c7b\uff1a" + code);
        String transtype = null;
        if ("03".equals(code)) {
            transtype = "QryCancelableIssuanceDraft";
        } else if ("02".equals(code)) {
            transtype = "QryCancelAcceptDraft";
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u64a4\u9500\u7c7b\u578b\uff1a%s\u3002", (String)"CancleNotePayableImpl_4", (String)"ebg-note-banks-cmbc-dc", (Object[])new Object[0]), code));
        }
        NoteCancelUtil query = new NoteCancelUtil();
        Map<String, String> map = query.getinfo(transtype, info.getDrawerAccNo());
        String billno = map.get(info.getBillNo());
        if (StringUtils.isEmpty((String)billno)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8be5\u7968\u65e0\u6cd5\u64a4\u9500\uff0c\u8bf7\u786e\u8ba4\u7968\u636e\u72b6\u6001\u3002", (String)"CancleNotePayableImpl_1", (String)"ebg-note-banks-cmbc-dc", (Object[])new Object[0]));
        }
        if ("03".equals(code)) {
            Element root = Packer.createMessageWithHead("CancelIssuanceDraft");
            Element xdataBody = JDomUtils.addChild((Element)root, (String)"xDataBody");
            JDomUtils.addChild((Element)xdataBody, (String)"insId", (String)info.getBankBatchSeqId());
            JDomUtils.addChild((Element)xdataBody, (String)"appAcNo", (String)info.getDrawerAccNo());
            JDomUtils.addChild((Element)xdataBody, (String)"rgctId", (String)billno);
            return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
        }
        if ("02".equals(code)) {
            Element root = Packer.createMessageWithHead("CancelAcceptDraft");
            Element xdataBody = JDomUtils.addChild((Element)root, (String)"xDataBody");
            JDomUtils.addChild((Element)xdataBody, (String)"trnId", (String)Sequence.gen16Sequence());
            JDomUtils.addChild((Element)xdataBody, (String)"insId", (String)info.getBankBatchSeqId());
            JDomUtils.addChild((Element)xdataBody, (String)"appAcNo", (String)info.getDrawerAccNo());
            JDomUtils.addChild((Element)xdataBody, (String)"rgctId", (String)billno);
            return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u64a4\u9500\u7c7b\u578b\uff1a\u3002", (String)"CancleNotePayableImpl_0", (String)"ebg-note-banks-cmbc-dc", (Object[])new Object[0]), code));
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List notePayableInfos = request.getNotePayableInfoList();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = Parser.parseResponse(root);
        if (!"0".equals(rsp.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            Element xdatabody = root.getChild("xDataBody");
            String insId = xdatabody.getChildText("insId");
            ((NotePayableInfo)notePayableInfos.get(0)).setBankSerialNo(insId);
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u64a4\u9500\u63d0\u4ea4\u94f6\u884c\u6210\u529f\u3002", (String)"CancleNotePayableImpl_2", (String)"ebg-note-banks-cmbc-dc", (Object[])new Object[0]), (String)rsp.getResponseMessage());
        }
        return notePayableInfos;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u64a4\u9500", (String)"CancleNotePayableImpl_3", (String)"ebg-note-banks-cmbc-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return false;
    }

    public long getBankInterval() {
        return 0L;
    }

    public EBBankNotePayableResponse doBiz(BankNotePayableRequest request) {
        return this.doBizNoPage(request);
    }

    /*
     * Exception decompiling
     */
    public EBBankNotePayableResponse doBizNoPage(BankNotePayableRequest request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

