/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cmbc.dc.services.note.payable.register;

import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cmbc.dc.services.note.payable.register.QueryRegisterNotePayableImpl;
import kd.ebg.note.banks.cmbc.dc.services.util.Packer;
import kd.ebg.note.banks.cmbc.dc.services.util.Parser;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.bank.EBBankNotePayableResponse;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class RegisterNotePayableImpl
extends AbstractNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(RegisterNotePayableImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryRegisterNotePayableImpl.class;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        List notePayableInfos = request.getNotePayableInfoList();
        NotePayableInfo info = (NotePayableInfo)notePayableInfos.get(0);
        Element root = Packer.createMessageWithHead("IssueDraftAdd");
        Element xdataBody = JDomUtils.addChild((Element)root, (String)"xDataBody");
        JDomUtils.addChild((Element)xdataBody, (String)"trnId", (String)Sequence.gen16Sequence());
        JDomUtils.addChild((Element)xdataBody, (String)"insId", (String)info.getBankBatchSeqId());
        JDomUtils.addChild((Element)xdataBody, (String)"appAcNo", (String)info.getDrawerAccNo());
        if ("AC01".equals(info.getDraftType())) {
            JDomUtils.addChild((Element)xdataBody, (String)"billType", (String)"1");
        } else {
            JDomUtils.addChild((Element)xdataBody, (String)"billType", (String)"2");
        }
        JDomUtils.addChild((Element)xdataBody, (String)"billClass", (String)"2");
        LocalDate issue = info.getBookingDate();
        Date IssueDate = Date.from(issue.atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
        JDomUtils.addChild((Element)xdataBody, (String)"issueDt", (String)DateTimeUtils.format((Date)IssueDate, (String)"yyyyMMdd"));
        LocalDate due = info.getDueDate();
        Date dueDate = Date.from(due.atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
        JDomUtils.addChild((Element)xdataBody, (String)"dueDt", (String)DateTimeUtils.format((Date)dueDate, (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)xdataBody, (String)"billMoney", (String)info.getAmount().toString());
        JDomUtils.addChild((Element)xdataBody, (String)"remitter", (String)info.getDrawerAccName());
        JDomUtils.addChild((Element)xdataBody, (String)"remitterAcct", (String)info.getDrawerAccNo());
        JDomUtils.addChild((Element)xdataBody, (String)"remitterBank", (String)info.getDrawerBankName());
        JDomUtils.addChild((Element)xdataBody, (String)"remitterBankNo", (String)info.getDrawerBankCnaps());
        JDomUtils.addChild((Element)xdataBody, (String)"payee", (String)info.getPayeeAccName());
        JDomUtils.addChild((Element)xdataBody, (String)"payeeAcct", (String)info.getPayeeAccNo());
        JDomUtils.addChild((Element)xdataBody, (String)"payeeBank", (String)info.getPayeeBankName());
        JDomUtils.addChild((Element)xdataBody, (String)"payeeBankNo", (String)info.getPayeeBankCnaps());
        JDomUtils.addChild((Element)xdataBody, (String)"acceptor", (String)info.getAcceptorAccName());
        JDomUtils.addChild((Element)xdataBody, (String)"acceptorAcct", (String)info.getAcceptorAccNo());
        JDomUtils.addChild((Element)xdataBody, (String)"acceptorBank", (String)info.getAcceptorBankName());
        JDomUtils.addChild((Element)xdataBody, (String)"acceptorBankNo", (String)info.getAcceptorBankCnaps());
        JDomUtils.addChild((Element)xdataBody, (String)"banEndorsementMark", (String)"0");
        JDomUtils.addChild((Element)xdataBody, (String)"isReturnRgctId", (String)"1");
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List infos = request.getNotePayableInfoList();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = Parser.parseResponse(root);
        if (!"0".equals(rsp.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            Element xdatabody = root.getChild("xDataBody");
            String rgctId = xdatabody.getChildText("rgctId");
            if (StringUtils.isEmpty((String)rgctId)) {
                EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u65b0\u589e\u7968\u636e\u94f6\u884c\u672a\u8fd4\u56dergctId,\u94f6\u4f01\u7968\u636e\u6d41\u7a0b\u65e0\u6cd5\u7ee7\u7eed", (String)"RegisterNotePayableImpl_0", (String)"ebg-note-banks-cmbc-dc", (Object[])new Object[0]));
            } else {
                ((NotePayableInfo)infos.get(0)).setContractNo(rgctId);
                EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u63d0\u4ea4\u94f6\u884c\u6210\u529f", (String)"RegisterNotePayableImpl_1", (String)"ebg-note-banks-cmbc-dc", (Object[])new Object[0]));
            }
        }
        return infos;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u51fa\u7968", (String)"RegisterNotePayableImpl_2", (String)"ebg-note-banks-cmbc-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }

    public EBBankNotePayableResponse doBiz(BankNotePayableRequest request) {
        return this.doBizNoPage(request);
    }

    /*
     * Exception decompiling
     */
    public EBBankNotePayableResponse doBizNoPage(BankNotePayableRequest request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

