/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cmbc.dc.services.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cmbc.dc.services.util.DetailPageUtil;
import kd.ebg.note.banks.cmbc.dc.services.util.Packer;
import kd.ebg.note.banks.cmbc.dc.services.util.Parser;
import org.jdom2.Element;

public class NoteCancelUtil {
    public Map<String, String> getinfo(String code, String accno) {
        HashMap<String, String> map = new HashMap();
        DetailPageUtil page = new DetailPageUtil();
        try {
            String rspStr = "";
            String pageTag = page.getFirstPageTag();
            do {
                String rqstStr = this.packNoteInfoRequest(code, pageTag, accno);
                ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
                int length = rqstStr.getBytes(RequestContextUtils.getCharset()).length;
                factory.setHttpHeader("Content-Length", String.valueOf(length));
                factory.setUri(Packer.getURL());
                IConnection conn = factory.createExchangeConnection();
                conn.openConnection();
                try (OutputStream os = conn.getOutputStream();){
                    IOUtils.sendFully((OutputStream)os, (String)rqstStr);
                    try (InputStream is = conn.getInputStream();){
                        rspStr = IOUtils.readFully((InputStream)is);
                        conn.closeConnection();
                    }
                    catch (Exception e) {
                        throw EBExceiptionUtil.serviceException((Throwable)e);
                    }
                }
                catch (Exception e) {
                    throw EBExceiptionUtil.serviceException((Throwable)e);
                }
                map = this.parserNoteInfoResponse(rspStr, map);
            } while (!page.isLastPage(rspStr, pageTag = page.getNextPageTag(rspStr, pageTag)));
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return map;
    }

    public String packNoteInfoRequest(String code, String bussqNo, String accno) {
        if (StringUtils.isEmpty((String)bussqNo)) {
            bussqNo = "";
        }
        Element root = Packer.createMessageWithHead(code);
        Element xdataBody = JDomUtils.addChild((Element)root, (String)"xDataBody");
        JDomUtils.addChild((Element)xdataBody, (String)"trnId", (String)Sequence.gen16Sequence());
        JDomUtils.addChild((Element)xdataBody, (String)"pageSize", (String)"100");
        JDomUtils.addChild((Element)xdataBody, (String)"appAcNo", (String)accno);
        JDomUtils.addChild((Element)xdataBody, (String)"currentIndex", (String)bussqNo);
        if ("QryDiscountableBill".equals(code)) {
            JDomUtils.addChild((Element)xdataBody, (String)"billClass", (String)"2");
        }
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public Map parserNoteInfoResponse(String rspStr, Map map) throws ParseException {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse rsp = Parser.parseResponse(root);
        if (!"0".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u54cd\u5e94\u5f02\u5e38", (String)"NoteCancelUtil_0", (String)"ebg-note-banks-cmbc-dc", (Object[])new Object[0]));
        }
        if (-1 != rsp.getResponseMessage().indexOf(ResManager.loadKDString((String)"\u6ca1\u6709\u76f8\u5173\u7684\u4ea4\u6613\u8bb0\u5f55\u3002", (String)"NoteCancelUtil_1", (String)"ebg-note-banks-cmbc-dc", (Object[])new Object[0]))) {
            return map;
        }
        Element xdatabody = root.getChild("xDataBody");
        Element List2 = xdatabody.getChild("List");
        List elements = List2.getChildren("Map");
        for (Element element : elements) {
            String billNo = element.getChildText("billNo");
            String rgctId = element.getChildText("rgctId");
            map.put(billNo, rgctId);
        }
        return map;
    }
}

