/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cmbc.dc.services.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cmbc.dc.services.util.Packer;
import kd.ebg.note.banks.cmbc.dc.services.util.Parser;
import org.jdom2.Element;

public class NoteStatusUtil {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(NoteStatusUtil.class);

    public String getinfo(String bussqNo, String accno) {
        String noteNo = "";
        try {
            String rspStr = "";
            String rqstStr = this.packNoteInfoRequest(bussqNo, accno);
            ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
            int length = rqstStr.getBytes(RequestContextUtils.getCharset()).length;
            factory.setHttpHeader("Content-Length", String.valueOf(length));
            factory.setUri(Packer.getURL());
            IConnection conn = factory.createExchangeConnection();
            conn.openConnection();
            try (OutputStream os = conn.getOutputStream();){
                IOUtils.sendFully((OutputStream)os, (String)rqstStr);
                try (InputStream is = conn.getInputStream();){
                    rspStr = IOUtils.readFully((InputStream)is);
                    conn.closeConnection();
                }
                catch (Exception e) {
                    throw EBExceiptionUtil.serviceException((Throwable)e);
                }
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
            noteNo = this.parserNoteInfoResponse(rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return noteNo;
    }

    public String packNoteInfoRequest(String bussqNo, String accno) {
        if (StringUtils.isEmpty((String)bussqNo)) {
            bussqNo = "";
        }
        Element root = Packer.createMessageWithHead("QryDraftInfo");
        Element xdataBody = JDomUtils.addChild((Element)root, (String)"xDataBody");
        JDomUtils.addChild((Element)xdataBody, (String)"trnId", (String)Sequence.gen16Sequence());
        JDomUtils.addChild((Element)xdataBody, (String)"rgctId", (String)bussqNo);
        JDomUtils.addChild((Element)xdataBody, (String)"appAcNo", (String)accno);
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public String parserNoteInfoResponse(String rspStr) throws ParseException {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse rsp = Parser.parseResponse(root);
        if (!"0".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u54cd\u5e94\u5f02\u5e38", (String)"NoteStatusUtil_0", (String)"ebg-note-banks-cmbc-dc", (Object[])new Object[0]));
        }
        if (-1 != rsp.getResponseMessage().indexOf(ResManager.loadKDString((String)"\u6ca1\u6709\u76f8\u5173\u7684\u4ea4\u6613\u8bb0\u5f55\u3002", (String)"NoteStatusUtil_1", (String)"ebg-note-banks-cmbc-dc", (Object[])new Object[0]))) {
            return "";
        }
        Element xdatabody = root.getChild("xDataBody");
        String curStatusName = xdatabody.getChildText("curStatusName");
        this.logger.info("\u83b7\u53d6\u5230\u7684\u7968\u636e\u72b6\u6001\uff1a" + curStatusName);
        return curStatusName.trim();
    }
}

