/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cmbc.dc.services.util;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cmbc.dc.services.util.Constants;
import org.jdom2.Element;

public class Packer
implements Constants {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(Packer.class);

    public static String getURL() {
        String url = "";
        try {
            url = RequestContextUtils.getBankParameterValue((String)"URL");
        }
        catch (EBServiceException e) {
            log.info("\u83b7\u53d6\u94f6\u884c\u524d\u7f6e\u673aURL\u5730\u5740\u5f02\u5e38,\u5c06\u6b21\u91c7\u7528\u9ed8\u8ba4\u503c\uff1a/weblogic/servlets/EService/CSM/E2B/E2BSignServlet");
            log.warn(e.getMessage());
            return "/weblogic/servlets/EService/CSM/E2B/E2BSignServlet";
        }
        if (StringUtils.isEmpty((String)url)) {
            return "/weblogic/servlets/EService/CSM/E2B/E2BSignServlet";
        }
        if (!url.startsWith("/")) {
            url = "/" + url;
        }
        return url.trim();
    }

    public static Element createMessageWithHead(String transCode) throws EBServiceException {
        Element root = Packer.createMessage(transCode);
        Element headMessage = Packer.createHeadMessage();
        JDomUtils.addChild((Element)root, (Element)headMessage);
        return root;
    }

    private static Element createMessage(String transCode) {
        Element element = new Element("CMBC");
        element.setAttribute("header", "100");
        element.setAttribute("version", "100");
        element.setAttribute("security", "none");
        element.setAttribute("lang", RequestContextUtils.getCharset().equalsIgnoreCase("GBK") ? "chs" : RequestContextUtils.getCharset());
        element.setAttribute("trnCode", transCode);
        return element;
    }

    private static Element createHeadMessage() throws EBServiceException {
        Element element = new Element("requestHeader");
        JDomUtils.addChild((Element)element, (String)"dtClient", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        JDomUtils.addChild((Element)element, (String)"clientId", (String)RequestContextUtils.getBankParameterValue((String)"clientId"));
        JDomUtils.addChild((Element)element, (String)"userId", (String)RequestContextUtils.getBankParameterValue((String)"userId"));
        JDomUtils.addChild((Element)element, (String)"userPswd", (String)RequestContextUtils.getBankParameterValue((String)"userPswd"));
        JDomUtils.addChild((Element)element, (String)"language", (String)(RequestContextUtils.getCharset().equalsIgnoreCase("GBK") ? "chs" : RequestContextUtils.getCharset()));
        JDomUtils.addChild((Element)element, (String)"appId", (String)"nsbdes");
        JDomUtils.addChild((Element)element, (String)"appVer", (String)"201");
        return element;
    }

    public static String getBankNoteSubrange(String startNo) {
        while (startNo.startsWith("0") && startNo.length() > 1) {
            startNo = startNo.substring(1, startNo.length());
        }
        return startNo;
    }
}

