/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.business.notePayable;

import com.google.common.base.Preconditions;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.framework.task.AbstractTask;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.bank.EBBankNotePayableResponse;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.business.util.CacheQueryPayStorage;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.framework.frame.BankBundleManager;
import kd.ebg.note.common.framework.services.NotePayableInfoService;
import kd.ebg.note.common.model.NotePayableInfo;
import org.slf4j.MDC;

public class BankQueryNotePayableTask
extends AbstractTask {
    EBGLogger logger = EBGLogger.getInstance().getLogger(BankQueryNotePayableTask.class);
    private BankNotePayableRequest request;
    private EBContext context;
    private static final int QUERY_PAY_INTERVAL_MINUTES = 1;

    public BankQueryNotePayableTask(BankNotePayableRequest request, EBContext context) {
        this.request = request;
        this.context = context;
    }

    public Object doBiz() {
        EBBankNotePayableResponse response = this.submitQueryNotePayable(this.request, this.context);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EBBankNotePayableResponse submitQueryNotePayable(BankNotePayableRequest request, EBContext context) {
        String bizSeqID = Sequence.gen18Sequence();
        if (StringUtils.isEmpty((String)request.getHeader().getBizSeqID())) {
            request.getHeader().setBizSeqID(bizSeqID);
        }
        String customId = request.getHeader().getCustomerID();
        String batchSeqID = request.getBankBatchSeqID();
        String key = customId + batchSeqID + "queryNotePayable";
        try {
            FEPAccess access;
            List<NotePayableInfo> result;
            block22: {
                LocalDateTime lastQueryTime;
                if (CacheQueryPayStorage.checkRepeatQuery(key)) {
                    EBBankNotePayableResponse response = new EBBankNotePayableResponse();
                    response.setHeader(request.getHeader());
                    response.setNotePayableInfos(request.getNotePayableInfoList());
                    response.setBankBatchSeqID(request.getBankBatchSeqID());
                    EBBankNotePayableResponse eBBankNotePayableResponse = response;
                    return eBBankNotePayableResponse;
                }
                context.setBizName("queryNotePayable");
                MDCUtil.clearBussinessMDC();
                MDCUtil.initMDC((EBContext)context);
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                this.logger.infoIndex("\u5f00\u59cb\u8fdb\u884c\u5e94\u4ed8\u7968\u636e\u540c\u6b65\u4e1a\u52a1\u5904\u7406,{}", (Object)bizSeqID);
                EBContext.setContext((EBContext)context);
                List<NotePayableInfo> notePayableInfos = request.getNotePayableInfoList();
                if (notePayableInfos.isEmpty()) {
                    EBBankNotePayableResponse eBBankNotePayableResponse = null;
                    return eBBankNotePayableResponse;
                }
                PaymentState state = PaymentState.getEnumById((int)notePayableInfos.get(0).getStatus());
                if (PaymentState.PACKAGED == state || PaymentState.INITIAL == state) {
                    this.logger.info("\u5f53\u524d\u4fe1\u606f\u8fd8\u672a\u63d0\u4ea4\u5230\u94f6\u884c\uff0c\u4e0d\u5141\u8bb8\u4ece\u94f6\u884c\u67e5\u8be2\u4ed8\u6b3e\u72b6\u6001");
                    EBBankNotePayableResponse eBBankNotePayableResponse = null;
                    return eBBankNotePayableResponse;
                }
                String reserved1 = request.getReserved1();
                if (!"unittest".equals(reserved1) && !"forceQuery".equals(reserved1) && Objects.nonNull(lastQueryTime = notePayableInfos.get(0).getLastSyncTime()) && LocalDateTime.now().plusMinutes(-1L).isBefore(lastQueryTime)) {
                    this.logger.info("1\u5206\u949f\u5185\u5df2\u7ecf\u4ece\u94f6\u884c\u540c\u6b65\u8fc7\u4e86,\u672c\u6b21\u4e0d\u518d\u4ece\u94f6\u884c\u67e5\u8be2");
                    EBBankNotePayableResponse eBBankNotePayableResponse = null;
                    return eBBankNotePayableResponse;
                }
                result = null;
                String bankVersionID = context.getBankVersionID();
                String implClassName = notePayableInfos.get(0).getQueryImplClassName();
                EBGNotePayableUtils.setPaymentUpdateTimeAndStatus(notePayableInfos, LocalDateTime.now());
                this.logger.info("\u53d1\u9001\u94f6\u884c\u524d\u6570\u91cf\uff1a" + notePayableInfos.size() + "\u7968\u636e\u72b6\u6001\uff1a" + notePayableInfos.get(0).getStatus());
                request.setNotePayableInfoList(notePayableInfos);
                access = null;
                try {
                    IQueryNotePayable queryNotePayable = (IQueryNotePayable)BankBundleManager.getInstance().getImplByClassName(bankVersionID, IQueryNotePayable.class, implClassName);
                    EBContext.initParameter();
                    MDC.put((String)"bussiness_type", (String)"bussiness_bank");
                    access = FEPAccessUtil.access((String)bankVersionID, (String)context.getBankLoginID());
                    this.logger.info("\u83b7\u53d6\u5230\u524d\u7f6e\u673a\u9501");
                    EBBankNotePayableResponse response = queryNotePayable.queryPay(request);
                    this.logger.info("\u63d2\u4ef6\u5904\u7406\u6210\u529f\u7968\u636e\u72b6\u6001\uff1a" + notePayableInfos.get(0).getStatus());
                    if (Objects.nonNull(EBContext.getContext().getThrowableAfterSend())) {
                        EBGNotePayableUtils.setPaymentState(request.getNotePayableInfoList(), PaymentState.UNKNOWN, ResManager.loadKDString((String)"\u8bf7\u6c42\u53d1\u9001\u65f6\u5f02\u5e38\uff0c\u7ed3\u679c\u672a\u77e5\uff0c\u8bf7\u540c\u6b65\u7ed3\u679c\u3002", (String)"BankQueryNotePayableTask_0", (String)"ebg-note-business", (Object[])new Object[0]), "", "");
                        break block22;
                    }
                    Preconditions.checkState((boolean)Objects.nonNull((Object)response), (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankQueryNotePayableTask_1", (String)"ebg-note-business", (Object[])new Object[0]));
                    if (response == null) break block22;
                    Preconditions.checkState((boolean)Objects.nonNull(response.getNotePayableInfos()), (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u7684 \u5e94\u4ed8\u7968\u636e\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankQueryNotePayableTask_2", (String)"ebg-note-business", (Object[])new Object[0]));
                    result = response.getNotePayableInfos();
                }
                catch (Throwable e) {
                    try {
                        MDC.put((String)"bussiness_type", (String)"bussiness_process");
                        EBGNotePayableUtils.setPaymentState(request.getNotePayableInfoList(), PaymentState.UNKNOWN, ResManager.loadKDString((String)"\u8bf7\u6c42\u53d1\u9001\u65f6\u5f02\u5e38\uff0c\u7ed3\u679c\u672a\u77e5\uff0c\u8bf7\u540c\u6b65\u7ed3\u679c\u3002", (String)"BankQueryNotePayableTask_0", (String)"ebg-note-business", (Object[])new Object[0]), "", "");
                        this.logger.error("\u540c\u6b65\u5e94\u4ed8\u7968\u636e\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38", new Object[]{e.getMessage()});
                        this.logger.error(EBExceiptionUtil.stackTraceString((StackTraceElement[])e.getStackTrace()));
                    }
                    catch (Throwable throwable) {
                        FEPAccessUtil.release(access);
                        MDC.put((String)"bussiness_type", (String)"bussiness_process");
                        throw throwable;
                    }
                    FEPAccessUtil.release((FEPAccess)access);
                    MDC.put((String)"bussiness_type", (String)"bussiness_process");
                }
            }
            FEPAccessUtil.release((FEPAccess)access);
            MDC.put((String)"bussiness_type", (String)"bussiness_process");
            LocalDateTime queryTime = LocalDateTime.now();
            if (result != null) {
                result.forEach(info -> {
                    this.logger.info("\u540c\u6b65\u7684\u6279\u6b21\u53f7\u4e3a\uff1a" + info.getBankBatchSeqId() + ",\u540c\u6b65\u540e\u7968\u636e\u72b6\u6001\uff1a" + info.getStatus() + info.getBankMsg() + ",\u7968\u53f7\uff1a" + info.getBillNo());
                    info.setLastSyncTime(queryTime);
                    info.setLastSyncRequestSeq(context.getRequestSeqID());
                    info.setSyncCount(Integer.valueOf(Integer.parseInt(Objects.toString(info.getSyncCount(), "0")) + 1));
                    info.setPayFinishTime(LocalDateTime.now());
                });
            }
            NotePayableInfoService service = NotePayableInfoService.getInstance();
            if (result != null) {
                service.save((List)result);
            } else {
                result = request.getNotePayableInfoList();
                service.save(result);
            }
            EBBankNotePayableResponse response = new EBBankNotePayableResponse();
            response.setHeader(request.getHeader());
            response.setNotePayableInfos(result);
            response.setBankBatchSeqID(request.getBankBatchSeqID());
            EBBankNotePayableResponse eBBankNotePayableResponse = response;
            return eBBankNotePayableResponse;
        }
        catch (Throwable e) {
            this.logger.error("BankQueryNotePayableTask error", e);
            EBBankNotePayableResponse eBBankNotePayableResponse = null;
            return eBBankNotePayableResponse;
        }
        finally {
            CacheQueryPayStorage.releaseKey(key);
        }
    }
}

