/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.mservice.facade.utils;

import java.util.Objects;
import org.springframework.core.env.Environment;

public final class TenantUtil {
    private static String[] usedProfiles;

    public static boolean isTestMode(String customerNo, Environment environment) {
        boolean prod = TenantUtil.containProfile("prod", environment);
        if (prod) {
            return false;
        }
        boolean testMode = false;
        Object envStatus = null;
        if (envStatus != null) {
            testMode = "Testing".equals(envStatus);
        }
        return testMode;
    }

    private static void init(Environment env) {
        String[] profiles = env.getActiveProfiles();
        if (profiles.length == 0) {
            profiles = env.getDefaultProfiles();
        }
        usedProfiles = profiles;
    }

    private static boolean containProfile(String profile, Environment environment) {
        TenantUtil.init(environment);
        if (Objects.nonNull(usedProfiles) && usedProfiles.length > 0) {
            for (String p : usedProfiles) {
                if (!p.equalsIgnoreCase(profile)) continue;
                return true;
            }
        }
        return false;
    }
}

