/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.mservice.impl;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.RateLimiter;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBException;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.entity.base.EBRequestEnhance;
import kd.ebg.egf.common.entity.base.EBResponse;
import kd.ebg.egf.common.entity.service.EBBaseRequest;
import kd.ebg.egf.common.entity.service.EBServiceRequest;
import kd.ebg.egf.common.entity.service.EBServiceResponse;
import kd.ebg.egf.common.exception.EBSecurityException;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.framework.security.util.EBFrontUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.common.front.api.biz.EBResponseCode;
import kd.ebg.note.common.front.api.boot.utils.FrontCheckUtil;
import kd.ebg.note.common.utils.SpringContextUtil;
import kd.ebg.note.mservice.facade.config.FacadeProperties;
import kd.ebg.note.mservice.facade.utils.CommonUtils;
import kd.ebg.note.mservice.facade.utils.LogUtil;
import net.sf.json.JSONObject;
import org.slf4j.MDC;
import org.springframework.core.env.Environment;

public abstract class BaseService {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BaseService.class);
    private static final String BANK_VERSION_ID = "bankVersionID";
    private static final long maxWaitTime = 30L;
    private static final RateLimiter globalRateLimiter = RateLimiter.create((double)1000.0);
    private static final AtomicInteger rateLimiterRejectCount = new AtomicInteger(0);
    private static final ConcurrentHashMap<String, RateLimiter> customRateLimiter = new ConcurrentHashMap();
    private FacadeProperties properties;
    private Environment environment;

    private synchronized RateLimiter createForCustom(String customId) {
        RateLimiter rateLimiter = customRateLimiter.get(customId);
        if (Objects.isNull(rateLimiter)) {
            rateLimiter = RateLimiter.create((double)100.0);
            customRateLimiter.put(customId, rateLimiter);
        }
        return rateLimiter;
    }

    public ApiResult service(Map<String, Object> params) {
        EBServiceResponse response;
        ApiResult result = new ApiResult();
        String jsonMap = JSONObject.fromObject(params).toString();
        EBServiceRequest request = (EBServiceRequest)JsonUtil.json2Obj((String)jsonMap, EBServiceRequest.class);
        this.properties = (FacadeProperties)SpringContextUtil.getBean(FacadeProperties.class);
        this.environment = (Environment)SpringContextUtil.getBean(Environment.class);
        try {
            String customID = RequestContext.get().getTenantId();
            if (StringUtils.isEmpty((String)customID)) {
                throw new EBSecurityException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u79df\u6237[%s]\u4e0d\u5b58\u5728\u3002", (String)"BaseService_2", (String)"ebg-note-mservice", (Object[])new Object[0]), customID));
            }
            if (!StringUtils.equalsIgnoreCase((String)customID, (String)request.getCustomerID())) {
                throw new EBSecurityException(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u8bf7\u6c42\u79df\u6237\u53f7\u4e0e\u5f53\u524d\u79df\u6237[%s]\u4e0d\u5339\u914d\u3002", (String)"BaseService_3", (String)"ebg-note-mservice", (Object[])new Object[0]), customID));
            }
            request.setCustomerID(customID);
            this.acquireLimiter(request, true);
            String data = this.check(request, true);
            EBRequestEnhance ebRequestEnhance = (EBRequestEnhance)JsonUtil.json2Obj((String)request.getData(), EBRequestEnhance.class);
            LogUtil.debugRequest((EBBaseRequest)request);
            ebRequestEnhance.getHeader().setCustomId(request.getCustomerID());
            ebRequestEnhance.getHeader().setRequestTime(request.getTimestamp().longValue());
            this.pretreat(ebRequestEnhance, data);
            EBResponse ebResponse = null;
            try {
                ebResponse = this.doBiz(data, ebRequestEnhance);
            }
            catch (Throwable e) {
                logger.info("\u7535\u7968\u4e1a\u52a1\u5f02\u5e38\uff1a" + e.getStackTrace());
                EBResponseCode responseCode = EBResponseCode.BIZ_ERROR;
                this.treatErrorResponse(request, e.getMessage(), responseCode);
            }
            response = this.treatResponse(request, ebResponse);
        }
        catch (Exception e) {
            EBResponseCode responseCode = EBResponseCode.SECURITY_ERROR;
            logger.error("\u7535\u7968\u4e1a\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
            response = this.treatErrorResponse(request, e.getMessage(), responseCode);
        }
        boolean isIgnoreSign = Boolean.parseBoolean(System.getProperty("ignoreSign"));
        if (!isIgnoreSign) {
            EBFrontUtil.signResponse((EBServiceResponse)response, (EBBaseRequest)request);
        }
        if (response.getResponseCode().equals(EBResponseCode.BIZ_SUCCESS.getResponseCode())) {
            result.setErrorCode("success");
            result.setData((Object)response);
            result.setSuccess(true);
        } else {
            result.setErrorCode("fail");
            result.setData((Object)response);
            result.setSuccess(false);
        }
        return result;
    }

    private void acquireLimiter(EBServiceRequest request, boolean isUse) {
        if (isUse) {
            boolean tryAcquire = globalRateLimiter.tryAcquire(30L, TimeUnit.SECONDS);
            if (!tryAcquire) {
                rateLimiterRejectCount.incrementAndGet();
                throw new EBSecurityException(ResManager.loadKDString((String)"\u5168\u5c40\u9650\u6d41", (String)"BaseService_4", (String)"ebg-note-mservice", (Object[])new Object[0]));
            }
            RateLimiter rateLimiter = customRateLimiter.get(request.getCustomerID());
            if (Objects.isNull(rateLimiter)) {
                rateLimiter = this.createForCustom(request.getCustomerID());
            }
            if (!rateLimiter.tryAcquire(30L, TimeUnit.SECONDS)) {
                logger.warn("\u79df\u6237:{} \u89e6\u53d1\u9650\u6d41", new Object[]{request.getCustomerID()});
                throw new EBSecurityException(ResManager.loadKDString((String)"\u5355\u79df\u6237\u9650\u6d41", (String)"BaseService_5", (String)"ebg-note-mservice", (Object[])new Object[0]));
            }
        }
    }

    private String check(EBServiceRequest request, boolean isUse) {
        if (isUse) {
            FrontCheckUtil.checkRequest((EBBaseRequest)request);
            logger.info("properties:" + this.properties.toString());
            if (this.properties.isTimeLimitCheck() && !FrontCheckUtil.checkTimeLimited((EBBaseRequest)request, (long)this.properties.getTimeLimit(), (long)this.properties.getTimeTolerate())) {
                throw new EBSecurityException(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u65f6\u6548:\u8bf7\u6c42\u65f6\u95f4\u6233\u4e0d\u80fd\u8d85\u8fc7\u94f6\u4f01\u670d\u52a1\u5668\u65f6\u95f4\u6216\u8bf7\u6c42\u95f4\u9694\u592a\u4e45,%s", (String)"BaseService_9", (String)"ebg-note-mservice", (Object[])new Object[0]), Math.abs(System.currentTimeMillis() - request.getTimestamp()) + "ms"));
            }
            boolean isIgnoreCheckSign = Boolean.parseBoolean(System.getProperty("ignoreCheckSign"));
            if ("register".equalsIgnoreCase(request.getBizType())) {
                isIgnoreCheckSign = false;
            }
            if (!isIgnoreCheckSign) {
                LogUtil.infoRequest((EBBaseRequest)request);
                boolean isValid = EBFrontUtil.decryptAndVerifyEBSecurityRequest((EBServiceRequest)request);
                if (!isValid) {
                    throw new EBSecurityException(ResManager.loadKDString((String)"\u9a8c\u8bc1\u7b7e\u540d\u672a\u901a\u8fc7\u3002", (String)"BaseService_7", (String)"ebg-note-mservice", (Object[])new Object[0]));
                }
            }
        }
        String data = request.getData();
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)data), (Object)ResManager.loadKDString((String)"data \u4e3a\u7a7a\u3002", (String)"BaseService_8", (String)"ebg-note-mservice", (Object[])new Object[0]));
        return data;
    }

    private EBRequestEnhance pretreat(EBRequestEnhance ebRequestEnhance, String data) {
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)data), (Object)ResManager.loadKDString((String)"data \u4e3a\u7a7a\u3002", (String)"BaseService_8", (String)"ebg-note-mservice", (Object[])new Object[0]));
        String bizType = ebRequestEnhance.getHeader().getBizType();
        String subBizType = ebRequestEnhance.getHeader().getSubBizType();
        String customId = ebRequestEnhance.getHeader().getCustomId();
        String requestSeqID = "";
        String bizSeqID = Sequence.gen18Sequence();
        String batchSeqId = ebRequestEnhance.getBody().getBatchSeqId();
        if (!StringUtils.isEmpty((String)batchSeqId)) {
            bizSeqID = batchSeqId;
        }
        if ("ping".equalsIgnoreCase(bizType)) {
            MDC.put((String)BANK_VERSION_ID, (String)ebRequestEnhance.getHeader().getExtData());
        }
        requestSeqID = String.valueOf(ebRequestEnhance.getHeader().getRequestTime());
        ebRequestEnhance.setLogRequestSeqId(requestSeqID);
        ebRequestEnhance.setCustomId(customId);
        ebRequestEnhance.setLogBizSeqId(bizSeqID);
        String logger_bank_no = Sequence.gen18Sequence();
        EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(customId).logRequestSeqID(requestSeqID).bizName(bizType).subBizName(subBizType).bankVersionID("").logBizSeqID(bizSeqID).bizSeqID(Sequence.gen18Sequence()).requestSeqID(Sequence.genSequence()).loggerBatchNo(bizSeqID).loggerDetailNo(bizSeqID).loggerBankNo(logger_bank_no).build();
        JSONObject object = new JSONObject();
        object.put((Object)"loggerBatchNo", (Object)bizSeqID);
        object.put((Object)"loggerDetailNo", (Object)bizSeqID);
        object.put((Object)"loggerBankNo", (Object)logger_bank_no);
        ebRequestEnhance.getHeader().setExtData(object.toString());
        EBContext.setContext((EBContext)context);
        EBContext.getContext().setType("request");
        MDCUtil.initMDC();
        logger.infoRequest("\u8bf7\u6c42\u6570\u636e: \n{}", (Object)CommonUtils.prettyJson(data));
        return ebRequestEnhance;
    }

    private EBServiceResponse treatResponse(EBServiceRequest request, EBResponse ebResponse) {
        String responseData = "";
        EBServiceResponse response = new EBServiceResponse();
        response.setVersion(request.getVersion());
        String responseCode = null;
        String responseMsg = null;
        if (Objects.isNull(ebResponse.getException())) {
            responseCode = EBResponseCode.BIZ_SUCCESS.getResponseCode();
            responseMsg = EBResponseCode.BIZ_SUCCESS.getResponseMessage();
        } else {
            EBException ebException = ebResponse.getException();
            if (ebException.getInnerException() != null) {
                if (ebException.getInnerException().equals("preException")) {
                    responseCode = EBResponseCode.BASE_ERROR.getResponseCode();
                    responseMsg = EBResponseCode.BASE_ERROR.getResponseMessage() + "," + ebException.getMessage();
                } else if (ebException.getInnerException().equals("serviceException")) {
                    responseCode = EBResponseCode.BIZ_ERROR.getResponseCode();
                    responseMsg = EBResponseCode.BIZ_ERROR.getResponseMessage() + "," + ebException.getMessage();
                }
            } else {
                responseCode = EBResponseCode.DUBBO_ERROR.getResponseCode();
                responseMsg = EBResponseCode.DUBBO_ERROR.getResponseMessage();
            }
        }
        response.setResponseCode(responseCode);
        response.setResponseMsg(responseMsg);
        responseData = JsonUtil.toJsonLine((Object)ebResponse);
        this.setContextResponse();
        logger.infoResponse("\u54cd\u5e94\u7ed3\u679c\uff1a\n{}", (Object)CommonUtils.prettyJson(responseData));
        response.setData(responseData);
        EBFrontUtil.encryptResponse((EBServiceRequest)request, (EBServiceResponse)response);
        return response;
    }

    private EBServiceResponse treatErrorResponse(EBServiceRequest request, String errorMsg, EBResponseCode responseCode) {
        EBServiceResponse response = new EBServiceResponse();
        response.setVersion(request.getVersion());
        response.setResponseCode(responseCode.getResponseCode());
        response.setResponseMsg(responseCode.getResponseMessage());
        EBException ebException = new EBException();
        ebException.setErrorCode(responseCode.getResponseCode());
        ebException.setMessage(errorMsg);
        EBResponse ebResponse = new EBResponse();
        ebResponse.setException(ebException);
        String responseData = JsonUtil.toJsonLine((Object)ebResponse);
        this.setContextResponse();
        logger.info("\u54cd\u5e94\u7ed3\u679c\uff1a\n{}", (Object)CommonUtils.prettyJson(responseData));
        response.setData(responseData);
        EBFrontUtil.encryptResponse((EBServiceRequest)request, (EBServiceResponse)response);
        return response;
    }

    private void setContextResponse() {
        try {
            EBContext.getContext().setType("response");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public <T extends EBRequest> T getRequest(Class<T> requestClass, String data, EBRequestEnhance ebRequestEnhance) {
        EBRequest request = (EBRequest)JsonUtil.json2Obj((String)data, requestClass);
        request.getHeader().setCustomId(ebRequestEnhance.getCustomId());
        request.getHeader().setLogBizSeqID(ebRequestEnhance.getLogBizSeqId());
        request.getHeader().setLogRequestSeqID(ebRequestEnhance.getLogRequestSeqId());
        request.getHeader().setExtData(ebRequestEnhance.getHeader().getExtData());
        return (T)request;
    }

    abstract EBResponse doBiz(String var1, EBRequestEnhance var2);
}

