/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ceb.dc.service.codeless.payable;

import com.google.common.collect.Lists;
import java.util.List;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.ceb.dc.service.CEBHelper;
import kd.ebg.note.banks.ceb.dc.service.codeless.payable.QueryPayableStatus;
import kd.ebg.note.business.notePayable.atomic.codeless.CodeLessAbstractQueryNotePayableImpl;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;

public class QueryPayableImpl
extends CodeLessAbstractQueryNotePayableImpl {
    public int getBatchSize() {
        return 0;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "b2e016085_P";
    }

    public String getBizDesc() {
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        CEBHelper.configFactory(factory, "b2e016085");
        super.configFactory(factory);
    }

    public List<NotePayableInfo> parserUtil(BankNotePayableRequest request, String responStr) {
        List infos = super.parserUtil(request, responStr);
        QueryPayableStatus impl = new QueryPayableStatus();
        for (NotePayableInfo info : infos) {
            if (StringUtils.isNotEmpty((String)info.getBillNo())) {
                BankNotePayableRequest statusRequest = new BankNotePayableRequest();
                statusRequest.setNotePayableInfoList((List)Lists.newArrayList((Object[])new NotePayableInfo[]{info}));
                impl.doBiz(statusRequest);
            }
            if (info.getStatus() == 13) continue;
            if ("SES01".equals(info.getRspserialno())) {
                if ("B_02".equals(info.getReserved1()) && "remit_accept".equals(info.getSubBizType())) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)"B_02", (String)"");
                    continue;
                }
                if ("C_02".equals(info.getReserved1()) && "remit_receive".equals(info.getSubBizType())) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)"C_02", (String)"");
                    continue;
                }
                if ("remit_cancle".equals(info.getSubBizType())) {
                    if (info.getOperationCode().equals("02") && "A_01".equals(info.getReserved1())) {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)"A_01", (String)"");
                        continue;
                    }
                    if (!info.getOperationCode().equals("03") || !"B_02".equals(info.getReserved1())) continue;
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)"B_02", (String)"");
                    continue;
                }
                EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)info.getReserved1(), (String)"");
                continue;
            }
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)info.getRspserialno(), (String)"");
        }
        return infos;
    }

    public String getDateStr() {
        return "yyyy-MM-dd";
    }
}

