/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ceb.dc.service.codeless.payable.register;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ceb.dc.service.CEBHelper;
import kd.ebg.note.banks.ceb.dc.service.codeless.payable.QueryPayableStatus;
import kd.ebg.note.business.notePayable.atomic.codeless.CodeLessAbstractQueryNotePayableImpl;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class CodelessQueryRegistImpl
extends CodeLessAbstractQueryNotePayableImpl {
    public int getBatchSize() {
        return 0;
    }

    public String getDeveloper() {
        return "hhm";
    }

    public String getBizCode() {
        return "b2e016015";
    }

    public String getBizDesc() {
        return null;
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        int i = Integer.parseInt(pageTag);
        return (i += 20) + "";
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Namespace ns = root.getNamespace();
        Element transContent = root.getChild("TransContent", ns);
        String sumnum = transContent.getChildTextTrim("SUMNUM", ns);
        int sum = Integer.parseInt(sumnum);
        int i = Integer.parseInt(pageTag);
        return i > sum;
    }

    public boolean isNeedPage() {
        return true;
    }

    public String getDateStr() {
        return "yyyy-MM-dd";
    }

    public void configFactory(ConnectionFactory factory) {
        CEBHelper.configFactory(factory, this.getBizCode());
        super.configFactory(factory);
    }

    public String getFirstPageTag() {
        return "1";
    }

    public boolean isParserAuto() {
        return false;
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest bankNotePayableRequest, String res) {
        Namespace ns;
        List infos = bankNotePayableRequest.getNotePayableInfoList();
        Element root = JDomUtils.string2Root((String)res, (String)RequestContextUtils.getCharset());
        Element error = root.getChild("error", ns = root.getNamespace());
        if (error != null) {
            EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)error.getTextTrim());
            return infos;
        }
        Element head = root.getChild("TransContent", ns);
        String returnCode = head.getChildTextTrim("ReturnCode", ns);
        String returnMsg = head.getChildTextTrim("ReturnMsg", ns);
        if (!"0000".equals(returnCode)) {
            EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)returnCode, (String)returnMsg);
        } else {
            Element body = head.getChild("BatchRespList", ns);
            List respData = body.getChildren("RespData", ns);
            QueryPayableStatus impl = new QueryPayableStatus();
            for (NotePayableInfo info : infos) {
                for (Element data : respData) {
                    String confer_no = data.getChildTextTrim("CONFER_NO", ns);
                    if (!info.getBankDetailSeqId().equals(confer_no)) continue;
                    String cd_pac_no = data.getChildTextTrim("CD_PAC_NO", ns);
                    info.setBillNo(cd_pac_no);
                    String cd_range_no = data.getChildTextTrim("CD_RANGE_NO", ns);
                    info.setSubRange(cd_range_no);
                    String bill_all_amt = data.getChildTextTrim("BILL_ALL_AMT", ns);
                    if (StringUtils.isNotEmpty((String)bill_all_amt)) {
                        info.setAmount(new BigDecimal(bill_all_amt));
                    }
                    String ifsep_flow = data.getChildTextTrim("IFSEP_FLOW", ns);
                    info.setGrdBag(ifsep_flow);
                    String bill_type = data.getChildTextTrim("BILL_TYPE", ns);
                    info.setDraftType(bill_type);
                    String out_bill_status = data.getChildTextTrim("OUT_BILL_STATUS", ns);
                    if ("OS01".equals(out_bill_status)) {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)out_bill_status, (String)ResManager.loadKDString((String)"\u51fa\u7968\u767b\u8bb0\u4e2d", (String)"CodelessQueryRegistImpl_0", (String)"ebg-note-banks-ceb-dc", (Object[])new Object[0]));
                    } else if ("OS02".equals(out_bill_status)) {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)out_bill_status, (String)ResManager.loadKDString((String)"\u51fa\u7968\u5df2\u767b\u8bb0", (String)"CodelessQueryRegistImpl_1", (String)"ebg-note-banks-ceb-dc", (Object[])new Object[0]));
                    } else if ("OS03".equals(out_bill_status)) {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.FAIL, (String)out_bill_status, (String)ResManager.loadKDString((String)"\u51fa\u7968\u767b\u8bb0\u5931\u8d25", (String)"CodelessQueryRegistImpl_2", (String)"ebg-note-banks-ceb-dc", (Object[])new Object[0]));
                    } else {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)out_bill_status, (String)"UNKONWN");
                    }
                    if (!StringUtils.isNotEmpty((String)info.getBillNo())) continue;
                    BankNotePayableRequest statusRequest = new BankNotePayableRequest();
                    statusRequest.setNotePayableInfoList((List)Lists.newArrayList((Object[])new NotePayableInfo[]{info}));
                    impl.doBiz(statusRequest);
                }
            }
        }
        return infos;
    }
}

