/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ceb.dc.service.detail;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ceb.dc.service.Parser;
import kd.ebg.note.banks.ceb.dc.service.detail.endorseinfo.EndorseInfoImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteSidesInfo;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class NoteDetailParser {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(NoteDetailParser.class);

    public List<Detail> parseNoteInfoDetail(BankNoteDetailRequest rqst, String rspStr, BankAcnt ancAcnt) throws EBServiceException {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parseNoteHeader(root);
        if (!"0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)response.getResponseMessage());
        }
        Namespace ns = root.getNamespace();
        Element BatchRespList = root.getChild("TransContent", ns).getChild("BatchRespList", ns);
        List datas = BatchRespList.getChildren("RespData", ns);
        ArrayList<Detail> result = new ArrayList<Detail>(datas.size());
        for (Element data : datas) {
            Detail detailInfo = new Detail();
            detailInfo.setNoteNo(data.getChildText("BillNo", ns));
            detailInfo.setDraftType(data.getChildText("BillType", ns));
            detailInfo.setIssueDate(data.getChildText("RemiDate", ns));
            detailInfo.setApplicationDate(data.getChildText("RemiDate", ns));
            detailInfo.setDueDate(data.getChildText("DueDt", ns));
            detailInfo.setAmount(data.getChildText("BillMoney", ns));
            detailInfo.setTransferFlag(data.getChildText("Isendo", ns));
            detailInfo.setPayeeAccName(data.getChildText("Payee", ns));
            detailInfo.setPayeeAccNo(data.getChildText("PayeeAcct", ns));
            detailInfo.setPayeeBankName(data.getChildText("PayeeBank", ns));
            detailInfo.setPayeeCnapsCode(data.getChildText("PayeeBankNo", ns));
            detailInfo.setDrawerAccName(data.getChildText("RemiCust", ns));
            detailInfo.setDrawerAccNo(data.getChildText("RemiAcct", ns));
            detailInfo.setDrawerBankName(data.getChildText("RemiBank", ns));
            detailInfo.setDrawerCnapsCode(data.getChildText("RemiBankNo", ns));
            detailInfo.setCurrency("CNY");
            detailInfo.setAcceptorAccName(data.getChildText("Acpt", ns));
            detailInfo.setAcceptorAccNo(data.getChildText("AcptAcct", ns));
            detailInfo.setAcceptorCnapsCode(data.getChildText("AcptBankNo", ns));
            String BillStatus = data.getChildText("BillStatus", ns);
            if (ResManager.loadKDString((String)"\u63d0\u793a\u627f\u5151\u5f85\u7b7e\u6536", (String)"NoteDetailParser_0", (String)"ebg-note-banks-ceb-dc", (Object[])new Object[0]).equals(BillStatus)) {
                detailInfo.setNoteStatus("020001");
            } else if (ResManager.loadKDString((String)"\u80cc\u4e66\u5f85\u7b7e\u6536", (String)"NoteDetailParser_1", (String)"ebg-note-banks-ceb-dc", (Object[])new Object[0]).equals(BillStatus)) {
                detailInfo.setNoteStatus("100001");
            } else if (ResManager.loadKDString((String)"\u63d0\u793a\u4ed8\u6b3e\u5f85\u7b7e\u6536", (String)"NoteDetailParser_2", (String)"ebg-note-banks-ceb-dc", (Object[])new Object[0]).equals(BillStatus)) {
                detailInfo.setNoteStatus("200001");
            } else if (ResManager.loadKDString((String)"\u63d0\u793a\u6536\u7968\u5f85\u7b7e\u6536", (String)"NoteDetailParser_3", (String)"ebg-note-banks-ceb-dc", (Object[])new Object[0]).equals(BillStatus)) {
                detailInfo.setNoteStatus("030001");
            }
            EndorseInfoImpl impl = new EndorseInfoImpl();
            this.logger.info("*******\u67e5\u8be2\u80cc\u4e66\u8054");
            List<NoteSidesInfo> sidesDetails = impl.getinfo(data.getChildText("BillId", ns), ancAcnt.getAccNo());
            detailInfo.setBusinessCode(rqst.getBody().getTranType());
            detailInfo.setNoteSidesInfo(sidesDetails);
            detailInfo.setBankRefKey(data.getChildText("BillId", ns));
            result.add(detailInfo);
        }
        return result;
    }
}

