/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ceb.dc.service.receivable.discount;

import java.math.BigDecimal;
import java.util.Date;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ceb.dc.service.Packer;
import kd.ebg.note.business.SameBankUtil;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class NotePacker {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(NotePacker.class);

    public String packPay(NoteReceivableInfo[] receivableInfos) throws EBServiceException {
        this.logger.info("\u8d34\u73b0\u64cd\u4f5c1\uff1a\u65b0\u589e\u6279\u6b21\u4fe1\u606f");
        NoteReceivableInfo info = receivableInfos[0];
        Element root = Packer.createNoteHead("b2e003033");
        Element reqData = root.getChild("TransContent").getChild("ReqData");
        JDomUtils.addChild((Element)reqData, (String)"BusiDate", (String)DateUtil.formatDate((Date)new Date()));
        JDomUtils.addChild((Element)reqData, (String)"BusiClass", (String)"1");
        JDomUtils.addChild((Element)reqData, (String)"BillType", (String)info.getDraftType());
        BigDecimal rate = new BigDecimal(info.getDisCountRate()).divide(new BigDecimal("100"));
        JDomUtils.addChild((Element)reqData, (String)"Rate", (String)rate.toPlainString());
        JDomUtils.addChild((Element)reqData, (String)"Payee", (String)info.getAcceptorAccName());
        JDomUtils.addChild((Element)reqData, (String)"AcNo2", (String)info.getAcceptorAccNo());
        JDomUtils.addChild((Element)reqData, (String)"PayeeAcctName", (String)info.getAcceptorAccName());
        JDomUtils.addChild((Element)reqData, (String)"PayeeBrchNo", (String)info.getAcceptorAccCity());
        JDomUtils.addChild((Element)reqData, (String)"BusiinBank", (String)info.getPayeeBankName());
        boolean isSameBank = false;
        if (SameBankUtil.isSameBank((String)EBContext.getContext().getBankVersionID(), (String)info.getPayeeBankName()).equals("1")) {
            isSameBank = true;
        }
        if (isSameBank) {
            JDomUtils.addChild((Element)reqData, (String)"BusiinBankBrchNo", (String)info.getPayeeCity());
        } else {
            JDomUtils.addChild((Element)reqData, (String)"BusiinBankNo", (String)info.getPayeeBankCnaps());
        }
        if ("1".equals(info.getDiscountType())) {
            JDomUtils.addChild((Element)reqData, (String)"RateType", (String)"1");
        } else if ("2".equals(info.getDiscountType())) {
            JDomUtils.addChild((Element)reqData, (String)"RateType", (String)"2");
        } else {
            JDomUtils.addChild((Element)reqData, (String)"RateType", (String)"3");
        }
        if ("0".equals(info.getAutoAccept())) {
            JDomUtils.addChild((Element)reqData, (String)"ReckoningType", (String)"1");
        } else {
            JDomUtils.addChild((Element)reqData, (String)"ReckoningType", (String)"0");
        }
        JDomUtils.addChild((Element)reqData, (String)"Isendo", (String)info.getTransferFlag());
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }
}

