/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ceb.dc.service.receivable.signin;

import java.util.Arrays;
import java.util.HashMap;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ceb.dc.service.CEBHelper;
import kd.ebg.note.banks.ceb.dc.service.Parser;
import kd.ebg.note.business.notePayable.util.QueryNotePayableUtil;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class QueryParser {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryParser.class);

    public void parseQueryPay(NoteReceivableInfo[] receivableInfos, String rsp) throws EBServiceException {
        this.parserB2e003073(receivableInfos, rsp);
    }

    private void parserB2e003073(NoteReceivableInfo[] receivableInfos, String rsp) throws EBServiceException {
        Element root = JDomUtils.string2Root((String)rsp, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parseNoteHeader(root);
        Namespace ns = root.getNamespace();
        this.logger.info("billStatus:" + response.getResponseCode());
        if (!"0000".equals(response.getResponseCode())) {
            QueryNotePayableUtil.setPaymentState(Arrays.asList(receivableInfos), (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
            return;
        }
        Element respData = root.getChild("TransContent", ns).getChild("RespData", ns);
        String billStatus = respData.getChildText("BillStatus", ns);
        this.logger.info("billStatus:" + billStatus);
        String[] status = CEBHelper.CEBBILLSTATUS.get(billStatus);
        if (status == null) {
            QueryNotePayableUtil.setPaymentState(Arrays.asList(receivableInfos), (PaymentState)PaymentState.UNKNOWN, (String)billStatus, (String)"");
        }
        HashMap<String, PaymentState> map = new HashMap<String, PaymentState>();
        map.put("03-030006", PaymentState.SUCCESS);
        map.put("03-030001", PaymentState.SUBMITED);
        map.put("10-100006", PaymentState.SUCCESS);
        map.put("10-100001", PaymentState.SUBMITED);
        map.put("18-180006", PaymentState.SUCCESS);
        map.put("18-180001", PaymentState.SUBMITED);
        map.put("19-190006", PaymentState.SUCCESS);
        map.put("19-190001", PaymentState.SUBMITED);
        map.put("12-110106", PaymentState.SUCCESS);
        map.put("12-110101", PaymentState.SUBMITED);
        map.put("02-020006", PaymentState.SUCCESS);
        map.put("02-020001", PaymentState.SUBMITED);
        map.put("20-200001", PaymentState.SUBMITED);
        map.put("20-200003", PaymentState.SUCCESS);
        map.put("20-200005", PaymentState.SUCCESS);
        map.put("20-200005", PaymentState.SUCCESS);
        if (status != null) {
            this.logger.info("\u5339\u914d\u5230\u7684\u72b6\u6001\uff1a" + status[0] + "," + status[1]);
            PaymentState state = (PaymentState)map.get(receivableInfos[0].getOperationCode() + "-" + status[1]);
            if (state == null) {
                state = PaymentState.UNKNOWN;
            }
            QueryNotePayableUtil.setPaymentState(Arrays.asList(receivableInfos), (PaymentState)state, (String)billStatus, (String)status[0]);
            receivableInfos[0].setNoteStatus(status[1]);
        } else {
            QueryNotePayableUtil.setPaymentState(Arrays.asList(receivableInfos), (PaymentState)PaymentState.UNKNOWN, (String)billStatus, (String)"");
        }
    }
}

