/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.business.dataperm;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.emr.business.dataperm.EmrBizPermContext;
import kd.epm.epbs.business.permission.data.context.IBizDataPermHandler;
import kd.epm.epbs.common.cache.permset.bean.DataPermMemItem;

public class EmrBizTmpManagerPermHandler
implements IBizDataPermHandler<EmrBizPermContext> {
    private EmrBizPermContext _ctx;
    Map<Long, Collection<String>> cateMap = new HashMap<Long, Collection<String>>(16);
    Map<String, Collection<Long>> res = new HashMap<String, Collection<Long>>(16);

    public void setContext(EmrBizPermContext _ctx) {
        this._ctx = _ctx;
    }

    public void beforeCollect(String key, DataPermMemItem item) {
        if (item.getEntityNumber().equals("emr_templatecatalog")) {
            this.cateMap.computeIfAbsent(item.getMemId(), k -> new HashSet(16)).add(key);
        } else {
            this.res.computeIfAbsent(key, k -> new HashSet(16)).add(item.getMemId());
        }
    }

    public Map<String, Collection<Long>> afterCollect() {
        if (this._ctx.getType() == 1) {
            return this.getCategoryList();
        }
        if (this._ctx.getType() == 2) {
            return this.getCategoryEdit();
        }
        if (this._ctx.getType() == 3) {
            return this.getTemplateEdit();
        }
        if (this._ctx.getType() == 4) {
            return this.getTemplateEdit();
        }
        return this.res;
    }

    protected Map<String, Collection<Long>> getCategoryList() {
        HashSet<Long> temps = new HashSet<Long>(this.cateMap.keySet());
        if (!this.res.isEmpty()) {
            Set collect = this.res.values().stream().flatMap(e -> e.stream()).collect(Collectors.toSet());
            try (DataSet rows = QueryServiceHelper.queryDataSet((String)"querycate", (String)"emr_templateentity", (String)"templatecatalog", (QFilter[])new QFilter("group", "in", collect).toArray(), null, (int)-1).distinct();){
                while (rows.hasNext()) {
                    temps.add(rows.next().getLong("templatecatalog"));
                }
            }
        }
        HashSet<String> tempNums = new HashSet<String>(16);
        HashSet<String> containChildNums = new HashSet<String>(16);
        try (DataSet rows = QueryServiceHelper.queryDataSet((String)"querycate2", (String)"emr_templatecatalog", (String)"id,longnumber", (QFilter[])new QFilter("id", "in", temps).toArray(), null, (int)-1).distinct();){
            while (rows.hasNext()) {
                Row next = rows.next();
                String longnumber = next.getString("longnumber");
                if (this.cateMap.containsKey(next.getLong("id"))) {
                    containChildNums.add(longnumber);
                }
                for (String numb : longnumber.split("\\.")) {
                    tempNums.add(numb);
                }
            }
        }
        QFilter qf = new QFilter("model", "=", (Object)this._ctx.getModelId());
        qf.and(new QFilter("number", "in", tempNums));
        containChildNums.forEach(e -> qf.or(new QFilter("longnumber", "like", (Object)(e + ".%"))));
        try (DataSet rows = QueryServiceHelper.queryDataSet((String)"querycate3", (String)"emr_templatecatalog", (String)"id", (QFilter[])qf.toArray(), null, (int)-1).distinct();){
            while (rows.hasNext()) {
                temps.add(rows.next().getLong("id"));
            }
        }
        this.res.put(this._ctx.getDataPermType().getVal() + "", temps);
        return this.res;
    }

    protected Map<String, Collection<Long>> getCategoryEdit() {
        HashSet<Long> cateIds = new HashSet<Long>(this.cateMap.keySet());
        if (!cateIds.isEmpty()) {
            HashSet<String> containChildNums = new HashSet<String>(16);
            try (DataSet rows = QueryServiceHelper.queryDataSet((String)"querycate2", (String)"emr_templatecatalog", (String)"id,longnumber", (QFilter[])new QFilter("id", "in", this.cateMap.keySet()).toArray(), null, (int)-1).distinct();){
                while (rows.hasNext()) {
                    Row next = rows.next();
                    containChildNums.add(next.getString("longnumber"));
                }
            }
            if (!containChildNums.isEmpty()) {
                QFilter qf = new QFilter("model", "=", (Object)this._ctx.getModelId());
                QFilter qf2 = null;
                for (String e : containChildNums) {
                    qf2 = qf2 == null ? new QFilter("longnumber", "like", (Object)(e + ".%")) : qf2.or("longnumber", "like", (Object)(e + ".%"));
                }
                qf.and(qf2);
                try (DataSet rows = QueryServiceHelper.queryDataSet((String)"querycate3", (String)"emr_templatecatalog", (String)"id", (QFilter[])qf.toArray(), null, (int)-1).distinct();){
                    while (rows.hasNext()) {
                        cateIds.add(rows.next().getLong("id"));
                    }
                }
            }
        }
        this.res.put(this._ctx.getDataPermType().getVal() + "", cateIds);
        return this.res;
    }

    protected Map<String, Collection<Long>> getTemplateEdit() {
        HashSet<String> containChildNums = new HashSet<String>(16);
        if (!this.cateMap.isEmpty()) {
            try (DataSet rows = QueryServiceHelper.queryDataSet((String)"querycate2", (String)"emr_templatecatalog", (String)"id,longnumber", (QFilter[])new QFilter("id", "in", this.cateMap.keySet()).toArray(), null, (int)-1).distinct();){
                while (rows.hasNext()) {
                    Row next = rows.next();
                    containChildNums.add(next.getString("longnumber"));
                }
            }
        }
        if (!containChildNums.isEmpty()) {
            QFilter qf = new QFilter("model", "=", (Object)this._ctx.getModelId());
            QFilter qf2 = null;
            for (String e : containChildNums) {
                if (qf2 == null) {
                    qf2 = new QFilter("longnumber", "like", (Object)(e + ".%"));
                    continue;
                }
                qf2.or("longnumber", "like", (Object)(e + ".%"));
            }
            qf.and(qf2);
            HashSet<Long> cateIds = new HashSet<Long>(this.cateMap.keySet());
            try (DataSet rows = QueryServiceHelper.queryDataSet((String)"querycate3", (String)"emr_templatecatalog", (String)"id", (QFilter[])qf.toArray(), null, (int)-1).distinct();){
                while (rows.hasNext()) {
                    cateIds.add(rows.next().getLong("id"));
                }
            }
            Collection tmplIds = this.res.computeIfAbsent(this._ctx.getDataPermType().getVal() + "", k -> new HashSet(16));
            try (DataSet rows = QueryServiceHelper.queryDataSet((String)"querytpl", (String)"emr_templateentity", (String)"id,group,templatecatalog", (QFilter[])new QFilter("templatecatalog", "in", cateIds).toArray(), null, (int)-1).distinct();){
                while (rows.hasNext()) {
                    tmplIds.add(rows.next().getLong("group"));
                }
            }
            this.res.put(this._ctx.getDataPermType().getVal() + "", tmplIds);
        }
        return this.res;
    }

    protected Map<String, Collection<Long>> getTemplateList() {
        HashSet<Long> cateIds = new HashSet<Long>(this.cateMap.keySet());
        if (!this.cateMap.isEmpty()) {
            HashSet<String> containChildNums = new HashSet<String>(16);
            try (DataSet rows = QueryServiceHelper.queryDataSet((String)"querycate2", (String)"emr_templatecatalog", (String)"id,longnumber", (QFilter[])new QFilter("id", "in", this.cateMap.keySet()).toArray(), null, (int)-1).distinct();){
                while (rows.hasNext()) {
                    Row next = rows.next();
                    containChildNums.add(next.getString("longnumber"));
                }
            }
            QFilter qf = new QFilter("model", "=", (Object)this._ctx.getModelId());
            QFilter qf2 = new QFilter("1", "=", (Object)1);
            qf.and(qf2);
            containChildNums.forEach(e -> qf2.or(new QFilter("longnumber", "like", (Object)(e + ".%"))));
            try (DataSet rows = QueryServiceHelper.queryDataSet((String)"querycate3", (String)"emr_templatecatalog", (String)"id", (QFilter[])qf.toArray(), null, (int)-1).distinct();){
                while (rows.hasNext()) {
                    cateIds.add(rows.next().getLong("id"));
                }
            }
        }
        this.res.put(this._ctx.getDataPermType().getVal() + "", cateIds);
        return this.res;
    }

    public Collection<Long> getAllMemberIds() {
        HashSet<Long> groupIds = new HashSet<Long>(16);
        try (DataSet rows = QueryServiceHelper.queryDataSet((String)"querytpl", (String)"emr_templateentity", (String)"group,templatecatalog", null, null, (int)-1).distinct();){
            while (rows.hasNext()) {
                groupIds.add(rows.next().getLong("group"));
            }
        }
        return groupIds;
    }
}

