/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.business.rules.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.business.rules.models.RuleBean;
import kd.epm.epbs.business.rules.models.RuleExpressionItem;
import kd.epm.epbs.business.rules.models.RuleLogic;
import kd.epm.epbs.business.rules.models.RuleOptionProps;
import kd.epm.epbs.business.rules.models.RuleScopeDim;
import kd.epm.epbs.business.rules.support.RuleUtil;
import kd.epm.epbs.common.elasticsearch.LocalDateFormat;
import kd.epm.epbs.common.enums.RuleExecuteTypeEnum;
import kd.epm.epbs.common.enums.RuleStatusEnum;
import kd.epm.epbs.common.util.JSONUtils;
import kd.epm.epbs.common.util.Pair;
import kd.epm.epbs.common.util.TXUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class RuleSaveHelper {
    private static final Log LOG = LogFactory.getLog(RuleSaveHelper.class);
    private static final Pattern PATTERN = Pattern.compile("[0-9a-zA-Z_-]+");

    private RuleSaveHelper() {
    }

    public static void saveRule(RuleBean ruleBean) {
        RuleSaveHelper.checkBeforeSave(ruleBean);
        if (Objects.isNull(ruleBean.getId())) {
            RuleSaveHelper.saveOneRule(ruleBean);
        } else {
            RuleSaveHelper.updateOneRule(ruleBean);
        }
    }

    private static void checkBeforeSave(RuleBean ruleBean) {
        if (!PATTERN.matcher(ruleBean.getNumber()).matches()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u89c4\u5219\u7f16\u7801[%s]\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u53ea\u80fd\u8f93\u5165\u6570\u5b57\u3001\u5b57\u6bcd\u3001\u51cf\u53f7\u548c\u4e0b\u5212\u7ebf", (String)"RuleSaveHelper_0", (String)"epm-emr-business", (Object[])new Object[0]), ruleBean.getNumber()));
        }
        for (RuleLogic logic : ruleBean.getLogics()) {
            if (PATTERN.matcher(logic.getLogicCode()).matches()) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u89c4\u5219\u903b\u8f91\u7f16\u7801[%s]\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u53ea\u80fd\u8f93\u5165\u6570\u5b57\u3001\u5b57\u6bcd\u3001\u51cf\u53f7\u548c\u4e0b\u5212\u7ebf", (String)"RuleSaveHelper_1", (String)"epm-emr-business", (Object[])new Object[0]), logic.getLogicCode()));
        }
    }

    public static void saveOneRule(RuleBean ruleBean) {
        RuleSaveHelper.checkBeforeSave(ruleBean);
        QFilter filter = new QFilter("domain", "=", (Object)Long.parseLong(ruleBean.getDomainId()));
        filter.and(new QFilter("model", "=", (Object)Long.parseLong(ruleBean.getModelId())));
        DynamicObjectCollection seq = QueryServiceHelper.query((String)"emr_rule_entity", (String)"number,sequence", (QFilter[])new QFilter[]{filter});
        List numbers = seq.stream().map(dy -> dy.getString("number")).collect(Collectors.toList());
        int count = seq.stream().map(dy -> dy.getInt("sequence")).max(Integer::compareTo).orElse(0);
        if (RuleUtil.existNumber(numbers, (String)ruleBean.getNumber())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u89c4\u5219\u65b0\u589e\u5931\u8d25\uff0c\u5df2\u5b58\u5728\u7f16\u7801\u4e3a%2$s\u7684\u89c4\u5219\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u6267\u884c\u624b\u5de5\u65b0\u589e\u3002", (String)"RuleSaveHelper_2", (String)"epm-emr-business", (Object[])new Object[0]), ruleBean.getNumber(), ruleBean.getNumber()));
        }
        DynamicObject rule = BusinessDataServiceHelper.newDynamicObject((String)"emr_rule_entity");
        Long id = DB.genGlobalLongId();
        rule.set("id", (Object)id);
        rule.set("model", (Object)Long.parseLong(ruleBean.getModelId()));
        rule.set("domain", (Object)Long.parseLong(ruleBean.getDomainId()));
        rule.set("number", (Object)ruleBean.getNumber());
        rule.set("name", (Object)ruleBean.getName());
        rule.set("description", (Object)ruleBean.getDescription());
        rule.set("sourcetype", (Object)ruleBean.getSourceType());
        rule.set("status", (Object)RuleStatusEnum.ENABLE.getStatus());
        rule.set("sequence", (Object)(count + 1));
        rule.set("creator", (Object)RequestContext.get().getCurrUserId());
        rule.set("createtime", (Object)new Date());
        DynamicObject ruleAssign = BusinessDataServiceHelper.newDynamicObject((String)"emr_rule_assigncategory");
        ruleAssign.set("rule", (Object)rule.getLong("id"));
        ruleAssign.set("categoryentity", (Object)ruleBean.getCategoryEntity());
        ruleAssign.set("category", (Object)ruleBean.getCategoryId());
        ruleAssign.set("creator", (Object)RequestContext.get().getCurrUserId());
        ruleAssign.set("createtime", (Object)new Date());
        ArrayList ruleAssignTemplates = new ArrayList();
        ruleBean.getTemplates().forEach(template -> {
            DynamicObject ruleAssignTemplate = BusinessDataServiceHelper.newDynamicObject((String)"emr_rule_assigntemplate");
            ruleAssignTemplate.set("rule", (Object)rule.getLong("id"));
            ruleAssignTemplate.set("template", template.p1);
            ruleAssignTemplate.set("templategroup", template.p2);
            ruleAssignTemplate.set("executetype", (Object)RuleExecuteTypeEnum.SAVE.getValue());
            ruleAssignTemplate.set("creator", (Object)RequestContext.get().getCurrUserId());
            ruleAssignTemplate.set("createtime", (Object)new Date());
            ruleAssignTemplates.add(ruleAssignTemplate);
        });
        DynamicObjectCollection ruleSegments = rule.getDynamicObjectCollection("entryentity");
        if (ruleBean.getLogics() != null && !ruleBean.getLogics().isEmpty()) {
            for (int i = 0; i < ruleBean.getLogics().size(); ++i) {
                RuleLogic logic = (RuleLogic)ruleBean.getLogics().get(i);
                DynamicObject ruleSegment = ruleSegments.addNew();
                RuleSaveHelper.initRuleSegment(logic, ruleSegment, true);
                ruleSegment.set("seq", (Object)(i + 1));
            }
            TXUtils.required(tx -> {
                Object[] rules = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rule});
                DynamicObject ruleDy = (DynamicObject)rules[0];
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{ruleAssign});
                SaveServiceHelper.save((DynamicObject[])ruleAssignTemplates.toArray(new DynamicObject[0]));
                ruleBean.setId(Long.toString(ruleDy.getLong("id")));
                ruleBean.setSequence(ruleDy.getInt("sequence"));
            });
        }
    }

    public static void updateOneRule(RuleBean ruleBean) {
        RuleSaveHelper.checkBeforeSave(ruleBean);
        if (QueryServiceHelper.exists((String)"emr_rule_entity", (QFilter[])new QFilter[]{new QFilter("id", "!=", (Object)NumberUtils.toLong((String)ruleBean.getId())).and("model", "=", (Object)NumberUtils.toLong((String)ruleBean.getModelId())).and("domain", "=", (Object)NumberUtils.toLong((String)ruleBean.getDomainId())).and("number", "=", (Object)ruleBean.getNumber())})) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u89c4\u5219\u4fee\u6539\u5931\u8d25\uff0c\u5df2\u5b58\u5728\u7f16\u7801\u4e3a%1$s\u7684\u89c4\u5219\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u6267\u884c\u4fee\u6539\u3002", (String)"RuleSaveHelper_4", (String)"epm-emr-business", (Object[])new Object[0]), ruleBean.getNumber()));
        }
        DynamicObject rule = BusinessDataServiceHelper.loadSingle((Object)ruleBean.getId(), (String)"emr_rule_entity");
        rule.set("number", (Object)ruleBean.getNumber());
        rule.set("name", (Object)ruleBean.getName());
        rule.set("description", (Object)ruleBean.getDescription());
        rule.set("status", (Object)ruleBean.getStatus());
        rule.set("sequence", (Object)ruleBean.getSequence());
        rule.set("modifier", (Object)RequestContext.get().getCurrUserId());
        rule.set("modifytime", (Object)new Date());
        DynamicObjectCollection ruleSegments = rule.getDynamicObjectCollection("entryentity");
        HashMap ruleId2Dy = new HashMap();
        ruleSegments.forEach(ruleSegment -> ruleId2Dy.put(ruleSegment.getString("id"), ruleSegment));
        DynamicObject[] ruleDys = new DynamicObject[1];
        if (CollectionUtils.isNotEmpty((Collection)ruleBean.getLogics())) {
            for (int i = 0; i < ruleBean.getLogics().size(); ++i) {
                RuleLogic logic = (RuleLogic)ruleBean.getLogics().get(i);
                DynamicObject ruleSegmentDy = (DynamicObject)ruleId2Dy.get(logic.getId());
                if (ruleSegmentDy == null) {
                    ruleSegmentDy = ruleSegments.addNew();
                    RuleSaveHelper.initRuleSegment(logic, ruleSegmentDy, true);
                } else {
                    RuleSaveHelper.initRuleSegment(logic, ruleSegmentDy, false);
                }
                ruleSegmentDy.set("seq", (Object)(i + 1));
            }
        }
        TXUtils.required(tx -> {
            Object[] rules = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rule});
            ruleDys[0] = (DynamicObject)rules[0];
            DeleteServiceHelper.delete((String)"emr_rule_assigntemplate", (QFilter[])new QFilter("rule", "=", (Object)NumberUtils.toLong((String)ruleBean.getId())).toArray());
            ArrayList ruleAssignTemplates = new ArrayList();
            ruleBean.getTemplates().forEach(template -> {
                DynamicObject ruleAssignTemplate = BusinessDataServiceHelper.newDynamicObject((String)"emr_rule_assigntemplate");
                ruleAssignTemplate.set("rule", (Object)rule.getLong("id"));
                ruleAssignTemplate.set("template", template.p1);
                ruleAssignTemplate.set("templategroup", template.p2);
                ruleAssignTemplate.set("executetype", (Object)RuleExecuteTypeEnum.SAVE.getValue());
                ruleAssignTemplate.set("creator", (Object)RequestContext.get().getCurrUserId());
                ruleAssignTemplate.set("createtime", (Object)new Date());
                ruleAssignTemplates.add(ruleAssignTemplate);
            });
            SaveServiceHelper.save((DynamicObject[])ruleAssignTemplates.toArray(new DynamicObject[0]));
            if (ArrayUtils.isNotEmpty((Object[])ruleDys)) {
                DynamicObject ruleDy = ruleDys[0];
                long ruleId = ruleDy.getLong("id");
                LinkedHashMap map = new LinkedHashMap();
                map.put(ruleId, new LinkedHashMap());
                DynamicObjectCollection ruleSegmentDys = ruleDy.getDynamicObjectCollection("entryentity");
                ruleSegmentDys.stream().sorted(Comparator.comparingInt(ruleSegmentDy -> ruleSegmentDy.getInt("seq"))).forEach(ruleSegmentDy -> ((Map)map.get(ruleId)).put(ruleSegmentDy.getString("segment_number"), ruleSegmentDy.getLong("id")));
            }
        });
    }

    private static void initRuleSegment(RuleLogic logic, DynamicObject ruleSegment, boolean isAdd) {
        if (isAdd) {
            ruleSegment.set("id", (Object)logic.getId());
            ruleSegment.set("segment_creator", (Object)RequestContext.get().getCurrUserId());
            ruleSegment.set("segment_createtime", (Object)new Date());
        } else {
            ruleSegment.set("segment_modifier", (Object)RequestContext.get().getCurrUserId());
            ruleSegment.set("segment_modifytime", (Object)new Date());
        }
        ruleSegment.set("segment_number", (Object)logic.getLogicCode());
        ruleSegment.set("segment_name", (Object)logic.getLogicName());
        String ownerModel = logic.getLogicBelong() != null ? logic.getLogicBelong().getValue() : "";
        Long ownerModelId = Long.parseLong(org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)ownerModel) ? "0" : ownerModel);
        ruleSegment.set("segment_ownermodel", (Object)ownerModelId);
        ruleSegment.set("segment_comment", (Object)logic.getComment());
        String scope = JSONUtils.toJson((Object)logic.getScope(), (DateFormat)new LocalDateFormat());
        ruleSegment.set("segment_scope", (Object)scope);
        ruleSegment.set("segment_scopeshow", (Object)logic.getScopeText());
        String expression = JSONUtils.toJson((Object)logic.getExpressions(), (DateFormat)new LocalDateFormat());
        ruleSegment.set("segment_expression", (Object)expression);
        ruleSegment.set("segment_expressionshow", (Object)logic.getExpressionText());
        String scopeJs = RuleUtil.convertScope2Js((List)logic.getScope());
        String expressionJs = RuleUtil.convertExpression2Js((List)logic.getExpressions());
        String jsScript = scopeJs + System.lineSeparator() + expressionJs;
        ruleSegment.set("segment_jsexpr", (Object)jsScript);
        ruleSegment.set("segment_status", (Object)logic.getDisplayStatus().getValue());
        if (logic.getIsEnable()) {
            ruleSegment.set("segment_isenable", (Object)logic.getDisplayStatus().getValue());
        } else {
            ruleSegment.set("segment_isenable", (Object)RuleStatusEnum.RuleLogicStatusEnum.DisEnabled.getValue());
        }
        if (RuleStatusEnum.RuleLogicStatusEnum.Submited.getValue().equals(ruleSegment.getString("segment_status"))) {
            ruleSegment.set("segment_commitexpression", (Object)expression);
            ruleSegment.set("segment_commitscope", (Object)scope);
            ruleSegment.set("segment_commitjsexpr", (Object)ruleSegment.getString("segment_jsexpr"));
        }
    }

    public static void saveOneRuleLogic(RuleLogic ruleLogic) {
        DynamicObject rule = BusinessDataServiceHelper.loadSingle((Object)ruleLogic.getRuleId(), (String)"emr_rule_entity");
        DynamicObjectCollection ruleSegments = rule.getDynamicObjectCollection("entryentity");
        Optional<DynamicObject> ruleLogicDyOptional = ruleSegments.stream().filter(dy -> dy.getString("id").equals(ruleLogic.getId())).findFirst();
        if (!ruleLogicDyOptional.isPresent()) {
            DynamicObject ruleSegmentDy = ruleSegments.addNew();
            RuleSaveHelper.initRuleSegment(ruleLogic, ruleSegmentDy, true);
            ruleSegmentDy.set("seq", (Object)ruleSegments.size());
        } else {
            DynamicObject ruleSegmentDy = ruleLogicDyOptional.get();
            RuleSaveHelper.initRuleSegment(ruleLogic, ruleSegmentDy, false);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rule});
    }

    public static void deleteOneRuleLogic(RuleLogic ruleLogic) {
        DynamicObject rule = BusinessDataServiceHelper.loadSingle((Object)ruleLogic.getRuleId(), (String)"emr_rule_entity");
        DynamicObjectCollection ruleSegments = rule.getDynamicObjectCollection("entryentity");
        if (Objects.isNull(ruleLogic.getRuleId())) {
            return;
        }
        boolean isRemove = ruleSegments.removeIf(dy -> dy.getString("id").equals(ruleLogic.getId()));
        if (!isRemove) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u89c4\u5219\u903b\u8f91[%s]\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u52ff\u91cd\u590d\u6267\u884c\u3002", (String)"RuleSaveHelper_3", (String)"epm-emr-business", (Object[])new Object[0]), ruleLogic.getRuleId()));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rule});
    }

    public static boolean existRule(RuleLogic logic) {
        if (Objects.isNull(logic.getRuleId())) {
            return false;
        }
        DynamicObject rule = BusinessDataServiceHelper.loadSingle((Object)logic.getRuleId(), (String)"emr_rule_entity");
        DynamicObjectCollection ruleSegments = rule.getDynamicObjectCollection("entryentity");
        return ruleSegments.stream().anyMatch(dy -> dy.getString("id").equals(logic.getId()));
    }

    public static RuleBean fromDynamicObject(DynamicObject ruleDy) {
        RuleBean ruleBean = new RuleBean(Long.toString(ruleDy.getLong("id")));
        ruleBean.setModelId(Long.toString(ruleDy.getLong("model_id")));
        ruleBean.setDomainId(Long.toString(ruleDy.getLong("domain_id")));
        ruleBean.setDescription(ruleDy.getString("description"));
        ruleBean.setSourceType(ruleDy.getString("sourcetype"));
        ruleBean.setNumber(ruleDy.getString("number"));
        ruleBean.setName(ruleDy.getString("name"));
        ruleBean.setStatus(ruleDy.getString("status"));
        ruleBean.setSequence(ruleDy.getInt("sequence"));
        DynamicObjectCollection ruleAssignTemplates = QueryServiceHelper.query((String)"emr_rule_assigntemplate", (String)"template,templategroup", (QFilter[])new QFilter("rule", "=", (Object)ruleDy.getLong("id")).toArray());
        List templates = ruleAssignTemplates.stream().map(dy -> Pair.onePair((Object)dy.getLong("template"), (Object)dy.getLong("templategroup"))).collect(Collectors.toList());
        ruleBean.setTemplates(templates);
        DynamicObjectCollection ruleLogicDys = ruleDy.getDynamicObjectCollection("entryentity");
        ruleLogicDys.forEach(ruleLogicDy -> {
            RuleLogic ruleLogic = RuleSaveHelper.fromDynamicObject1(ruleLogicDy);
            ruleBean.addRuleLogic(ruleLogic);
            ruleLogic.setRuleId(ruleBean.getId());
        });
        return ruleBean;
    }

    public static RuleLogic fromDynamicObject1(DynamicObject ruleLogicDy) {
        DynamicObject owner;
        RuleLogic ruleLogic = new RuleLogic();
        ruleLogic.setId(ruleLogicDy.getString("id"));
        ruleLogic.setComment(ruleLogicDy.getString("segment_comment"));
        ruleLogic.setLogicName(ruleLogicDy.getString("segment_name"));
        ruleLogic.setLogicCode(ruleLogicDy.getString("segment_number"));
        if (StringUtils.isNotEmpty((String)ruleLogicDy.getString("segment_scope"))) {
            ruleLogic.setScope((List)JSONUtils.parse((String)ruleLogicDy.getString("segment_scope"), (TypeReference)new TypeReference<List<RuleScopeDim>>(){}));
        }
        if (StringUtils.isNotEmpty((String)ruleLogicDy.getString("segment_commitscope"))) {
            ruleLogic.setCommitScope((List)JSONUtils.parse((String)ruleLogicDy.getString("segment_commitscope"), (TypeReference)new TypeReference<List<RuleScopeDim>>(){}));
        }
        if (StringUtils.isNotEmpty((String)ruleLogicDy.getString("segment_expression"))) {
            ruleLogic.setExpressions((List)JSONUtils.parse((String)ruleLogicDy.getString("segment_expression"), (TypeReference)new TypeReference<List<RuleExpressionItem>>(){}));
        }
        if (StringUtils.isNotEmpty((String)ruleLogicDy.getString("segment_commitexpression"))) {
            ruleLogic.setCommitExpression((List)JSONUtils.parse((String)ruleLogicDy.getString("segment_commitexpression"), (TypeReference)new TypeReference<List<RuleExpressionItem>>(){}));
        }
        if ((owner = ruleLogicDy.getDynamicObject("segment_ownermodel")) != null) {
            RuleOptionProps props = new RuleOptionProps();
            props.setLabel(owner.getString("name"));
            props.setValue(owner.getString("id"));
            ruleLogic.setLogicBelong(props);
        }
        ruleLogic.setDisplayStatus(RuleStatusEnum.RuleLogicStatusEnum.getEnumFromValue((String)ruleLogicDy.getString("segment_status")));
        String enableStatus = ruleLogicDy.getString("segment_isenable");
        ruleLogic.setIsEnable(!RuleStatusEnum.RuleLogicStatusEnum.DisEnabled.getValue().equals(enableStatus));
        ruleLogic.setJsExpression(ruleLogicDy.getString("segment_jsexpr"));
        ruleLogic.setCommitJsExpression(ruleLogicDy.getString("segment_commitjsexpr"));
        ruleLogic.setSequence(ruleLogicDy.getString("seq"));
        return ruleLogic;
    }
}

