/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.business.template;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.emr.business.template.ISheetManager;
import kd.epm.emr.business.template.QuickFloatBean;
import kd.epm.emr.business.template.ReportContext;
import kd.epm.emr.business.template.areasetting.IDataAreaSetting;
import kd.epm.emr.business.template.areasetting.IFloatInfo;
import kd.epm.emr.business.template.headerarea.HeaderObject;
import kd.epm.emr.business.template.headerarea.IHeaderInfo;
import kd.epm.emr.business.template.headerarea.IHeaderObject;
import kd.epm.emr.business.template.service.ITranNumberService;
import kd.epm.emr.business.template.service.impl.TranNumberServiceImpl;
import kd.epm.epbs.common.cache.EpbsThreadCache;
import kd.epm.epbs.common.model.bean.BizModelBean;
import kd.epm.epbs.common.model.bean.DimensionBean;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.util.RangeModel;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CellInfo
implements Serializable {
    private static final long serialVersionUID = 4085714416344814977L;
    private static final String SEPARATOR_SIGN = "|";
    private static final String DIM_SEPARATOR_MEMBER = "\uff1a";
    private static final String DIM_SEPARATOR_DIM = "\uff0c";
    private static final String DIM_SEPARATOR_DIM2 = ";\n";
    private static final String MEMNUM_SEPARATOR_MEMNAME = " ";
    private static final String EXCHANGEMEMNUM = " >> ";
    private ReportContext context;
    private IDataAreaSetting areaSetting;
    private IFloatInfo floatInfo;
    private int r;
    private int c;
    private Map<String, IHeaderObject> dimHeaderObjMap = new HashMap<String, IHeaderObject>(16);
    private Map<String, String> rcDimMemMap = new HashMap<String, String>(16);
    private Map<String, String> allDimMemMap = new HashMap<String, String>(16);
    private List<String> allDims = new ArrayList<String>(16);
    private List<String> vpDims = new ArrayList<String>(16);
    private List<String> areaViewDims = new ArrayList<String>(16);
    private List<String> rcDims = new ArrayList<String>(16);
    private boolean isMDCell = false;
    private boolean isReport;
    private ITranNumberService tranNumberService;

    public ITranNumberService getTranNumberService() {
        return this.tranNumberService;
    }

    public final void setTranNumberService(ITranNumberService tranNumberService) {
        this.tranNumberService = tranNumberService;
    }

    public CellInfo(int r, int c, ISheetManager sm, ReportContext context) {
        this.r = r;
        this.c = c;
        this.context = context;
        boolean bl = this.isReport = sm.getFilterView() != null;
        if (r == -1 || c == -1 || context == null) {
            return;
        }
        this.setTranNumberService(new TranNumberServiceImpl(context));
        for (IDataAreaSetting areaRange : sm.getAreaRanges()) {
            RangeModel rangeModel = new RangeModel(areaRange.getAreaRange());
            if (!rangeModel.checkIsInArea(r, c)) continue;
            this.areaSetting = areaRange;
            if (CollectionUtils.isNotEmpty(areaRange.getFloatInfos())) {
                for (IFloatInfo info : areaRange.getFloatInfos()) {
                    QuickFloatBean qfb = new QuickFloatBean(areaRange, info);
                    if (!qfb.getFloatDataRange().checkIsInArea(r, c)) continue;
                    this.floatInfo = info;
                    break;
                }
            }
            int rOffset = r - rangeModel.getY_start();
            int cOffset = c - rangeModel.getX_start();
            this.fillPageMemberMap(sm);
            this.allDims.addAll(this.vpDims);
            if (!areaRange.isRelation()) {
                this.rcDims.addAll(areaRange.getRowColDims());
                this.fillAreaViewDim();
                this.fillHeaderMap(areaRange.getRowHeaders(), rOffset);
                this.fillHeaderMap(areaRange.getColHeaders(), cOffset);
                this.isMDCell = this.rcDims.size() == this.rcDimMemMap.size();
                this.allDims.addAll(this.areaViewDims);
            } else {
                this.rcDims.addAll(areaRange.getRelationAreaInfo().getCols());
            }
            this.allDims.addAll(this.rcDims);
            return;
        }
    }

    private HeaderObject getEasyHeaderObject(String memNum, String viewNum) {
        HeaderObject headerObject = new HeaderObject(false, memNum, viewNum);
        headerObject.setType("Dimension");
        return headerObject;
    }

    private final void fillAreaViewDim() {
        this.getAreaSetting().getAreaViewpointmembentry().forEach(v -> {
            if (v != null && v.getDimension() != null && v.getMember() != null) {
                this.getDimHeaderObjMap().put(v.getDimension().getNumber(), this.getEasyHeaderObject(v.getMember().getNumber(), v.getMember().getViewNumber()));
                this.getAllDimMemMap().put(v.getDimension().getNumber(), v.getMember().getNumber());
                this.getAreaViewDims().add(v.getDimension().getNumber());
            }
        });
    }

    private final void fillPageMemberMap(ISheetManager sm) {
        if (!this.isReport) {
            return;
        }
        ArrayList dimMembers = new ArrayList(16);
        dimMembers.addAll(sm.getFilterView().getViewPointDomain().getAllMembers());
        dimMembers.addAll(sm.getFilterView().getPageDomain().getAllMembers());
        dimMembers.forEach(mem -> {
            this.getDimHeaderObjMap().put(mem.getDimension().getNumber(), this.getEasyHeaderObject(mem.getNumber(), mem.getViewNumber()));
            this.getAllDimMemMap().put(mem.getDimension().getNumber(), mem.getNumber());
            this.getVpDims().add(mem.getDimension().getNumber());
        });
    }

    private final void fillHeaderMap(List<IHeaderInfo> infos, int offset) {
        for (IHeaderInfo headerInfo : infos) {
            IHeaderObject headerObject = headerInfo.getHeaderObjects().get(offset);
            if (!headerInfo.isDimension() || headerObject == null || !StringUtils.isNotEmpty((CharSequence)headerObject.getNumber())) continue;
            this.getRcDimMemMap().put(headerInfo.getNumber(), headerObject.getNumber());
            this.getAllDimMemMap().put(headerInfo.getNumber(), headerObject.getNumber());
            this.getDimHeaderObjMap().put(headerInfo.getNumber(), headerObject);
        }
    }

    public IDataAreaSetting getAreaSetting() {
        return this.areaSetting;
    }

    public IFloatInfo getFloatInfo() {
        return this.floatInfo;
    }

    public int getR() {
        return this.r;
    }

    public int getC() {
        return this.c;
    }

    public ReportContext getContext() {
        return this.context;
    }

    public long getModelId() {
        return this.getContext().getModelId();
    }

    public Map<String, IHeaderObject> getDimHeaderObjMap() {
        return this.dimHeaderObjMap;
    }

    public Map<String, String> getRcDimMemMap() {
        return this.rcDimMemMap;
    }

    public boolean isRelation() {
        return this.getAreaSetting() != null && this.getAreaSetting().isRelation();
    }

    public boolean isFloat() {
        return this.isRelation() || this.getFloatInfo() != null;
    }

    public boolean isMDCell() {
        return this.isMDCell;
    }

    public String getAllDimMemberMessage() {
        if (this.isMDCell()) {
            StringBuilder info = new StringBuilder();
            BizModelBean modelBean = EpbsModelCacheHelper.get((long)this.getModelId()).getBizModelById(this.getContext().getBizModelId());
            info.append(ResManager.loadKDString((String)"\u591a\u7ef4\u6a21\u578b", (String)"CellInfo_0", (String)"epm-emr-business", (Object[])new Object[0])).append(SEPARATOR_SIGN).append(modelBean.getNumber()).append(MEMNUM_SEPARATOR_MEMNAME).append(modelBean.getNameString()).append(DIM_SEPARATOR_DIM2);
            this.getAllDims().forEach(s -> this.fillSingleDimMemMessage((String)s, info, SEPARATOR_SIGN, MEMNUM_SEPARATOR_MEMNAME, DIM_SEPARATOR_DIM2));
            if (info.length() > 0) {
                return info.substring(0, info.length() - 1);
            }
        }
        return "";
    }

    public String getRCDimMemberMessage(boolean isContainView) {
        if (!this.isReport || this.isMDCell()) {
            StringBuilder info = new StringBuilder();
            if (isContainView) {
                this.getAreaViewDims().forEach(v -> this.fillSingleDimMemMessage((String)v, info, DIM_SEPARATOR_MEMBER, MEMNUM_SEPARATOR_MEMNAME, DIM_SEPARATOR_DIM));
            }
            this.getAreaSetting().getRowColDims().forEach(dim -> this.fillSingleDimMemMessage((String)dim, info, DIM_SEPARATOR_MEMBER, MEMNUM_SEPARATOR_MEMNAME, DIM_SEPARATOR_DIM));
            if (info.length() > 0) {
                return info.substring(0, info.length() - 1);
            }
        }
        return "";
    }

    private void fillSingleDimMemMessage(String dimNum, StringBuilder info, String dimSep, String memNumSepName, String dimSepDim) {
        IHeaderObject headerObject = this.getDimHeaderObjMap().get(dimNum);
        if (headerObject != null) {
            String oriNum = headerObject.getNumber();
            String number = this.getTranNumberService().getTranNumber(dimNum, headerObject);
            info.append(this.getDimName(dimNum)).append(dimSep);
            String numberStr = number;
            if (!StringUtils.equals((CharSequence)oriNum, (CharSequence)number)) {
                numberStr = String.join((CharSequence)EXCHANGEMEMNUM, oriNum, number);
            }
            info.append(numberStr).append(memNumSepName).append(this.getMemberName(dimNum, number, headerObject.getViewNumber())).append(dimSepDim);
        }
    }

    private String getMemberName(String dimNum, String memNum, String viewNum) {
        MemberBean memBean = EpbsThreadCache.findMemberBeanByNum((long)this.getModelId(), (String)dimNum, (String)viewNum, (String)memNum);
        if (memBean != null) {
            return memBean.getNameString();
        }
        return null;
    }

    private String getDimName(String dimNum) {
        return (String)ThreadCache.get((Object)String.join((CharSequence)SEPARATOR_SIGN, "getDimName", this.getModelId() + "", dimNum), () -> {
            DimensionBean dimBean = EpbsModelCacheHelper.get((long)this.getModelId()).getDimension(dimNum);
            if (dimBean != null) {
                return dimBean.getNameString();
            }
            return "";
        });
    }

    public Map<String, String> getAllDimMemMap() {
        return this.allDimMemMap;
    }

    public List<String> getAllDims() {
        return this.allDims;
    }

    public List<String> getVpDims() {
        return this.vpDims;
    }

    public List<String> getAreaViewDims() {
        return this.areaViewDims;
    }

    public List<String> getRcDims() {
        return this.rcDims;
    }
}

