/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.business.template;

import java.io.Serializable;
import kd.epm.emr.business.template.QuickFloatBean;
import kd.epm.emr.business.template.arearangedim.IRowColDimensionEntry;
import kd.epm.emr.business.template.areasetting.IDataAreaSetting;
import kd.epm.emr.business.template.areasetting.IFloatInfo;
import kd.epm.emr.business.template.headerarea.IHeaderInfo;
import kd.epm.emr.business.template.headerarea.IHeaderObject;
import kd.epm.emr.business.template.relation.RelationAreaInfo;
import kd.epm.epbs.common.util.RangeModel;

public class FloatCellInfo
implements Serializable {
    private static final long serialVersionUID = 4085714416344814977L;
    private IDataAreaSetting m;
    private IHeaderInfo headerInfo;
    private IFloatInfo iFloatInfo;
    private boolean isRelation;
    private RelationAreaInfo relationAreaInfo;
    private String fieldNum;
    private IRowColDimensionEntry rowColDimEntry;
    private String dimNum;
    private IHeaderObject headerObject;
    private int row;
    private int col;

    public FloatCellInfo(int row, int col, IDataAreaSetting m) {
        this.isRelation = true;
        this.relationAreaInfo = m.getRelationAreaInfo();
        this.m = m;
        RangeModel rangeModel = new RangeModel(m.getAreaRange());
        if (col < m.getColHeaders().size() + rangeModel.getX_start()) {
            this.fieldNum = this.relationAreaInfo.getCols().get(col - rangeModel.getX_start());
            this.headerInfo = m.getColHeaders().get(col - rangeModel.getX_start());
            this.dimNum = this.headerInfo.getRefDimension();
            this.headerObject = this.headerInfo.getHeaderObjects().get(row - rangeModel.getY_start());
        }
        this.row = row;
        this.col = col;
    }

    public FloatCellInfo(int row, int col, IDataAreaSetting m, IFloatInfo floatInfo) {
        this.iFloatInfo = floatInfo;
        this.m = m;
        this.isRelation = false;
        QuickFloatBean quickFloatBean = new QuickFloatBean(m, floatInfo);
        int offset = 0;
        int otherOffset = 0;
        if (quickFloatBean.isRowFloat()) {
            otherOffset = row - quickFloatBean.getDStart();
            offset = col - quickFloatBean.getOtherFStart();
        } else {
            otherOffset = col - quickFloatBean.getDStart();
            offset = row - quickFloatBean.getOtherFStart();
        }
        this.headerInfo = quickFloatBean.getHeaderInfos().get(offset);
        this.dimNum = this.headerInfo.getNumber();
        for (IRowColDimensionEntry entry : floatInfo.getPartition().getRowColDimensionEntries()) {
            if (!entry.getDimension().getNumber().equals(this.dimNum)) continue;
            this.rowColDimEntry = entry;
            break;
        }
        this.headerObject = this.headerInfo.getHeaderObjects().get(otherOffset);
        this.row = row;
        this.col = col;
    }

    public IDataAreaSetting getIDataAreaSetting() {
        return this.m;
    }

    public IHeaderInfo getHeaderInfo() {
        return this.headerInfo;
    }

    public IFloatInfo getiFloatInfo() {
        return this.iFloatInfo;
    }

    public boolean isRelation() {
        return this.isRelation;
    }

    public RelationAreaInfo getRelationAreaInfo() {
        return this.relationAreaInfo;
    }

    public String getFieldNum() {
        return this.fieldNum;
    }

    public String getDimNum() {
        return this.dimNum;
    }

    public IRowColDimensionEntry getRowColDimEntry() {
        return this.rowColDimEntry;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public IHeaderObject getHeaderObject() {
        return this.headerObject;
    }
}

