/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.business.template;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.epm.emr.business.template.IMultiSheetTemplateModel;
import kd.epm.emr.business.template.ITemplateModel;
import kd.epm.emr.business.template.TemplateInfo;
import kd.epm.emr.business.template.TemplateModel;
import kd.epm.emr.business.template.serializer.MultiSheetTemplateModelDeserializer;
import kd.epm.emr.business.template.serializer.MultiSheetTemplateModelSerializer;
import org.apache.commons.collections4.CollectionUtils;

@JsonSerialize(using=MultiSheetTemplateModelSerializer.class)
@JsonDeserialize(using=MultiSheetTemplateModelDeserializer.class)
public class MultiSheetTemplateModel<T extends TemplateInfo>
implements IMultiSheetTemplateModel<T> {
    private T templateBaseInfo;
    private Map<String, ITemplateModel> templateModels = new HashMap<String, ITemplateModel>(16);
    private List<String> sheetNames = new ArrayList<String>(16);

    public static <T extends TemplateInfo> MultiSheetTemplateModel<T> getInstance() {
        return new MultiSheetTemplateModel<T>();
    }

    @Override
    public void setTemplateBaseInfo(T templateBaseInfo) {
        this.templateBaseInfo = templateBaseInfo;
        this.getTemplateModels().entrySet().forEach(e -> ((ITemplateModel)e.getValue()).setTemplateBaseInfo(templateBaseInfo));
    }

    @Override
    public T getTemplateBaseInfo() {
        return this.getTemplateModels().get(this.sheetNames.get(0)).getTemplateBaseInfo();
    }

    @Override
    public Map<String, ITemplateModel> getTemplateModels() {
        return this.templateModels;
    }

    @Override
    public List<String> getSheetNames() {
        ArrayList<String> sheets = new ArrayList<String>(16);
        if (CollectionUtils.isNotEmpty(this.sheetNames)) {
            sheets = new ArrayList<String>(this.sheetNames);
        }
        return sheets;
    }

    @Override
    public void setSheetNames(List<String> names) {
        this.sheetNames = names;
    }

    @Override
    public void addSheet(String name, int index) {
        if (this.sheetNames.size() >= index) {
            this.sheetNames.add(index, name);
            ITemplateModel<T> model = TemplateModel.getInstance();
            model.setTemplateBaseInfo(this.templateBaseInfo);
            model.getSheetManager().getSheet().setSheetName(name);
            this.getTemplateModels().put(name, model);
        }
    }

    @Override
    public void deleteSheet(String name) {
        this.sheetNames.remove(name);
        this.getTemplateModels().remove(name);
    }

    @Override
    public void deleteSheet(int index) {
        if (this.sheetNames.size() >= index) {
            String name = this.sheetNames.remove(index);
            this.getTemplateModels().remove(name);
        }
    }

    @Override
    public void initTemplateModel(ITemplateModel<T> templateModel) {
        String name = ((TemplateInfo)((Object)templateModel.getTemplateBaseInfo())).getTemplateSheet().get(0).getSheetName();
        this.sheetNames.add(name);
        this.getTemplateModels().put(name, templateModel);
        this.setTemplateBaseInfo(templateModel.getTemplateBaseInfo());
    }
}

