/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.business.template;

import java.io.Serializable;
import java.util.List;
import kd.epm.emr.business.template.areasetting.IDataAreaSetting;
import kd.epm.emr.business.template.areasetting.IFloatInfo;
import kd.epm.emr.business.template.headerarea.IHeaderInfo;
import kd.epm.emr.common.template.enums.FloatTypeEnum;
import kd.epm.epbs.common.util.RangeModel;

public class QuickFloatBean
implements Serializable {
    private static final long serialVersionUID = -623835134945816906L;
    private IDataAreaSetting dataAreaSetting;
    private IFloatInfo floatInfo;
    private List<String> dimNums;
    private List<IHeaderInfo> headerInfos;
    private Boolean isRowFloat;
    private RangeModel dataRange;
    private RangeModel floatRange;
    private RangeModel floatDataRange;
    private RangeModel originalFloatRange;
    private Integer sOffset;
    private Integer eOffset;
    private Integer otherStart;
    private Integer otherEnd;
    private Integer otherFStart;
    private Integer otherFEnd;
    private Integer start;
    private Integer end;
    private Integer fSize;
    private Integer oriFSize;
    private Integer dStart;
    private Integer dEnd;

    public QuickFloatBean(IDataAreaSetting dataAreaSetting, IFloatInfo floatInfo) {
        this.dataAreaSetting = dataAreaSetting;
        this.floatInfo = floatInfo;
    }

    public List<String> getDimNums() {
        if (this.dimNums == null) {
            this.dimNums = this.isRowFloat() ? this.dataAreaSetting.getRowdims() : this.dataAreaSetting.getColdims();
        }
        return this.dimNums;
    }

    public List<IHeaderInfo> getHeaderInfos() {
        if (this.headerInfos == null) {
            this.headerInfos = this.isRowFloat() ? this.dataAreaSetting.getRowHeaders() : this.dataAreaSetting.getColHeaders();
        }
        return this.headerInfos;
    }

    public boolean isRowFloat() {
        if (this.isRowFloat == null) {
            this.isRowFloat = FloatTypeEnum.ROW == this.floatInfo.getFloatType();
        }
        return this.isRowFloat;
    }

    public RangeModel getDataRange() {
        if (this.dataRange == null) {
            this.dataRange = new RangeModel(this.dataAreaSetting.getAreaRange());
        }
        return this.dataRange;
    }

    public RangeModel getFloatRange() {
        if (this.floatRange == null) {
            this.floatRange = this.dataAreaSetting.getFloatRange(this.floatInfo, this.getDataRange());
        }
        return this.floatRange;
    }

    public RangeModel getFloatDataRange() {
        if (this.floatDataRange == null) {
            int y_end;
            int y_start;
            int x_end;
            int x_start;
            RangeModel dRange = this.getDataRange();
            RangeModel fRange = this.getFloatRange();
            if (this.isRowFloat()) {
                x_start = dRange.getX_start();
                x_end = dRange.getX_end();
                y_start = fRange.getY_start();
                y_end = fRange.getY_end();
            } else {
                x_start = fRange.getX_start();
                x_end = fRange.getX_end();
                y_start = dRange.getY_start();
                y_end = dRange.getY_end();
            }
            this.floatDataRange = new RangeModel(x_start, x_end, y_start, y_end);
        }
        return this.floatDataRange;
    }

    public RangeModel getOriginalFloatRange() {
        if (this.originalFloatRange == null) {
            this.originalFloatRange = new RangeModel(this.floatInfo.getOriginalRange());
        }
        return this.originalFloatRange;
    }

    public int getSOffset() {
        if (this.sOffset == null) {
            this.sOffset = this.isRowFloat() ? this.floatInfo.getRow_offset() : this.floatInfo.getCol_offset();
        }
        return this.sOffset;
    }

    public int getEOffset() {
        if (this.eOffset == null) {
            this.eOffset = this.isRowFloat() ? this.floatInfo.getRowEnd_offset() : this.floatInfo.getColEnd_offset();
        }
        return this.eOffset;
    }

    public int getOtherStart() {
        if (this.otherStart == null) {
            this.otherStart = this.isRowFloat() ? this.getDataRange().getX_start() : this.getDataRange().getY_start();
        }
        return this.otherStart;
    }

    public int getOtherEnd() {
        if (this.otherEnd == null) {
            this.otherEnd = this.isRowFloat() ? this.getDataRange().getX_end() : this.getDataRange().getY_end();
        }
        return this.otherEnd;
    }

    public Integer getOtherFStart() {
        if (this.otherFStart == null) {
            this.otherFStart = this.isRowFloat() ? this.getFloatRange().getX_start() : this.getFloatRange().getY_start();
        }
        return this.otherFStart;
    }

    public Integer getOtherFEnd() {
        if (this.otherFEnd == null) {
            this.otherFEnd = this.isRowFloat() ? this.getFloatRange().getX_end() : this.getFloatRange().getY_end();
        }
        return this.otherFEnd;
    }

    public int getStart() {
        if (this.start == null) {
            this.start = this.isRowFloat() ? this.getFloatRange().getY_start() : this.getFloatRange().getX_start();
        }
        return this.start;
    }

    public int getEnd() {
        if (this.end == null) {
            this.end = this.isRowFloat() ? this.getFloatRange().getY_end() : this.getFloatRange().getX_end();
        }
        return this.end;
    }

    public int getfSize() {
        if (this.fSize == null) {
            this.fSize = this.isRowFloat() ? this.getFloatRange().getRowSize() : this.getFloatRange().getColSize();
        }
        return this.fSize;
    }

    public int getOriFSize() {
        if (this.oriFSize == null) {
            this.oriFSize = this.isRowFloat() ? this.getOriginalFloatRange().getRowSize() : this.getOriginalFloatRange().getColSize();
        }
        return this.oriFSize;
    }

    public Integer getDStart() {
        if (this.dStart == null) {
            this.dStart = this.isRowFloat() ? this.getDataRange().getY_start() : this.getDataRange().getX_start();
        }
        return this.dStart;
    }

    public Integer getDEnd() {
        if (this.dEnd == null) {
            this.dEnd = this.isRowFloat() ? this.getDataRange().getY_end() : this.getDataRange().getX_end();
        }
        return this.dEnd;
    }
}

