/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.business.template;

import java.io.Serializable;
import kd.bos.util.StringUtils;
import kd.epm.emr.common.spread.domain.view.builder.dynamic.event.AdjustRangeEvent;
import kd.epm.emr.common.spread.domain.view.builder.dynamic.event.IAdjustRange;
import kd.epm.emr.common.template.enums.SeqTypeEnum;
import kd.epm.epbs.common.util.RangeModel;

public class SequenceInfo
implements Serializable,
IAdjustRange {
    private static final long serialVersionUID = 1L;
    public static final int DIRECT_H = 1;
    public static final int DIRECT_V = 2;
    private String dataArea;
    private String seqArea;
    private String oriSeqArea;
    private SeqTypeEnum typeEnum;
    private int initvalue;
    private int endValue;
    private SequenceInfo fromArea;
    private String prefix;
    private String suffix;
    private int direct;
    private String fixValue;

    public SequenceInfo(String dataArea, SeqTypeEnum typeEnum) {
        this.dataArea = dataArea;
        this.typeEnum = typeEnum;
    }

    public boolean isRecount() {
        return SeqTypeEnum.RECOUNT == this.typeEnum;
    }

    public boolean isFixValue() {
        return SeqTypeEnum.FIX == this.typeEnum;
    }

    public String getFixValue() {
        return this.fixValue;
    }

    public void setFixValue(String fixValue) {
        this.fixValue = fixValue;
    }

    public void initAllValue(String seqArea, SeqTypeEnum typeEnum, int initvalue, SequenceInfo fromArea, String prefix, String suffix, int direct, String fixValue) {
        if (StringUtils.isNotEmpty((String)seqArea)) {
            seqArea = new RangeModel(seqArea).getAreaRangeStr();
        }
        this.typeEnum = typeEnum;
        this.seqArea = seqArea;
        this.direct = direct;
        if (SeqTypeEnum.FIX == typeEnum) {
            this.initvalue = -1;
            this.fromArea = null;
            this.prefix = null;
            this.suffix = null;
            this.fixValue = fixValue;
        } else {
            this.initvalue = initvalue;
            this.fromArea = fromArea;
            this.prefix = prefix;
            this.suffix = suffix;
            this.fixValue = null;
        }
    }

    public SeqTypeEnum getTypeEnum() {
        return this.typeEnum;
    }

    public void setTypeEnum(SeqTypeEnum typeEnum) {
        this.typeEnum = typeEnum;
    }

    public String getDataArea() {
        return this.dataArea;
    }

    public void setDataArea(String dataArea) {
        this.dataArea = dataArea;
    }

    public String getSeqArea() {
        return this.seqArea;
    }

    public void setSeqArea(String seqArea) {
        if (StringUtils.isNotEmpty((String)seqArea)) {
            seqArea = new RangeModel(seqArea).getAreaRangeStr();
        }
        this.seqArea = seqArea;
    }

    public int getInitvalue() {
        return this.initvalue;
    }

    public void setInitvalue(int initvalue) {
        this.initvalue = initvalue;
    }

    public SequenceInfo getFromArea() {
        return this.fromArea;
    }

    public void setFromArea(SequenceInfo fromArea) {
        if (fromArea != null) {
            this.typeEnum = SeqTypeEnum.QUOTE;
        }
        this.fromArea = fromArea;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public int getDirect() {
        return this.direct;
    }

    public void setDirect(int direct) {
        this.direct = direct;
    }

    public boolean isDirectHoriz() {
        return 1 == this.direct;
    }

    public String getOriSeqArea() {
        return this.oriSeqArea;
    }

    public void setOriSeqArea(String oriSeqArea) {
        this.oriSeqArea = oriSeqArea;
    }

    public void adjustRange(AdjustRangeEvent event, boolean isFromReport) {
        String oldSeqArea = this.getSeqArea();
        RangeModel oldSeqRM = new RangeModel(oldSeqArea);
        String endPs = oldSeqRM.getEndPoint().toString();
        String startPos = this.doAdjustRange(event, oldSeqRM.getStartPoint().toString(), false, endPs);
        if (this.dealSpecialRange(startPos)) {
            return;
        }
        String endPos = this.doAdjustRange(event, endPs, true, endPs);
        if (this.dealSpecialRange(endPos)) {
            return;
        }
        RangeModel rangeModel = new RangeModel(startPos + ":" + endPos);
        if (rangeModel.getX_start() <= rangeModel.getX_end() && rangeModel.getY_start() <= rangeModel.getY_end()) {
            boolean isDrect;
            boolean bl = isDrect = this.direct == 1;
            if (isDrect) {
                rangeModel.setY_start(rangeModel.getY_end());
            } else {
                rangeModel.setX_start(rangeModel.getX_end());
            }
        }
        this.seqArea = rangeModel.getAreaRangeStr();
        if (!oldSeqArea.equals(this.seqArea)) {
            this.setOriSeqArea(oldSeqArea);
        }
    }

    private boolean dealSpecialRange(String pos) {
        if ("#".equals(pos)) {
            this.seqArea = "B1:A1";
            return true;
        }
        return false;
    }

    public int getEndValue() {
        return this.endValue;
    }

    public void setEndValue(int endValue) {
        this.endValue = endValue;
    }

    public boolean isExitEffectValue() {
        return this.initvalue != this.endValue;
    }
}

