/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.business.template;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.epm.emr.business.template.FloatCellInfo;
import kd.epm.emr.business.template.ISheetManager;
import kd.epm.emr.business.template.QuickFloatBean;
import kd.epm.emr.business.template.areasetting.IDataAreaSetting;
import kd.epm.emr.business.template.areasetting.IFloatInfo;
import kd.epm.emr.business.template.serializer.SheetManagerDeserializer;
import kd.epm.emr.business.template.serializer.SheetManagerSerializer;
import kd.epm.emr.common.spread.domain.view.FilterView;
import kd.epm.emr.common.spread.sheet.ISheet;
import kd.epm.emr.common.spread.sheet.Sheet;
import kd.epm.epbs.common.util.RangeModel;
import org.apache.commons.collections4.CollectionUtils;

@JsonSerialize(using=SheetManagerSerializer.class)
@JsonDeserialize(using=SheetManagerDeserializer.class)
public class SheetManager
implements ISheetManager {
    private static final long serialVersionUID = -3290820211595208978L;
    private ISheet sheet = new Sheet();
    private FilterView filterView = null;
    private List<IDataAreaSetting> areaRanges = new ArrayList<IDataAreaSetting>();
    private Map<String, Object> userObject;

    public SheetManager() {
    }

    public SheetManager(ISheet sheet, FilterView filterView, List<IDataAreaSetting> areaRanges) {
        this.sheet = sheet;
        this.filterView = filterView;
        this.areaRanges = areaRanges;
    }

    @Override
    public ISheet getSheet() {
        return this.sheet;
    }

    @Override
    public void setSheet(ISheet sheet) {
        this.sheet = sheet;
    }

    @Override
    public void setAreaRanges(List<IDataAreaSetting> areaRanges) {
        this.areaRanges = areaRanges;
    }

    @Override
    public List<IDataAreaSetting> getAreaRanges() {
        return this.areaRanges;
    }

    @Override
    public void addAreaRange(IDataAreaSetting areaRange) {
        this.areaRanges.add(areaRange);
    }

    @Override
    public void replaceAreaRange(IDataAreaSetting old, IDataAreaSetting areaSetting) {
        if (this.areaRanges != null) {
            if (old != null) {
                this.areaRanges.removeIf(m -> m.getAreaRange().equals(old.getAreaRange()));
            }
            if (areaSetting != null) {
                this.areaRanges.add(areaSetting);
            }
        }
    }

    @Override
    public boolean hasAreaRange() {
        return CollectionUtils.isNotEmpty(this.areaRanges);
    }

    @Override
    public boolean hasFloatAreaRange() {
        return this.hasAreaRange() && this.areaRanges.stream().anyMatch(m -> CollectionUtils.isNotEmpty(m.getFloatInfos()) || m.isRelation());
    }

    @Override
    public FilterView getFilterView() {
        return this.filterView;
    }

    @Override
    public void setFilterView(FilterView filterView) {
        this.filterView = filterView;
    }

    @Override
    public <T> T getUserObject(String key) {
        if (this.userObject == null) {
            return null;
        }
        return (T)this.userObject.get(key);
    }

    @Override
    public void putUserObject(String key, Object val) {
        if (this.userObject == null) {
            this.userObject = new HashMap<String, Object>();
        }
        this.userObject.put(key, val);
    }

    @Override
    public FloatCellInfo getFloatCellInfo(int row, int col) {
        for (IDataAreaSetting m : this.getAreaRanges()) {
            List<IFloatInfo> floatInfos = m.getFloatInfos();
            RangeModel dataRange = new RangeModel(m.getAreaRange());
            if (dataRange.checkIsInArea(row, col)) {
                if (m.isRelation()) {
                    return new FloatCellInfo(row, col, m);
                }
                return null;
            }
            if (!CollectionUtils.isNotEmpty(floatInfos)) continue;
            for (IFloatInfo floatInfo : floatInfos) {
                QuickFloatBean quickFloatBean = new QuickFloatBean(m, floatInfo);
                if (!quickFloatBean.getFloatRange().checkIsInArea(row, col)) continue;
                return new FloatCellInfo(row, col, m, floatInfo);
            }
        }
        return null;
    }
}

