/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.business.template;

import com.google.common.base.CharMatcher;
import java.math.BigDecimal;
import java.util.List;
import java.util.regex.Pattern;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.epm.emr.business.template.ISheetManager;
import kd.epm.emr.business.template.TemplateModelJSONUtil;
import kd.epm.emr.common.spread.common.variant.Variant;

public class SpreadDataModelUtil {
    private static String AMOUNT_PATTERN = "^\\(?((-?([0-9]+|[0-9]{1,3}(,[0-9]{3})*))(\\.[0-9]{1,})?)\\)?$";

    public static boolean notEquals(Object val, Variant oldCellData) {
        boolean oldValIsNull;
        val = SpreadDataModelUtil.dealValue(val);
        Variant temp = SpreadDataModelUtil.convert2Variant(val);
        boolean bl = oldValIsNull = oldCellData == null || oldCellData.isNull() || oldCellData.isEmpty();
        return oldValIsNull && val != null && StringUtils.isNotEmpty((String)val.toString()) || !oldValIsNull && val == null || !oldValIsNull && temp.compareTo((Object)oldCellData) != 0;
    }

    public static Variant convert2Variant(Object val) {
        if (val instanceof BigDecimal) {
            return new Variant(val);
        }
        if (val instanceof Number) {
            return new Variant(new BigDecimal(val.toString()));
        }
        if (val instanceof Variant && Variant.encryptVariant.equals(val)) {
            return (Variant)val;
        }
        return new Variant(val);
    }

    public static Object dealValue(Object val) {
        if (val instanceof String && val != null && SpreadDataModelUtil.isNotSupportExcelFormat(val.toString()) && !StringUtils.isNumeric((String)val.toString())) {
            String vdata = SpreadDataModelUtil.removeAmountSign(val.toString().trim()).trim();
            boolean isNegative = vdata.startsWith("(");
            String validateData = vdata.replaceAll("\\(", "").replaceAll("\\)", "").replaceAll(",", "");
            if (!validateData.startsWith("-") && isNegative) {
                validateData = "-" + validateData;
            }
            val = new BigDecimal(validateData);
        }
        return val;
    }

    protected static boolean isNotSupportExcelFormat(String data) {
        return StringUtils.isNotEmpty((String)data) && Pattern.matches(AMOUNT_PATTERN, data.trim());
    }

    private static String removeAmountSign(String data) {
        return data.replaceAll("[\\\\$,S\\\\$,\u00a3,\u00a5]", "");
    }

    public static String trim(String str) {
        return CharMatcher.anyOf((CharSequence)" \u000b\f\u00a0\u0085\u1680\u180e\ufeff\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u200b\u2028\u2029\u202f\u205f\u3000").trimFrom((CharSequence)str);
    }

    public static ISheetManager getSheetManager(String spreadSerial) {
        return TemplateModelJSONUtil.parseSheetManager(spreadSerial);
    }

    public static String toJson(ISheetManager sm) {
        return TemplateModelJSONUtil.toJsonSheetManager(sm);
    }

    public static String getInsertSheetName(List<String> sheetNames) {
        String prefix = "Sheet";
        int i = 1;
        boolean flag = true;
        String name = "";
        while (flag) {
            name = prefix + i;
            if (!sheetNames.contains(name)) {
                flag = false;
                continue;
            }
            name = "";
            if (i == 200) {
                throw new KDBizException("Automatic generation of sheet name failed.");
            }
            ++i;
        }
        return name;
    }
}

