/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.business.template;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.emr.business.template.TemplateSheet;
import kd.epm.emr.common.template.enums.TemplateTypeEnum;
import kd.epm.epbs.common.enums.status.StatusEnum;
import kd.epm.epbs.common.model.DynaEntityObject;
import kd.epm.epbs.common.util.ISupportGZip;
import kd.epm.epbs.common.util.JSONUtils;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import kd.epm.epbs.common.util.ThrowableHelper;
import org.apache.commons.collections4.CollectionUtils;

public class TemplateInfo
extends DynaEntityObject
implements ISupportGZip {
    private static final long serialVersionUID = 1L;
    public static final String NUMBER = "number";
    public static final String NAME = "name";
    public static final String TEMPLATECATALOG = "templatecatalog";
    public static final String TEMPLATETYPE = "templatetype";
    public static final String STATUS = "status";
    public static final String GROUP = "group";
    public static final String VERSIONNUMBER = "versionnumber";
    public static final String EFFECTIVEDATE = "effectivedate";
    public static final String EXPIRINGDATE = "expiringdate";
    public static final String VERSIONDESCRIPTION = "versiondescription";
    public static final String SHEETENTRY = "sheetentry";
    public static final String SHEETDATA = "sheetdata";
    public static final String SHEETSPREADJSON = "sheetspreadjson";
    public static final String SHEETPARAMS = "sheetparams";
    public static final String SHEETENTRY_SHEETPARAMS = "sheetentry.sheetparams";
    public static final String BUSINESSDOMAIN = "businessdomain";
    protected static final Set<String> BigFields = Sets.newHashSet((Object[])new String[]{"sheetentry.sheetdata", "sheetentry.sheetspreadjson"});
    private boolean isModify = true;
    protected Map<String, Object> bizTemplate;
    protected String memberQuoteEntityNumber = null;

    public TemplateInfo() {
        this.setDataEntityNumber(null);
        this.put(SHEETENTRY, (Object)Lists.newArrayList());
    }

    public TemplateInfo(Map<String, Object> bizTemplate) {
        this();
        this.bizTemplate = bizTemplate;
    }

    public final Object put(String key, Object value) {
        if (this.isModify) {
            if (null != this.bizTemplate) {
                return this.bizTemplate.put(key.toLowerCase(Locale.ENGLISH), value);
            }
            return super.put(key.toLowerCase(Locale.ENGLISH), value);
        }
        throw new UnsupportedOperationException();
    }

    public <T> T get(String key) {
        if (!"dataEntityNumber".equals(key) && null != this.bizTemplate) {
            return (T)this.bizTemplate.get(key.toLowerCase(Locale.ENGLISH));
        }
        return (T)super.get(key);
    }

    public Map<String, Object> getBizTemplate() {
        return this.bizTemplate;
    }

    public void setBizTemplate(Map<String, Object> bizTemplate) {
        this.bizTemplate = bizTemplate;
    }

    public String getMemberQuoteEntityNumber() {
        return this.memberQuoteEntityNumber;
    }

    public long getCreatorId() {
        return this.get("creator") == null ? 0L : (Long)this.get("creator");
    }

    public void setCreatorId(long creatorId) {
        this.put("creator", (Object)creatorId);
    }

    public Date getCreateTime() {
        return (Date)this.get("createtime");
    }

    public void setCreateTime(Date createTime) {
        this.put("createtime", (Object)createTime);
    }

    public long getModifierId() {
        return this.get("modifier") == null ? 0L : (Long)this.get("modifier");
    }

    public void setModifierId(long modifierId) {
        this.put("modifier", (Object)modifierId);
    }

    public Date getModifyTime() {
        return (Date)this.get("modifyTime");
    }

    public void setModifyTime(Date modifyTime) {
        this.put("modifyTime", (Object)modifyTime);
    }

    public String getNameString() {
        Object obj = this.get(NAME);
        if (obj instanceof ILocaleString) {
            return ((ILocaleString)obj).toString();
        }
        return obj.toString();
    }

    public Object getTemplatecatalog() {
        return this.get(TEMPLATECATALOG) == null ? Long.valueOf(0L) : this.get(TEMPLATECATALOG);
    }

    public void setTemplatecatalog(Object templatecatalog) {
        this.put(TEMPLATECATALOG, templatecatalog);
    }

    public long getTemplatecatalogId() {
        Object catalog = this.getTemplatecatalog();
        if (catalog instanceof Long) {
            return (Long)catalog;
        }
        return 0L;
    }

    public String getTemplatetype() {
        return (String)this.get(TEMPLATETYPE);
    }

    public void setTemplatetype(String templatetype) {
        this.put(TEMPLATETYPE, (Object)templatetype);
    }

    public String getDescription() {
        return (String)this.get("description");
    }

    public void setDescription(String description) {
        this.put("description", (Object)description);
    }

    public int getSequence() {
        return this.get("sequence") == null ? 0 : (Integer)this.get("sequence");
    }

    public void setSequence(int sequence) {
        this.put("sequence", (Object)sequence);
    }

    public String getStatus() {
        return (String)this.get(STATUS);
    }

    public void setStatus(String status) {
        this.put(STATUS, (Object)status);
    }

    public Date getEffectivedate() {
        return (Date)this.get(EFFECTIVEDATE);
    }

    public void setEffectivedate(Date effectivedate) {
        this.put(EFFECTIVEDATE, (Object)effectivedate);
    }

    public Date getExpiringdate() {
        return (Date)this.get(EXPIRINGDATE);
    }

    public void setExpiringdate(Date expiringdate) {
        this.put(EXPIRINGDATE, (Object)expiringdate);
    }

    public void setModelId(long modelId) {
        this.put("model", (Object)modelId);
    }

    public long getModelId() {
        return this.get("model") == null ? 0L : (Long)this.get("model");
    }

    public String getParams() {
        return (String)this.get("params");
    }

    public void setParams(String params) {
        this.put("params", (Object)params);
    }

    public void setGroup(long group) {
        this.put(GROUP, (Object)group);
    }

    public long getGroup() {
        return this.get(GROUP) == null ? 0L : (Long)this.get(GROUP);
    }

    public void setVersionNumber(BigDecimal versionnumber) {
        this.put(VERSIONNUMBER, (Object)versionnumber);
    }

    public BigDecimal getVersionNumber() {
        return (BigDecimal)this.get(VERSIONNUMBER);
    }

    public void setVersionDescription(Object versiondescription) {
        this.put(VERSIONDESCRIPTION, versiondescription);
    }

    public ILocaleString getVersionDescription() {
        return (ILocaleString)this.get(VERSIONDESCRIPTION);
    }

    public List<TemplateSheet> getTemplateSheet() {
        return (List)this.get(SHEETENTRY);
    }

    public Boolean isMultisheet() {
        return (Boolean)this.get("ismultisheet");
    }

    public void setIsMultisheet(Boolean ismultisheet) {
        this.put("ismultisheet", (Object)ismultisheet);
    }

    public Long getBusinessDomain() {
        return this.get(BUSINESSDOMAIN) == null ? Long.valueOf(0L) : (Long)this.get(BUSINESSDOMAIN);
    }

    public void setBusinessDomain(Long businessDomainId) {
        this.put(BUSINESSDOMAIN, (Object)businessDomainId);
    }

    public void loadDynaObj2Model(DynamicObject dyna) {
        this.loadDynaObj2Model(dyna, false);
    }

    public void loadDynaObj2Model(DynamicObject dyna, boolean onlyBaseInfo) {
        try {
            this.transferDynaObj2Model(dyna, onlyBaseInfo);
        }
        catch (Throwable t) {
            throw new KDBizException(String.format("load [%s] template to model error!\n %s", dyna.getString(NUMBER), ThrowableHelper.toString((Throwable)t)));
        }
    }

    protected void transferDynaObj2Model(DynamicObject dyna, boolean onlyBaseInfo) {
        Predicate pexist = this.getPexist(dyna);
        this.setId(dyna.getLong("id"));
        this.setName(this.defaultIfNotExist(pexist, NAME, new LocaleString(), () -> dyna.get(NAME)));
        this.setNumber((String)this.defaultIfNotExist(pexist, NUMBER, "", () -> dyna.getString(NUMBER)));
        this.setCreateTime((Date)this.defaultIfNotExist(pexist, "createtime", null, () -> dyna.getDate("createtime")));
        this.setCreatorId((Long)this.defaultIfNotExist(pexist, "creator", 0L, () -> this.getDynaId(dyna, "creator")));
        this.setModifierId((Long)this.defaultIfNotExist(pexist, "modifier", 0L, () -> this.getDynaId(dyna, "modifier")));
        this.setModifyTime((Date)this.defaultIfNotExist(pexist, "modifytime", null, () -> dyna.getDate("modifytime")));
        this.setTemplatecatalog(this.defaultIfNotExist(pexist, TEMPLATECATALOG, 0L, () -> this.getDynaId(dyna, TEMPLATECATALOG)));
        this.setTemplatetype((String)this.defaultIfNotExist(pexist, TEMPLATETYPE, "1", () -> dyna.getString(TEMPLATETYPE)));
        this.setDescription((String)this.defaultIfNotExist(pexist, "description", "", () -> dyna.getString("description")));
        this.setSequence((Integer)this.defaultIfNotExist(pexist, "sequence", 1, () -> dyna.getInt("sequence")));
        this.setStatus((String)this.defaultIfNotExist(pexist, STATUS, StatusEnum.DISABLE.getCode(), () -> dyna.getString(STATUS)));
        this.setGroup((Long)this.defaultIfNotExist(pexist, GROUP, 0L, () -> dyna.getLong(GROUP)));
        this.setEffectivedate((Date)this.defaultIfNotExist(pexist, EFFECTIVEDATE, null, () -> dyna.getDate(EFFECTIVEDATE)));
        this.setExpiringdate((Date)this.defaultIfNotExist(pexist, EXPIRINGDATE, null, () -> dyna.getDate(EXPIRINGDATE)));
        this.setModelId((Long)this.defaultIfNotExist(pexist, "model", 0L, () -> this.getDynaId(dyna, "model")));
        this.setParams((String)this.defaultIfNotExist(pexist, "params", "", () -> dyna.getString("params")));
        this.setVersionNumber((BigDecimal)this.defaultIfNotExist(pexist, VERSIONNUMBER, BigDecimal.ZERO, () -> dyna.getBigDecimal(VERSIONNUMBER)));
        this.setVersionDescription(this.defaultIfNotExist(pexist, VERSIONDESCRIPTION, new LocaleString(), () -> dyna.get(VERSIONDESCRIPTION)));
        this.setIsMultisheet((Boolean)this.defaultIfNotExist(pexist, "ismultisheet", false, () -> dyna.getBoolean("ismultisheet")));
        this.setBusinessDomain((Long)this.defaultIfNotExist(pexist, BUSINESSDOMAIN, 0L, () -> this.getDynaId(dyna, BUSINESSDOMAIN)));
        if (!onlyBaseInfo && pexist.test(SHEETENTRY)) {
            this.getTemplateSheet().addAll(new TemplateSheet(this).loadDynaObject(dyna.getDynamicObjectCollection(SHEETENTRY), () -> this));
        }
        this.getParamsByCustom();
        this.transferDynaObj2ModelCustom(dyna, onlyBaseInfo);
    }

    protected void transferDynaObj2ModelCustom(DynamicObject dyna, boolean onlyBaseInfo) {
    }

    protected Set<String> getBigFields() {
        return BigFields;
    }

    public Set<String> getBaseInfoFields() {
        DynamicObject orm = ORM.create().newDynamicObject(this.getDataEntityNumber());
        DataEntityPropertyCollection propertys = orm.getDataEntityType().getProperties();
        Set<String> props = propertys.stream().map(e -> e.getName()).collect(Collectors.toList()).stream().filter(e -> !e.endsWith("_id") && !e.equals("multilanguagetext")).collect(Collectors.toSet());
        Set sheetEntryProps = TemplateInfo.getEntryFields((DataEntityPropertyCollection)propertys, (String)SHEETENTRY);
        if (CollectionUtils.isNotEmpty((Collection)sheetEntryProps)) {
            props.addAll(sheetEntryProps);
        }
        props.removeAll(this.getBigFields());
        return props;
    }

    public TemplateInfo genSimpleModel(Long templateId) {
        return this.genModel(templateId, true);
    }

    public TemplateInfo genModel(Long templateId, boolean onlyBaseInfo) {
        DynamicObject dyna = null;
        dyna = !onlyBaseInfo ? BusinessDataServiceHelper.loadSingle((Object)templateId, (String)this.getDataEntityNumber()) : BusinessDataServiceHelper.loadSingle((Object)templateId, (String)this.getDataEntityNumber(), (String)String.join((CharSequence)",", this.getBaseInfoFields()));
        return this.genModel(dyna, onlyBaseInfo);
    }

    public TemplateInfo genModel(DynamicObject dyna, boolean onlyBaseInfo) {
        this.loadDynaObj2Model(dyna, onlyBaseInfo);
        return this;
    }

    public final TemplateInfo genImmutableModel(DynamicObject dyna) {
        TemplateInfo object = this.genModel(dyna, false);
        object.isModify = false;
        return object;
    }

    public final TemplateInfo genSimpleImmutableModel(DynamicObject dyna) {
        TemplateInfo object = this.genModel(dyna, true);
        object.isModify = false;
        return object;
    }

    public Map<String, Object> getParamsByCustom() {
        Map paramsMap = (Map)this.get("customparams");
        if (null == paramsMap && StringUtils.isNotEmpty((String)this.getParams())) {
            paramsMap = (Map)this.paramsFromJson();
            this.put("customparams", (Object)paramsMap);
        }
        return paramsMap;
    }

    public void setParamsByCustom(Map<String, Object> paramsMap) {
        this.put("customparams", paramsMap);
        String params = this.paramsToJson(paramsMap);
        this.setParams(params);
    }

    public void putParam(String key, Object value) {
        if (StringUtils.isEmpty((String)key) || null == value) {
            return;
        }
        HashMap paramsMap = this.getParamsByCustom();
        if (null == paramsMap) {
            paramsMap = Maps.newHashMap();
        }
        paramsMap.put(key, value);
        this.setParamsByCustom(paramsMap);
    }

    private String paramsToJson(Object paramsMap) {
        if (null == paramsMap) {
            return null;
        }
        return JSONUtils.toString((Object)paramsMap);
    }

    private <T> T paramsFromJson() {
        return (T)JSONUtils.parse((String)this.getParams(), (TypeReference)new TypeReference<T>(){});
    }

    public static String toByteSerialized(Object obj) {
        return ObjectSerialUtil.toByteSerialized((Object)obj);
    }

    public static <T> T deSerializedBytes(String serial) {
        return (T)ObjectSerialUtil.deSerializedBytes((String)serial);
    }

    public <T extends TemplateInfo> T cloneBaseInfo() {
        TemplateInfo cloneObj = (TemplateInfo)((Object)this.clone());
        this.getBigFields().forEach(e -> {
            cloneObj.remove((String)e);
            cloneObj.getTemplateSheet().forEach(s -> s.remove(e));
        });
        return (T)((Object)cloneObj);
    }

    public TemplateSheet addSingleTemplateSheet(String sheetName) {
        if (CollectionUtils.isEmpty(this.getTemplateSheet())) {
            TemplateSheet sheet = new TemplateSheet(this);
            sheet.setSeq(0);
            sheet.setSheetName(sheetName);
            this.getTemplateSheet().add(sheet);
        } else if (StringUtils.isNotEmpty((String)sheetName)) {
            this.getTemplateSheet().get(0).setSheetName(sheetName);
        }
        return this.getTemplateSheet().get(0);
    }

    public String getData() {
        this.loadTemplateSheet(false);
        return CollectionUtils.isNotEmpty(this.getTemplateSheet()) ? this.getTemplateSheet().get(0).getData() : "";
    }

    public void setData(String data) {
        this.addSingleTemplateSheet(null);
        this.getTemplateSheet().get(0).setData(data);
    }

    public String getSpreadJson() {
        this.loadTemplateSheet(false);
        return CollectionUtils.isNotEmpty(this.getTemplateSheet()) ? this.getTemplateSheet().get(0).getSpreadJson() : "";
    }

    public void setSpreadJson(String spreadjson) {
        this.getTemplateSheet().get(0).setSpreadJson(spreadjson);
    }

    public void loadTemplateSheet(boolean isForce) {
        if ((isForce || !isForce && CollectionUtils.isEmpty(this.getTemplateSheet())) && QueryServiceHelper.exists((String)this.getDataEntityNumber(), (Object)this.getId())) {
            DynamicObject orm = ORM.create().newDynamicObject(this.getDataEntityNumber());
            DataEntityPropertyCollection propertys = orm.getDataEntityType().getProperties();
            DynamicObject dyna = BusinessDataServiceHelper.loadSingle((Object)this.getId(), (String)this.getDataEntityNumber(), (String)String.join((CharSequence)",", TemplateInfo.getEntryFields((DataEntityPropertyCollection)propertys, (String)SHEETENTRY)));
            this.getTemplateSheet().addAll(new TemplateSheet(this).loadDynaObject(dyna.getDynamicObjectCollection(SHEETENTRY), () -> this));
        }
    }

    public TemplateTypeEnum getSingleSheetType() {
        this.addSingleTemplateSheet(null);
        return this.getTemplateSheet().get(0).getSheetType();
    }

    public void setSingleSheetType(TemplateTypeEnum typeEnum) {
        this.addSingleTemplateSheet(null);
        this.getTemplateSheet().get(0).setSheetType(typeEnum);
    }

    public void putSingleSheetParam(String key, Object value) {
        this.addSingleTemplateSheet(null);
        this.getTemplateSheet().get(0).putParam(key, value);
    }

    public Object getSingleSheetParam(String key) {
        this.addSingleTemplateSheet(null);
        return this.getTemplateSheet().get(0).getParam(key);
    }

    public Map<String, Object> getSingleSheetParam() {
        this.addSingleTemplateSheet(null);
        return this.getTemplateSheet().get(0).getSheetParamsMap();
    }

    public void setSingleSheet(Map<String, Object> paramsMap) {
        this.addSingleTemplateSheet(null);
        this.getTemplateSheet().get(0).setSheetParamsMap(paramsMap);
    }
}

