/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.business.template;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.util.StringUtils;
import kd.epm.emr.business.template.ISheetManager;
import kd.epm.emr.business.template.ITemplateModel;
import kd.epm.emr.business.template.SheetManager;
import kd.epm.emr.business.template.TemplateInfo;
import kd.epm.emr.business.template.TemplateModelJSONUtil;
import kd.epm.emr.business.template.pagedim.IPageDimensionEntry;
import kd.epm.emr.business.template.serializer.TemplateModelDeserializer;
import kd.epm.emr.business.template.serializer.TemplateModelSerializer;
import kd.epm.emr.business.template.viewpointdim.IViewPointDimensionEntry;
import kd.epm.emr.common.template.enums.TemplateTypeEnum;

@JsonSerialize(using=TemplateModelSerializer.class)
@JsonDeserialize(using=TemplateModelDeserializer.class)
public class TemplateModel<T extends TemplateInfo>
implements ITemplateModel<T> {
    private T templateBaseInfo;
    private final List<IViewPointDimensionEntry> viewpointmembentry = new ArrayList<IViewPointDimensionEntry>();
    private final List<IPageDimensionEntry> pagemembentry = new ArrayList<IPageDimensionEntry>();
    private Long bizModelId;

    public static <T extends TemplateInfo> ITemplateModel<T> getInstance() {
        return new TemplateModel<T>();
    }

    @Override
    public void setTemplateBaseInfo(T templateBaseInfo) {
        this.templateBaseInfo = templateBaseInfo;
    }

    @Override
    public T getTemplateBaseInfo() {
        return this.templateBaseInfo;
    }

    @Override
    public TemplateTypeEnum getTemplateType() {
        return ((TemplateInfo)((Object)this.getTemplateBaseInfo())).getSingleSheetType();
    }

    @Override
    public void setTemplateType(TemplateTypeEnum templateType) {
        ((TemplateInfo)((Object)this.getTemplateBaseInfo())).setSingleSheetType(templateType);
    }

    @Override
    public List<IViewPointDimensionEntry> getViewpointmembentry() {
        return this.viewpointmembentry;
    }

    @Override
    public void addViewpointmembentry(IViewPointDimensionEntry viewpointmembentry) {
        this.viewpointmembentry.add(viewpointmembentry);
    }

    @Override
    public void addViewpointmembentry(List<IViewPointDimensionEntry> viewpointmembentrys) {
        this.viewpointmembentry.addAll(viewpointmembentrys);
    }

    @Override
    public List<IPageDimensionEntry> getPagemembentry() {
        return this.pagemembentry;
    }

    @Override
    public void addPagemembentry(IPageDimensionEntry pagemembentry) {
        this.pagemembentry.add(pagemembentry);
    }

    @Override
    public void addPagemembentrys(List<IPageDimensionEntry> pagemembentrys) {
        this.pagemembentry.addAll(pagemembentrys);
    }

    @Override
    public List<String> getRowcolDims() {
        return (List)this.getParams().computeIfAbsent("rowcolDims", e -> Lists.newArrayList());
    }

    @Override
    public void setRowcolDims(List<String> rowcolDims) {
        this.putParam("rowcolDims", rowcolDims);
    }

    @Override
    public List<String> getFilterDims() {
        return (List)this.getParams().computeIfAbsent("filterDims", e -> Lists.newArrayList());
    }

    @Override
    public void setFilterDims(List<String> filterDims) {
        this.putParam("filterDims", filterDims);
    }

    @Override
    public Map<String, Long> getDimViews() {
        return (Map)this.getParams().computeIfAbsent("dimemsionViews", e -> Maps.newHashMap());
    }

    @Override
    public void setDimViews(Map<String, Long> dimViews) {
        this.putParam("dimemsionViews", dimViews);
    }

    @Override
    public String getBizModel() {
        return (String)this.getParam("bizModel", null);
    }

    @Override
    public void setBizModel(String bizModel) {
        this.putParam("bizModel", bizModel);
    }

    @Override
    public Long getBizModelId() {
        return this.bizModelId;
    }

    @Override
    public void setBizModelId(Long bizModelId) {
        this.bizModelId = bizModelId;
    }

    @Override
    public void setParams(Map<String, Object> params) {
        ((TemplateInfo)((Object)this.getTemplateBaseInfo())).setSingleSheet(params);
    }

    @Override
    public void putParam(String key, Object value) {
        ((TemplateInfo)((Object)this.getTemplateBaseInfo())).putSingleSheetParam(key, value);
    }

    @Override
    public Map<String, Object> getParams() {
        return ((TemplateInfo)((Object)this.getTemplateBaseInfo())).getSingleSheetParam();
    }

    @Override
    public Object getParam(String key) {
        return ((TemplateInfo)((Object)this.getTemplateBaseInfo())).getSingleSheetParam(key);
    }

    @Override
    public Object getParam(String key, Object defValue) {
        Object value = this.getParam(key);
        if (null == value) {
            value = defValue;
        }
        return value;
    }

    @Override
    public ISheetManager getSheetManager() {
        String data = ((TemplateInfo)((Object)this.getTemplateBaseInfo())).getData();
        ISheetManager sheetManager = null;
        if (StringUtils.isEmpty((String)data)) {
            sheetManager = new SheetManager();
            ((TemplateInfo)((Object)this.getTemplateBaseInfo())).setData(TemplateModelJSONUtil.toJsonSheetManager(sheetManager));
        } else {
            sheetManager = TemplateModelJSONUtil.parseSheetManager(data);
        }
        return sheetManager;
    }

    @Override
    public void setSheetManager(ISheetManager sm) {
        ((TemplateInfo)((Object)this.getTemplateBaseInfo())).setData(TemplateModelJSONUtil.toJsonSheetManager(sm));
    }

    @Override
    public Object clone() {
        return this.paseStringToTemplate(this.toJson());
    }

    @Override
    public boolean isSelected() {
        return (Boolean)this.getParam("isSelected", false);
    }

    @Override
    public void setSelected(boolean selected) {
        this.putParam("isSelected", selected);
    }

    @Override
    public boolean isHide() {
        return (Boolean)this.getParam("isHide", false);
    }

    @Override
    public void setHide(boolean hide) {
        this.putParam("isHide", hide);
    }
}

