/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.business.template;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.util.StringUtils;
import kd.epm.emr.business.template.TemplateInfo;
import kd.epm.emr.common.template.enums.TemplateTypeEnum;
import kd.epm.epbs.common.model.DynaEntryObject;
import kd.epm.epbs.common.model.ILoader;
import kd.epm.epbs.common.util.JSONUtils;
import org.apache.commons.collections4.CollectionUtils;

public class TemplateSheet
extends DynaEntryObject
implements ILoader<DynamicObjectCollection, List<TemplateSheet>, Object> {
    private Map<String, Object> paramsMap;

    public TemplateSheet(TemplateInfo template) {
        this.setDataEntityNumber(String.join((CharSequence)".", template.getDataEntityNumber(), "sheetentry"));
    }

    public TemplateSheet(String templateEntityNumber) {
        this.setDataEntityNumber(String.join((CharSequence)".", templateEntityNumber, "sheetentry"));
    }

    public String getSheetName() {
        return (String)this.get("sheetname");
    }

    public void setSheetName(String sheetname) {
        this.put("sheetname", sheetname);
    }

    public String getData() {
        return (String)this.get("sheetdata");
    }

    public void setData(String data) {
        this.put("sheetdata", data);
    }

    public String getSpreadJson() {
        return (String)this.get("sheetspreadjson");
    }

    public void setSpreadJson(String spreadjson) {
        this.put("sheetspreadjson", spreadjson);
    }

    public TemplateTypeEnum getSheetType() {
        String sheettype = (String)this.get("sheettype");
        if (StringUtils.isEmpty((String)sheettype)) {
            return TemplateTypeEnum.FIX;
        }
        return TemplateTypeEnum.valueOf((int)Integer.parseInt((String)this.get("sheettype")));
    }

    public void setSheetType(TemplateTypeEnum typeEnum) {
        this.put("sheettype", String.valueOf(typeEnum.getValue()));
    }

    public String getSheetParams() {
        return (String)this.get("sheetparams");
    }

    public void setSheetParams(String params) {
        this.put("sheetparams", params);
    }

    public Map<String, Object> getParamsMap() {
        return this.paramsMap;
    }

    protected Map<String, Object> getSheetParamsMap() {
        if (null != this.paramsMap) {
            return this.paramsMap;
        }
        String seria = this.getSheetParams();
        this.paramsMap = StringUtils.isNotEmpty((String)seria) ? (Map)JSONUtils.parse((String)seria, (TypeReference)new TypeReference<Map<String, Object>>(){}) : Maps.newHashMap();
        return this.paramsMap;
    }

    public void setSheetParamsMap(Map<String, Object> paramsMap) {
        if (null == paramsMap) {
            return;
        }
        this.paramsMap = paramsMap;
    }

    public void putParam(String key, Object value) {
        if (StringUtils.isEmpty((String)key) || null == value) {
            return;
        }
        this.getSheetParamsMap().put(key, value);
    }

    public Object getParam(String key) {
        return this.getSheetParamsMap().get(key);
    }

    public List<TemplateSheet> loadDynaObject(DynamicObjectCollection t, Supplier<Object> s) {
        ArrayList<TemplateSheet> entries = new ArrayList<TemplateSheet>();
        Object object = s.get();
        if (CollectionUtils.isNotEmpty((Collection)t)) {
            Predicate pexist = this.getPexist((DynamicObject)t.get(0));
            for (DynamicObject o : t) {
                TemplateSheet entry = object instanceof TemplateInfo ? new TemplateSheet((TemplateInfo)((Object)object)) : new TemplateSheet((String)object);
                entry.setId(o.getLong("id"));
                entry.setSeq((Integer)this.defaultIfNotExist(pexist, "seq", 0, () -> o.getInt("seq")));
                entry.setSheetName((String)this.defaultIfNotExist(pexist, "sheetname", "", () -> o.getString("sheetname")));
                entry.setData((String)this.defaultIfNotExist(pexist, "sheetdata", "", () -> o.getString("sheetdata")));
                entry.setSpreadJson((String)this.defaultIfNotExist(pexist, "sheetspreadjson", "", () -> o.getString("sheetspreadjson")));
                entry.setSheetType((TemplateTypeEnum)this.defaultIfNotExist(pexist, "sheettype", TemplateTypeEnum.FIX, () -> TemplateTypeEnum.valueOf((int)Integer.parseInt(o.getString("sheettype")))));
                entry.setSheetParams((String)this.defaultIfNotExist(pexist, "sheetparams", "", () -> o.getString("sheetparams")));
                entries.add(entry);
            }
        }
        return entries;
    }

    public DynamicObjectCollection genDynamicObjectCollection(DynamicObject parent, AtomicInteger incrementer) {
        DynamicObjectCollection coll = new DynamicObjectCollection(this.convert2SimpleDynamicObject().getDynamicObjectType(), (Object)parent);
        DynamicObject dyna = this.newSimpleDynamicObject();
        dyna.set("id", (Object)this.getId());
        dyna.set("seq", (Object)this.getSeq());
        dyna.set("sheetname", (Object)this.getSheetName());
        dyna.set("sheetdata", (Object)this.getData());
        dyna.set("sheetspreadjson", (Object)this.getSpreadJson());
        dyna.set("sheettype", (Object)String.valueOf(this.getSheetType().getValue()));
        dyna.set("sheetparams", (Object)(null != this.paramsMap ? JSONUtils.toString(this.paramsMap) : ""));
        coll.add((Object)dyna);
        return coll;
    }
}

