/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.business.template.areasetting;

import kd.epm.emr.business.template.arearangedim.IRowColDimensionEntry;
import kd.epm.emr.business.template.areasetting.IDataAreaSetting;
import kd.epm.emr.business.template.areasetting.IFloatInfo;
import kd.epm.emr.business.template.headerarea.IHeaderInfo;
import kd.epm.emr.business.template.headerarea.IHeaderObject;
import kd.epm.emr.business.template.pagedim.IPageDimensionEntry;

public class AreaInfo {
    private IDataAreaSetting areaSetting;
    private IHeaderInfo headerInfo;
    private IHeaderObject headerObject;
    private IFloatInfo floatInfo;
    private int relatedRow;
    private int relatedCol;

    public AreaInfo(IDataAreaSetting areaSetting, IHeaderInfo headerInfo, IHeaderObject headerObject, IFloatInfo floatInfo, int relatedRow, int relatedCol) {
        this.areaSetting = areaSetting;
        this.headerInfo = headerInfo;
        this.headerObject = headerObject;
        this.floatInfo = floatInfo;
        this.relatedRow = relatedRow;
        this.relatedCol = relatedCol;
    }

    public IDataAreaSetting getAreaSetting() {
        return this.areaSetting;
    }

    public IHeaderInfo getHeaderInfo() {
        return this.headerInfo;
    }

    public IHeaderObject getHeaderObject() {
        return this.headerObject;
    }

    public IFloatInfo getFloatInfo() {
        return this.floatInfo;
    }

    public int getRelatedRow() {
        return this.relatedRow;
    }

    public int getRelatedCol() {
        return this.relatedCol;
    }

    public String getDimNumber() {
        if (this.getHeaderInfo() != null && this.getFloatInfo() != null) {
            return this.getHeaderInfo().getNumber();
        }
        if (this.getHeaderInfo() != null && this.getHeaderInfo().getRefDimension() != null) {
            return this.getHeaderInfo().getRefDimension();
        }
        return null;
    }

    public IPageDimensionEntry getMemberScope() {
        IPageDimensionEntry pe = null;
        if (this.getHeaderInfo() != null && this.getFloatInfo() != null) {
            String dimNum = this.getHeaderInfo().getNumber();
            for (IRowColDimensionEntry entry : this.getFloatInfo().getPartition().getRowColDimensionEntries()) {
                if (!dimNum.equals(entry.getDimension().getNumber()) || !entry.isFloat()) continue;
                pe = entry;
                break;
            }
        } else if (this.getAreaSetting().getRelationAreaInfo() != null && this.getHeaderInfo() != null && this.getHeaderInfo().getRefDimension() != null) {
            String fieldNum = this.getHeaderInfo().getNumber();
            pe = this.getAreaSetting().getRelationAreaInfo().getMemberScopes().get(fieldNum);
        }
        return pe;
    }
}

