/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.business.template.areasetting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kd.epm.emr.business.template.QuickFloatBean;
import kd.epm.emr.business.template.SequenceInfo;
import kd.epm.emr.business.template.arearangedim.IRowColDimensionEntry;
import kd.epm.emr.business.template.areasetting.IDataAreaSetting;
import kd.epm.emr.business.template.areasetting.IFloatInfo;
import kd.epm.emr.business.template.dimension.SortDiminfo;
import kd.epm.emr.business.template.headerarea.HeaderObject;
import kd.epm.emr.business.template.headerarea.IHeaderInfo;
import kd.epm.emr.business.template.headerarea.IHeaderObject;
import kd.epm.emr.business.template.partition.IRowColPartition;
import kd.epm.emr.business.template.relation.RelationAreaInfo;
import kd.epm.emr.business.template.viewpointdim.IViewPointDimensionEntry;
import kd.epm.emr.common.spread.command.rangedefined.CellArea;
import kd.epm.emr.common.spread.domain.view.builder.dynamic.event.AdjustRangeEvent;
import kd.epm.emr.common.template.Tuple;
import kd.epm.emr.common.template.enums.FloatExpandTypeEnum;
import kd.epm.emr.common.template.enums.FloatMemberDisplayEnum;
import kd.epm.emr.common.template.enums.FloatTypeEnum;
import kd.epm.emr.common.template.enums.SortTypeEnum;
import kd.epm.epbs.common.util.ExcelUtils;
import kd.epm.epbs.common.util.RangeModel;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class DataAreaSetting
implements IDataAreaSetting {
    private static final long serialVersionUID = -3290820211595208979L;
    private String areaRange;
    private String originalAreaRange;
    private List<String> rowdims = new ArrayList<String>();
    private List<IHeaderInfo> rowHeaders = new ArrayList<IHeaderInfo>();
    private List<String> coldims = new ArrayList<String>();
    private List<IHeaderInfo> colHeaders = new ArrayList<IHeaderInfo>();
    private FloatTypeEnum floatOnWhere = FloatTypeEnum.NONE;
    private List<IFloatInfo> floatInfos = new ArrayList<IFloatInfo>();
    private final List<IViewPointDimensionEntry> areaViewpointmembentry = new ArrayList<IViewPointDimensionEntry>();
    private List<IRowColPartition> rowPartition = new ArrayList<IRowColPartition>();
    private List<IRowColPartition> colPartition = new ArrayList<IRowColPartition>();
    private List<SequenceInfo> sequenceInfos = new ArrayList<SequenceInfo>();
    private Map<List<String>, Object> delFloatValue = new HashMap<List<String>, Object>(16);
    private RelationAreaInfo relationAreaInfo;

    @Override
    public String getOriginalAreaRange() {
        return this.originalAreaRange;
    }

    @Override
    public void setOriginalAreaRange(String originalAreaRange) {
        this.originalAreaRange = originalAreaRange;
    }

    @Override
    public String getAreaRange() {
        return this.areaRange;
    }

    @Override
    public String getAreaRangeWithFloat() {
        String areaRangeWithFloat = this.areaRange;
        if (this.getFloatInfos() != null && !this.getFloatInfos().isEmpty()) {
            RangeModel rangeModel = new RangeModel(this.areaRange);
            boolean rowFloat = false;
            boolean colFloat = false;
            int rowFloatOffset = 0;
            int colFloatOffset = 0;
            for (IFloatInfo floatInfo : this.getFloatInfos()) {
                if (!rowFloat && floatInfo.getRow_offset() > -1) {
                    rowFloat = true;
                    rowFloatOffset = floatInfo.getFloat_offset();
                    continue;
                }
                if (colFloat || floatInfo.getCol_offset() <= -1) continue;
                colFloat = true;
                colFloatOffset = floatInfo.getFloat_offset();
            }
            if (rowFloat) {
                rangeModel.setX_start(rangeModel.getX_start() - rowFloatOffset - this.getRowHeaders().size());
            }
            if (colFloat) {
                rangeModel.setY_start(rangeModel.getY_start() - colFloatOffset - this.getColHeaders().size());
            }
            return rangeModel.toString();
        }
        return areaRangeWithFloat;
    }

    @Override
    public String getAreaRangeStart() {
        if (this.areaRange != null) {
            return this.areaRange.split(":")[0];
        }
        return this.areaRange;
    }

    @Override
    public void setAreaRange(String areaRange) {
        this.areaRange = areaRange;
    }

    @Override
    public FloatTypeEnum getFloatOnWhere() {
        if (this.isRelation()) {
            return FloatTypeEnum.ROW;
        }
        return this.floatOnWhere;
    }

    @Override
    public void setFloatOnWhere(FloatTypeEnum floatOnWhere) {
        this.floatOnWhere = floatOnWhere;
    }

    @Override
    public List<IFloatInfo> getFloatInfos() {
        return this.floatInfos;
    }

    @Override
    public void setFloatInfos(List<IFloatInfo> floatInfos) {
        this.floatInfos = floatInfos;
    }

    @Override
    public List<String> getRowdims() {
        return this.rowdims;
    }

    @Override
    public void setRowdims(List<String> rowdims) {
        this.rowdims = rowdims;
    }

    @Override
    public List<String> getColdims() {
        return this.coldims;
    }

    @Override
    public List<IHeaderInfo> getRowHeaders() {
        return this.rowHeaders;
    }

    @Override
    public void setRowHeaders(List<IHeaderInfo> rowHeaders) {
        this.rowHeaders = rowHeaders;
    }

    @Override
    public List<IHeaderInfo> getColHeaders() {
        return this.colHeaders;
    }

    @Override
    public void setColHeaders(List<IHeaderInfo> colHeaders) {
        this.colHeaders = colHeaders;
    }

    @Override
    public void setColdims(List<String> coldims) {
        this.coldims = coldims;
    }

    @Override
    public List<IViewPointDimensionEntry> getAreaViewpointmembentry() {
        return this.areaViewpointmembentry;
    }

    @Override
    public void addAreaViewpointmembentry(IViewPointDimensionEntry viewpointmembentry) {
        this.areaViewpointmembentry.add(viewpointmembentry);
    }

    @Override
    public void addAreaViewpointmembentry(List<IViewPointDimensionEntry> viewpointmembentrys) {
        this.areaViewpointmembentry.addAll(viewpointmembentrys);
    }

    @Override
    public List<IRowColPartition> getRowPartition() {
        return this.rowPartition;
    }

    @Override
    public void setRowPartition(List<IRowColPartition> rowPartition) {
        this.rowPartition = rowPartition;
    }

    @Override
    public List<IRowColPartition> getColPartition() {
        return this.colPartition;
    }

    @Override
    public void setColPartition(List<IRowColPartition> colPartition) {
        this.colPartition = colPartition;
    }

    @Override
    public List<SequenceInfo> getSequenceInfos() {
        return this.sequenceInfos;
    }

    @Override
    public void setSequenceInfos(List<SequenceInfo> sequenceInfos) {
        this.sequenceInfos = sequenceInfos;
    }

    @Override
    public void refresh() {
        IHeaderObject headerObject;
        int i;
        if (this.isRelation()) {
            this.completeHeaderObjects(() -> new HeaderObject());
            return;
        }
        ArrayList<Integer> floatRows = new ArrayList<Integer>();
        ArrayList<Integer> floatCols = new ArrayList<Integer>();
        if (this.floatInfos == null || this.floatInfos.isEmpty()) {
            this.setFloatOnWhere(FloatTypeEnum.NONE);
        } else {
            CellArea dataArea = new CellArea(this.getAreaRange());
            int dataColCount = dataArea.getCc();
            int dataRowCount = dataArea.getRc();
            boolean hasRow = false;
            boolean hasCol = false;
            for (IFloatInfo floatInfo : this.floatInfos) {
                if (floatInfo.getRow_offset() > -1) {
                    hasRow = true;
                    for (int r = floatInfo.getRow_offset(); r <= floatInfo.getRowEnd_offset(); ++r) {
                        floatRows.add(r);
                    }
                } else if (floatInfo.getCol_offset() > -1) {
                    hasCol = true;
                    for (int c = floatInfo.getCol_offset(); c <= floatInfo.getColEnd_offset(); ++c) {
                        floatCols.add(c);
                    }
                }
                if (CollectionUtils.isNotEmpty(floatInfo.getSortDimInfos())) {
                    boolean isRow = FloatTypeEnum.ROW == floatInfo.getFloatType();
                    List<IHeaderInfo> headerInfos = isRow ? this.getRowHeaders() : this.getColHeaders();
                    HashSet dimNumbers = new HashSet(16);
                    HashSet propNumbers = new HashSet(16);
                    headerInfos.forEach(e -> {
                        if ("Dimension".equals(e.getType())) {
                            dimNumbers.add(e.getNumber());
                        } else if ("Property".equals(e.getType())) {
                            propNumbers.add(e.getNumber());
                        }
                    });
                    floatInfo.getSortDimInfos().removeIf(e -> SortTypeEnum.DIMENSION == e.getSortType() && !dimNumbers.contains(e.getOrderBy()) || SortTypeEnum.PROPERTY == e.getSortType() && !propNumbers.contains(e.getOrderBy()) || SortTypeEnum.DATA == e.getSortType() && (isRow && Integer.parseInt(e.getOrderBy()) >= dataColCount || !isRow && Integer.parseInt(e.getOrderBy()) >= dataRowCount));
                }
                FloatTypeEnum floatType = hasRow && hasCol ? FloatTypeEnum.ROWCOL : (hasRow ? FloatTypeEnum.ROW : (hasCol ? FloatTypeEnum.COL : FloatTypeEnum.NONE));
                this.setFloatOnWhere(floatType);
            }
        }
        if (this.rowHeaders != null) {
            for (IHeaderInfo headerInfo : this.rowHeaders) {
                List<IHeaderObject> headerObjects = headerInfo.getHeaderObjects();
                if (headerObjects == null) continue;
                for (i = 0; i < headerObjects.size(); ++i) {
                    headerObject = headerObjects.get(i);
                    if (headerObject == null) {
                        headerObject = new HeaderObject();
                        headerObjects.set(i, headerObject);
                    }
                    if (floatRows.contains(i)) {
                        headerObject.setFloat(true);
                        headerObject.setNumber(null);
                        continue;
                    }
                    if (!headerObject.isFloat()) continue;
                    headerObject.setFloat(false);
                    headerObject.setNumber(null);
                    headerObject.setName(null);
                }
            }
        }
        if (this.colHeaders != null) {
            for (IHeaderInfo headerInfo : this.colHeaders) {
                List<IHeaderObject> headerObjects = headerInfo.getHeaderObjects();
                if (headerObjects == null) continue;
                for (i = 0; i < headerObjects.size(); ++i) {
                    headerObject = headerObjects.get(i);
                    if (headerObject == null) {
                        headerObject = new HeaderObject();
                        headerObjects.set(i, headerObject);
                    }
                    if (floatCols.contains(i)) {
                        headerObject.setFloat(true);
                        headerObject.setNumber(null);
                        continue;
                    }
                    if (!headerObject.isFloat()) continue;
                    headerObject.setFloat(false);
                    headerObject.setNumber(null);
                    headerObject.setName(null);
                }
            }
        }
    }

    @Override
    public void completeHeaderObjects(Supplier<IHeaderObject> supplier) {
        CellArea cellArea = new CellArea(this.areaRange);
        if (this.isRelation()) {
            this.fillHeaderObjects(this.getColHeaders(), supplier, cellArea.getRc());
        } else {
            this.fillHeaderObjects(this.getRowHeaders(), supplier, cellArea.getRc());
            this.fillHeaderObjects(this.getColHeaders(), supplier, cellArea.getCc());
        }
    }

    private void fillHeaderObjects(List<IHeaderInfo> headerInfos, Supplier<IHeaderObject> supplier, int fillSize) {
        for (IHeaderInfo hi : headerInfos) {
            List<IHeaderObject> hos = hi.getHeaderObjects();
            for (int i = 0; i < fillSize; ++i) {
                if (hos.get(i) != null) continue;
                hos.set(i, supplier == null ? null : supplier.get());
            }
        }
    }

    public void adjustRange(AdjustRangeEvent event, boolean isFromReport) {
        String[] splitArr = this.areaRange.split(":");
        int startcol = ExcelUtils.pos2X((String)splitArr[0]);
        int startrow = ExcelUtils.pos2Y((String)splitArr[0]);
        int endcol = ExcelUtils.pos2X((String)splitArr[1]);
        int endrow = ExcelUtils.pos2Y((String)splitArr[1]);
        if (startrow > endrow || startcol > endcol) {
            return;
        }
        this.adjustHeaderObjects(event);
        this.adjustRelationAreaInfo(event);
        String startPos = this.doAdjustRange(event, splitArr[0], false, splitArr[1]);
        if (this.dealSpecialRange(startPos)) {
            return;
        }
        String endPos = this.doAdjustRange(event, splitArr[1], true, splitArr[1]);
        if (this.dealSpecialRange(endPos)) {
            return;
        }
        RangeModel oldRange = new RangeModel(this.areaRange);
        this.areaRange = startPos + ":" + endPos;
        this.adjustFloatSetting(event, oldRange, isFromReport);
        this.adjustSequenceInfos(event);
    }

    public void adjustRelationAreaInfo(AdjustRangeEvent event) {
        if (this.relationAreaInfo != null) {
            RangeModel dataRangeModel = new RangeModel(this.areaRange);
            if (event.isOperateRow() && dataRangeModel.isRowInArea(event.getAxis())) {
                this.adjustHeaders(event, false, event.getAxis() - dataRangeModel.getY_start());
            } else if (!event.isOperateRow() && event.getOffSet() < 0 && dataRangeModel.isColInArea(event.getAxis())) {
                List<String> cols = this.relationAreaInfo.getCols();
                int index = this.absRowColToIndex(event.getAxis(), false);
                if (index >= 0 && index < cols.size()) {
                    String field = cols.get(index);
                    this.relationAreaInfo.getMemberScopes().remove(field);
                    cols.remove(index);
                    this.colHeaders.remove(index);
                }
            }
        }
    }

    public void adjustSequenceInfos(AdjustRangeEvent event) {
        if (CollectionUtils.isNotEmpty(this.sequenceInfos)) {
            ArrayList delInfos = new ArrayList(16);
            this.sequenceInfos.forEach(s -> {
                s.adjustRange(event);
                s.setDataArea(this.areaRange);
                RangeModel rangeModel = new RangeModel(s.getSeqArea());
                if (rangeModel.getX_start() > rangeModel.getX_end() || rangeModel.getY_start() > rangeModel.getY_end() || rangeModel.checkIsInArea(new RangeModel(this.areaRange))) {
                    delInfos.add(s);
                }
            });
            if (CollectionUtils.isNotEmpty(delInfos)) {
                this.sequenceInfos.removeAll(delInfos);
            }
        }
    }

    public void adjustFloatSetting(AdjustRangeEvent event, RangeModel rangeModel, boolean isFromReport) {
        if (FloatTypeEnum.NONE == this.floatOnWhere) {
            return;
        }
        List<IFloatInfo> infos = this.getFloatInfos();
        if (CollectionUtils.isNotEmpty(infos)) {
            RangeModel newRangeModel = new RangeModel(this.areaRange);
            int rowSize = this.getRowHeaders().size();
            int colSize = this.getColHeaders().size();
            ArrayList delInfos = new ArrayList(16);
            infos.forEach(s -> {
                boolean isRow = FloatTypeEnum.ROW == s.getFloatType();
                RangeModel floatRange = this.getFloatRange((IFloatInfo)s, rangeModel);
                String startPos = this.doAdjustRange(event, floatRange.getStartPoint().toString(), false, floatRange.getEndPoint().toString());
                if (this.dealSpecialRange(startPos)) {
                    delInfos.add(s);
                    return;
                }
                String endPos = this.doAdjustRange(event, floatRange.getEndPoint().toString(), true, floatRange.getEndPoint().toString());
                if (this.dealSpecialRange(endPos)) {
                    delInfos.add(s);
                    return;
                }
                RangeModel newFloatRange = new RangeModel(startPos + ":" + endPos);
                if (newFloatRange.getY_start() > newFloatRange.getY_end() || newFloatRange.getX_start() > newFloatRange.getX_end()) {
                    delInfos.add(s);
                } else {
                    if (isRow && !floatRange.getColSize().equals(newFloatRange.getColSize()) || !isRow && !floatRange.getRowSize().equals(newFloatRange.getRowSize())) {
                        delInfos.add(s);
                        return;
                    }
                    this.updateFloatRange((IFloatInfo)s, newFloatRange, newRangeModel, s.getFloatType() == FloatTypeEnum.ROW ? rowSize : colSize);
                }
            });
            if (CollectionUtils.isNotEmpty(delInfos)) {
                infos.removeAll(delInfos);
            }
            if (!isFromReport) {
                this.refresh();
            }
        }
    }

    public void adjustHeaderObjects(AdjustRangeEvent event) {
        boolean isRow = event.isOperateRow();
        RangeModel rangeModel = new RangeModel(this.areaRange);
        if (isRow && rangeModel.isRowInArea(event.getAxis()) || !isRow && rangeModel.isColInArea(event.getAxis())) {
            int index = event.getAxis() - (isRow ? rangeModel.getY_start() : rangeModel.getX_start());
            this.adjustHeaders(event, isRow, index);
        }
    }

    private void adjustHeaders(AdjustRangeEvent event, boolean isRow, int index) {
        List<IHeaderInfo> headers;
        List<IHeaderInfo> list = headers = isRow ? this.getRowHeaders() : this.getColHeaders();
        if (CollectionUtils.isNotEmpty(headers)) {
            boolean isAdd = event.getOffSet() > 0;
            index = isAdd && event.isRev() ? index + 1 : index;
            for (int i = 0; i < Math.abs(event.getOffSet()); ++i) {
                for (IHeaderInfo h : headers) {
                    if (isAdd) {
                        h.getHeaderObjects().add(index, null);
                        continue;
                    }
                    h.getHeaderObjects().remove(index);
                }
            }
        }
    }

    @Override
    public boolean isFloat(int index, boolean isRowIndex) {
        if (FloatTypeEnum.NONE == this.floatOnWhere) {
            return false;
        }
        if (isRowIndex && FloatTypeEnum.COL == this.floatOnWhere || !isRowIndex && FloatTypeEnum.ROW == this.floatOnWhere) {
            return false;
        }
        return this.getFloatInfos().stream().anyMatch(f -> {
            if (FloatTypeEnum.ROW == this.floatOnWhere || isRowIndex) {
                return index >= f.getRow_offset() && index <= f.getRowEnd_offset();
            }
            return index >= f.getCol_offset() && index <= f.getColEnd_offset();
        });
    }

    @Override
    public IFloatInfo getFloatInfo(int index, boolean isRow) {
        for (IFloatInfo f : this.floatInfos) {
            if ((!isRow || index < f.getRow_offset() || index > f.getRowEnd_offset()) && (isRow || index < f.getCol_offset() || index > f.getColEnd_offset())) continue;
            return f;
        }
        return null;
    }

    private boolean dealSpecialRange(String pos) {
        if ("#".equals(pos)) {
            this.areaRange = "B1:A1";
            return true;
        }
        return false;
    }

    @Override
    public boolean isWithInFloatArea(String seqArea) {
        List<IFloatInfo> infoList = this.getFloatInfos();
        if (CollectionUtils.isNotEmpty(infoList)) {
            RangeModel rangeModel = new RangeModel(this.areaRange);
            return infoList.stream().anyMatch(f -> {
                RangeModel floatRange = this.getFloatRange((IFloatInfo)f, rangeModel);
                return floatRange != null && floatRange.checkIsInArea(new RangeModel(seqArea));
            });
        }
        return false;
    }

    @Override
    public RangeModel getFloatRange(IFloatInfo floatInfo, RangeModel rangeModel) {
        int er;
        int sc;
        int sr;
        boolean isRow = FloatTypeEnum.ROW == floatInfo.getFloatType();
        int rowColCount = isRow ? this.getRowHeaders().size() : this.getColHeaders().size();
        int ec = 0;
        if (isRow) {
            sr = rangeModel.getY_start() + floatInfo.getRow_offset();
            sc = rangeModel.getX_start() - rowColCount - floatInfo.getFloat_offset();
            er = rangeModel.getY_start() + floatInfo.getRowEnd_offset();
            ec = rangeModel.getX_start() - floatInfo.getFloat_offset() - 1;
        } else {
            sc = rangeModel.getX_start() + floatInfo.getCol_offset();
            sr = rangeModel.getY_start() - rowColCount - floatInfo.getFloat_offset();
            ec = rangeModel.getX_start() + floatInfo.getColEnd_offset();
            er = rangeModel.getY_start() - floatInfo.getFloat_offset() - 1;
        }
        return new RangeModel(sc, ec, sr, er);
    }

    @Override
    public Tuple<List<RangeModel>, List<RangeModel>> getFloatDimRanges(IFloatInfo floatInfo) {
        QuickFloatBean qfb = new QuickFloatBean(this, floatInfo);
        return this.getFloatDimRanges(floatInfo, qfb.getStart(), qfb.getEnd());
    }

    @Override
    public Tuple<List<RangeModel>, List<RangeModel>> getFloatDimRanges(IFloatInfo floatInfo, int start, int end) {
        QuickFloatBean qfb = new QuickFloatBean(this, floatInfo);
        ArrayList<RangeModel> rangeModels = new ArrayList<RangeModel>(16);
        ArrayList lockRanges = new ArrayList(16);
        List<IHeaderInfo> infos = qfb.getHeaderInfos();
        for (int i = 0; i < infos.size(); ++i) {
            IRowColDimensionEntry rcDimEntry;
            IHeaderInfo headerInfo = infos.get(i);
            boolean isFloatDim = false;
            if (headerInfo.isDimension() && (rcDimEntry = floatInfo.getFloatSettingByDimNum(headerInfo.getNumber())) != null) {
                isFloatDim = rcDimEntry.isFloat();
            }
            this.addRangModel(isFloatDim ? rangeModels : lockRanges, qfb, i, start, end);
        }
        return Tuple.newOne(rangeModels, lockRanges);
    }

    private void addRangModel(List<RangeModel> rangeModels, QuickFloatBean qfb, int i, int start, int end) {
        if (qfb.isRowFloat()) {
            rangeModels.add(new RangeModel(qfb.getOtherFStart() + i, qfb.getOtherFStart() + i, start, end));
        } else {
            rangeModels.add(new RangeModel(start, end, qfb.getOtherFStart() + i, qfb.getOtherFStart() + i));
        }
    }

    @Override
    public Tuple<List<RangeModel>, List<RangeModel>> getRelationFloatRanges() {
        RangeModel rm = new RangeModel(this.getAreaRange());
        return this.getRelationFloatRanges(rm.getY_start(), rm.getY_end());
    }

    @Override
    public Tuple<List<RangeModel>, List<RangeModel>> getRelationFloatRanges(int start, int end) {
        RangeModel rm = new RangeModel(this.getAreaRange());
        List<IHeaderInfo> headerInfos = this.getColHeaders();
        ArrayList<RangeModel> rangeModels = new ArrayList<RangeModel>(16);
        ArrayList lockRanges = new ArrayList(16);
        for (int i = 0; i < headerInfos.size(); ++i) {
            IHeaderInfo headerInfo = headerInfos.get(i);
            if (!"RelField".equals(headerInfo.getType()) || !StringUtils.isNotEmpty((CharSequence)headerInfo.getRefDimension())) continue;
            rangeModels.add(new RangeModel(rm.getX_start() + i, rm.getX_start() + i, start, end));
        }
        return Tuple.newOne(rangeModels, lockRanges);
    }

    @Override
    public void updateFloatRange(IFloatInfo floatInfo, RangeModel floatRange, RangeModel newRangeModel, int rowColCount) {
        if (FloatTypeEnum.ROW == floatInfo.getFloatType()) {
            floatInfo.setRow_offset(floatRange.getY_start() - newRangeModel.getY_start());
            floatInfo.setRowEnd_offset(floatRange.getY_end() - newRangeModel.getY_start());
            floatInfo.setFloat_offset(newRangeModel.getX_start() - floatRange.getX_start() - rowColCount);
        } else {
            floatInfo.setFloat_offset(newRangeModel.getY_start() - floatRange.getY_start() - rowColCount);
            floatInfo.setCol_offset(floatRange.getX_start() - newRangeModel.getX_start());
            floatInfo.setColEnd_offset(floatRange.getX_end() - newRangeModel.getX_start());
        }
    }

    @Override
    public boolean hasFloat(boolean isRow) {
        for (IFloatInfo floatInfo : this.floatInfos) {
            if (isRow && floatInfo.getRow_offset() > -1) {
                return true;
            }
            if (isRow || floatInfo.getCol_offset() <= -1) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, IHeaderObject> getCellMember(int row, int col) {
        HashMap<String, IHeaderObject> map = new HashMap<String, IHeaderObject>(16);
        RangeModel rangeModel = new RangeModel(this.areaRange);
        if (rangeModel.isColInArea(col) && rangeModel.isRowInArea(row)) {
            this.fillHeaderObject(this.getRowHeaders(), row - rangeModel.getY_start(), map);
            this.fillHeaderObject(this.getColHeaders(), col - rangeModel.getX_start(), map);
        }
        return map;
    }

    private void fillHeaderObject(List<IHeaderInfo> headerInfos, int yOffset, Map<String, IHeaderObject> map) {
        headerInfos.forEach(h -> {
            if (h.isDimension() && yOffset < h.getHeaderObjects().size()) {
                map.put(h.getNumber(), h.getHeaderObjects().get(yOffset));
            }
        });
    }

    @Override
    public Map<String, String> getCellMemberNumber(int row, int col, boolean includeAreaViewPoint) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        this.getCellMember(row, col).forEach((k, v) -> {
            if (v != null && v.getNumber() != null) {
                map.put((String)k, v.getNumber());
            }
        });
        if (includeAreaViewPoint && CollectionUtils.isNotEmpty(this.areaViewpointmembentry)) {
            this.areaViewpointmembentry.forEach(e -> map.put(e.getDimension().getNumber(), e.getMember().getNumber()));
        }
        return map;
    }

    @Override
    public void setDelFloatValues(Map<List<String>, Object> delFloatValue) {
        this.delFloatValue = delFloatValue;
    }

    @Override
    public void addDelFloatValue(List<String> dims, Object value) {
        this.delFloatValue.put(dims, value);
    }

    @Override
    public Map<List<String>, Object> getDelFloatValues() {
        return this.delFloatValue;
    }

    @Override
    public Map<String, List<IHeaderObject>> getFixMemberMap() {
        HashMap<String, List<IHeaderObject>> memMap = new HashMap<String, List<IHeaderObject>>(16);
        if (FloatTypeEnum.ROW == this.getFloatOnWhere()) {
            this.collectFixMemberMap(this.getColHeaders(), memMap);
        } else if (FloatTypeEnum.COL == this.getFloatOnWhere()) {
            this.collectFixMemberMap(this.getRowHeaders(), memMap);
        } else if (FloatTypeEnum.NONE == this.getFloatOnWhere()) {
            this.collectFixMemberMap(this.getRowHeaders(), memMap);
            this.collectFixMemberMap(this.getColHeaders(), memMap);
        }
        return memMap;
    }

    private void collectFixMemberMap(List<IHeaderInfo> headerInfos, Map<String, List<IHeaderObject>> memMap) {
        if (CollectionUtils.isNotEmpty(headerInfos)) {
            headerInfos.forEach(h -> {
                if (h.isDimension()) {
                    memMap.put(h.getNumber(), h.getHeaderObjects());
                }
            });
        }
    }

    private void collectCompleteFixMemberMap(List<IHeaderInfo> headerInfos, Map<String, List<IHeaderObject>> memMap, int end) {
        if (CollectionUtils.isNotEmpty(headerInfos)) {
            for (int i = 0; i < end; ++i) {
                HashMap<String, IHeaderObject> singleMap = new HashMap<String, IHeaderObject>(16);
                boolean isBreak = false;
                for (IHeaderInfo headerInfo : headerInfos) {
                    if (!headerInfo.isDimension() || isBreak) continue;
                    IHeaderObject headerObject = headerInfo.getHeaderObjects().get(i);
                    if (headerObject != null && StringUtils.isNotEmpty((CharSequence)headerObject.getNumber())) {
                        singleMap.put(headerInfo.getNumber(), headerObject);
                        continue;
                    }
                    isBreak = true;
                }
                if (isBreak || !MapUtils.isNotEmpty(singleMap)) continue;
                singleMap.forEach((k, v) -> memMap.computeIfAbsent((String)k, v1 -> new ArrayList()).add(v));
            }
        }
    }

    @Override
    public boolean isCompleteFixDim() {
        return MapUtils.isNotEmpty(this.getCompleteFixMemberMap());
    }

    @Override
    public Map<String, List<IHeaderObject>> getCompleteFixMemberMap() {
        ArrayList<String> allDims = new ArrayList<String>(16);
        RangeModel rangeModel = new RangeModel(this.getAreaRange());
        int xEnd = rangeModel.getColSize();
        int yEnd = rangeModel.getRowSize();
        HashMap<String, List<IHeaderObject>> memMap = new HashMap<String, List<IHeaderObject>>(16);
        if (FloatTypeEnum.ROW == this.getFloatOnWhere()) {
            this.collectCompleteFixMemberMap(this.getColHeaders(), memMap, xEnd);
        } else if (FloatTypeEnum.COL == this.getFloatOnWhere()) {
            this.collectCompleteFixMemberMap(this.getRowHeaders(), memMap, yEnd);
        } else if (FloatTypeEnum.NONE == this.getFloatOnWhere()) {
            allDims.addAll(this.getRowdims());
            allDims.addAll(this.getColdims());
            this.collectCompleteFixMemberMap(this.getRowHeaders(), memMap, yEnd);
            this.collectCompleteFixMemberMap(this.getColHeaders(), memMap, xEnd);
            if (allDims.size() != memMap.size()) {
                memMap.clear();
            }
        }
        return memMap;
    }

    @Override
    public List<String> getRowColDims() {
        ArrayList<String> rowColDims = new ArrayList<String>(16);
        rowColDims.addAll(this.getRowdims());
        rowColDims.addAll(this.getColdims());
        return rowColDims;
    }

    @Override
    public RelationAreaInfo getRelationAreaInfo() {
        return this.relationAreaInfo;
    }

    @Override
    public void setRelationAreaInfo(RelationAreaInfo relationAreaInfo) {
        this.relationAreaInfo = relationAreaInfo;
    }

    @Override
    public boolean isRelation() {
        return this.getRelationAreaInfo() != null;
    }

    @Override
    public int absRowColToIndex(int absRowOrCol, boolean isRow) {
        CellArea cellArea = new CellArea(this.areaRange);
        return isRow ? absRowOrCol - cellArea.getR() : absRowOrCol - cellArea.getC();
    }

    @Override
    public List<RangeModel> getFloatDataRangeModels() {
        ArrayList<RangeModel> rangeModels = new ArrayList<RangeModel>(16);
        if (CollectionUtils.isNotEmpty(this.getFloatInfos())) {
            this.getFloatInfos().forEach(f -> rangeModels.add(new QuickFloatBean(this, (IFloatInfo)f).getFloatDataRange()));
        }
        return rangeModels;
    }

    public static class FloatInfo
    implements IFloatInfo {
        private int row_offset = -1;
        private int col_offset = -1;
        private int rowEnd_offset = -1;
        private int colEnd_offset = -1;
        private int float_offset = 0;
        private IRowColPartition partition;
        private int rangeType = 0;
        private List<SortDiminfo> sortDimInfos;
        private String memberDisplay = FloatMemberDisplayEnum.NAME.getNumber();
        private String expandType = FloatExpandTypeEnum.ONLYWITHDATA.getNumber();
        private String originalRange;

        @Override
        public int getRow_offset() {
            return this.row_offset;
        }

        @Override
        public void setRow_offset(int row_offset) {
            this.row_offset = row_offset;
        }

        @Override
        public int getCol_offset() {
            return this.col_offset;
        }

        @Override
        public void setCol_offset(int col_offset) {
            this.col_offset = col_offset;
        }

        @Override
        public int getRowEnd_offset() {
            return this.rowEnd_offset;
        }

        @Override
        public void setRowEnd_offset(int rowEnd_offset) {
            this.rowEnd_offset = rowEnd_offset;
        }

        @Override
        public int getColEnd_offset() {
            return this.colEnd_offset;
        }

        @Override
        public void setColEnd_offset(int colEnd_offset) {
            this.colEnd_offset = colEnd_offset;
        }

        @Override
        public int getFloat_offset() {
            return this.float_offset;
        }

        @Override
        public void setFloat_offset(int float_offset) {
            this.float_offset = float_offset;
        }

        @Override
        public IRowColPartition getPartition() {
            return this.partition;
        }

        @Override
        public void setPartition(IRowColPartition partition) {
            this.partition = partition;
        }

        @Override
        public int getRangeType() {
            return this.rangeType;
        }

        @Override
        public void setRangeType(int rangeType) {
            this.rangeType = rangeType;
        }

        @Override
        public String getMemberDisplay() {
            return this.memberDisplay;
        }

        @Override
        public void setMemberDisplay(String memberDisplay) {
            this.memberDisplay = memberDisplay;
        }

        @Override
        public String getExpandType() {
            return this.expandType;
        }

        @Override
        public void setExpandType(String expandType) {
            this.expandType = expandType;
        }

        @Override
        public List<SortDiminfo> getSortDimInfos() {
            return this.sortDimInfos;
        }

        @Override
        public void setSortDimInfos(List<SortDiminfo> sortDimInfos) {
            this.sortDimInfos = sortDimInfos;
        }

        @Override
        public String getOriginalRange() {
            return this.originalRange;
        }

        @Override
        public void setOriginalRange(String originalRange) {
            this.originalRange = originalRange;
        }

        @Override
        public List<String> getDims(boolean isOnlyFloat) {
            ArrayList<String> dims = new ArrayList<String>(16);
            this.getPartition().getRowColDimensionEntries().forEach(f -> {
                if (!isOnlyFloat || f.isFloat()) {
                    dims.add(f.getDimension().getNumber());
                }
            });
            return dims;
        }

        @Override
        public IRowColDimensionEntry getFloatSettingByDimNum(String dimNum) {
            return this.groupFloatDimSetting().get(dimNum);
        }

        @Override
        public Map<String, IRowColDimensionEntry> groupFloatDimSetting() {
            HashMap<String, IRowColDimensionEntry> map = new HashMap<String, IRowColDimensionEntry>(16);
            this.getPartition().getRowColDimensionEntries().forEach(e -> map.put(e.getDimension().getNumber(), (IRowColDimensionEntry)e));
            return map;
        }
    }
}

