/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.business.template.helper;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.epm.emr.business.template.ReportContext;
import kd.epm.emr.business.template.areasetting.IDataAreaSetting;
import kd.epm.emr.business.template.headerarea.IHeaderInfo;
import kd.epm.emr.business.template.headerarea.IHeaderObject;
import kd.epm.emr.business.template.service.ITranNumberService;
import kd.epm.emr.business.template.viewpointdim.IViewPointDimensionEntry;
import kd.epm.emr.common.spread.domain.Domain;
import kd.epm.emr.common.spread.model.IDimMember;
import kd.epm.emr.common.template.Tuple;
import kd.epm.epbs.business.olap.OlapServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class ReportMDDataHelper {
    public static void addFixDimension(Domain domain, SaveCommandInfo info, ITranNumberService tranNumberService) {
        domain.getDimensions().forEach(d -> {
            String dimNum = d.getNumber();
            for (IDimMember m : d.getMembers()) {
                info.addfixedDimension(new String[]{dimNum, tranNumberService.getTranNumber(m)});
            }
        });
    }

    public static void addFixDimension(List<IViewPointDimensionEntry> avps, SaveCommandInfo info, ITranNumberService tranNumberService) {
        if (CollectionUtils.isNotEmpty(avps)) {
            for (IViewPointDimensionEntry avp : avps) {
                if (avp.getDimension() == null || avp.getMember() == null) continue;
                info.addfixedDimension(new String[]{avp.getDimension().getNumber(), tranNumberService.getTranNumber(avp.getDimension().getNumber(), avp.getMember())});
            }
        }
    }

    public static void filterNotExitMembs(IDataAreaSetting m, ReportContext context) {
        Map<List<String>, Object> dynaDelKvSets = m.getDelFloatValues();
        if (MapUtils.isNotEmpty(dynaDelKvSets)) {
            List<String> selectDimKey = m.getRowColDims();
            HashMap indexMap = new HashMap(16);
            m.getFloatInfos().forEach(f -> f.getPartition().getRowColDimensionEntries().forEach(s -> {
                if (s.isFloat()) {
                    indexMap.put(selectDimKey.indexOf(s.getDimension().getNumber()), s.getDimension().getNumber());
                }
            }));
            HashMap numberMap = new HashMap(16);
            dynaDelKvSets.forEach((k, v) -> {
                Iterator iterator = indexMap.keySet().iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    numberMap.computeIfAbsent(i, k1 -> new HashSet()).add(k.get(i));
                }
            });
            HashMap<Integer, Set<String>> unExit = new HashMap<Integer, Set<String>>(indexMap.size());
            for (Map.Entry tempEntry : indexMap.entrySet()) {
                int index = (Integer)tempEntry.getKey();
                unExit.put(index, ReportMDDataHelper.batCheckMemberIsExistOlap((String)tempEntry.getValue(), (Set)numberMap.get(index), context));
            }
            AtomicBoolean del = new AtomicBoolean(false);
            ArrayList dels = new ArrayList(16);
            dynaDelKvSets.forEach((k, v) -> {
                Iterator iterator = indexMap.keySet().iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    del.set(((Set)unExit.get(i)).contains(k.get(i)));
                    if (!del.get()) continue;
                    dels.add(k);
                    del.set(false);
                    return;
                }
            });
            dels.forEach(dynaDelKvSets::remove);
            m.setDelFloatValues(dynaDelKvSets);
        }
    }

    public static Set<String> batCheckMemberIsExistOlap(String dimNum, Set<String> memNums, ReportContext context) {
        if (CollectionUtils.isEmpty(memNums)) {
            return Sets.newHashSet();
        }
        return OlapServiceHelper.batCheckMemberIsExistOlap((String)dimNum, (String[])memNums.toArray(new String[0]), (String)context.getCubeNum(), (long)context.getModelId());
    }

    public static boolean filterIHeaderInfo(List<IHeaderInfo> headerInfos, Map<String, IHeaderInfo> rowColMap) {
        if (CollectionUtils.isNotEmpty(headerInfos)) {
            for (IHeaderInfo h : headerInfos) {
                if (!h.isDimension()) continue;
                if (h.getHeaderObjects().stream().anyMatch(o -> o != null && StringUtils.isNotEmpty((CharSequence)o.getNumber()))) {
                    rowColMap.put(h.getNumber(), h);
                    continue;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static List<Tuple<String, IHeaderObject>> genTuples(List<IHeaderInfo> headerInfos) {
        ArrayList<Tuple<String, IHeaderObject>> tuples = new ArrayList<Tuple<String, IHeaderObject>>(16);
        if (CollectionUtils.isNotEmpty(headerInfos)) {
            headerInfos.forEach(h -> {
                List<IHeaderObject> headerObjects;
                if (h.isDimension() && CollectionUtils.isNotEmpty(headerObjects = h.getHeaderObjects())) {
                    String dimNum = h.getNumber();
                    headerObjects.forEach(ho -> tuples.add(Tuple.newOne((Object)dimNum, (Object)ho)));
                }
            });
        }
        return tuples;
    }

    public static void fillHeaderObject(List<IHeaderInfo> headerInfos, int yOffset, Map<String, IHeaderObject> map) {
        headerInfos.forEach(h -> {
            if (h.isDimension() && yOffset < h.getHeaderObjects().size()) {
                map.put(h.getNumber(), h.getHeaderObjects().get(yOffset));
            }
        });
    }
}

