/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.business.template.serializer;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import kd.epm.emr.business.template.ITemplateModel;
import kd.epm.emr.business.template.MultiSheetTemplateModel;
import kd.epm.emr.business.template.serializer.ISerializerConstant;
import kd.epm.emr.business.template.serializer.TemplateModelDeserializer;

public class MultiSheetTemplateModelDeserializer
extends JsonDeserializer
implements ISerializerConstant {
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JacksonException {
        MultiSheetTemplateModel multiSheetTemplateModel = MultiSheetTemplateModel.getInstance();
        JsonNode rootNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        this.readTemplateModels(rootNode, multiSheetTemplateModel);
        this.readSheetNames(rootNode, multiSheetTemplateModel);
        return multiSheetTemplateModel;
    }

    private void readSheetNames(JsonNode rootNode, MultiSheetTemplateModel multiSheetTemplateModel) {
        if (rootNode == null || rootNode.get("sheetNames") == null) {
            return;
        }
        ArrayList<String> sheetNames = new ArrayList<String>(16);
        Iterator rowcolnodes = rootNode.get("sheetNames").elements();
        while (rowcolnodes != null && rowcolnodes.hasNext()) {
            sheetNames.add(((JsonNode)rowcolnodes.next()).textValue());
        }
        multiSheetTemplateModel.setSheetNames(sheetNames);
    }

    protected void readTemplateModels(JsonNode rootNode, MultiSheetTemplateModel multiSheetTemplateModel) {
        if (rootNode != null) {
            if (rootNode == null || rootNode.get("templateModels") == null) {
                return;
            }
            Map<String, ITemplateModel> templateModels = multiSheetTemplateModel.getTemplateModels();
            Iterator fields = rootNode.get("templateModels").fields();
            while (fields != null && fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                if (field == null) continue;
                String sheetName = (String)field.getKey();
                JsonNode jsonNode = (JsonNode)field.getValue();
                if (sheetName == null || jsonNode == null) continue;
                templateModels.put(sheetName, new TemplateModelDeserializer().readTemplateModel(jsonNode));
            }
        }
    }
}

