/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.business.template.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import kd.epm.emr.business.template.ITemplateModel;
import kd.epm.emr.business.template.MultiSheetTemplateModel;
import kd.epm.emr.business.template.serializer.ISerializerConstant;
import kd.epm.emr.business.template.serializer.TemplateModelSerializer;
import org.apache.commons.collections4.CollectionUtils;

public class MultiSheetTemplateModelSerializer
extends JsonSerializer
implements ISerializerConstant {
    private JsonGenerator jsonGenerator;
    private TemplateModelSerializer templateModelSerializer = new TemplateModelSerializer();

    public void serialize(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        this.jsonGenerator = jsonGenerator;
        this.templateModelSerializer.setJsonGenerator(jsonGenerator);
        this.templateModelSerializer.setSerializerProvider(serializerProvider);
        jsonGenerator.writeStartObject();
        MultiSheetTemplateModel templateModel = null;
        if (o instanceof MultiSheetTemplateModel) {
            templateModel = (MultiSheetTemplateModel)o;
            this.writeSheetNames(templateModel.getSheetNames());
            this.writeTemplateModels(templateModel.getTemplateModels());
        }
        jsonGenerator.writeEndObject();
    }

    private void writeSheetNames(List<String> names) throws IOException {
        if (CollectionUtils.isNotEmpty(names)) {
            this.jsonGenerator.writeArrayFieldStart("sheetNames");
            for (String name : names) {
                this.jsonGenerator.writeString(name);
            }
            this.jsonGenerator.writeEndArray();
        }
    }

    protected void writeTemplateModels(Map<String, ITemplateModel> templateModels) throws IOException {
        if (templateModels != null) {
            this.jsonGenerator.writeObjectFieldStart("templateModels");
            for (Map.Entry<String, ITemplateModel> entry : templateModels.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                this.jsonGenerator.writeObjectFieldStart(entry.getKey());
                this.templateModelSerializer.serialize(entry.getValue());
                this.jsonGenerator.writeEndObject();
            }
            this.jsonGenerator.writeEndObject();
        }
    }
}

