/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.business.template.serializer;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.epm.emr.business.template.serializer.ISerializerConstant;
import kd.epm.emr.common.spread.common.variant.Variant;
import kd.epm.emr.common.spread.model.CellData;
import kd.epm.emr.common.spread.model.UserObject;
import kd.epm.emr.common.spread.sheet.Cell;
import kd.epm.emr.common.spread.sheet.ISheet;
import kd.epm.emr.common.spread.sheet.Sheet;
import kd.epm.emr.common.spread.sheet.StyleCell;
import kd.epm.epbs.common.util.ObjectSerialUtil;

public class SheetDeSerializer
implements ISerializerConstant {
    protected DeserializationContext deserializationContext;

    public SheetDeSerializer(DeserializationContext deserializationContext) {
        this.deserializationContext = deserializationContext;
    }

    public ISheet readSheet(JsonNode sheetNode) {
        JsonNode colWidth;
        Sheet sheet = new Sheet(sheetNode.get("sheetname").asText(), sheetNode.get("rmrs").asInt(), sheetNode.get("rmcs").asInt());
        sheet.setValueAreaRowStart(sheetNode.get("vars").asInt());
        sheet.setValueAreaColStart(sheetNode.get("vacs").asInt());
        if (sheetNode.get("drs") != null) {
            sheet.setDimRowStart(sheetNode.get("drs").asInt());
        }
        if (sheetNode.get("dcs") != null) {
            sheet.setDimColStart(sheetNode.get("dcs").asInt());
        }
        sheet.setIsdatachanged(sheetNode.get("idc") == null ? false : sheetNode.get("idc").asBoolean());
        sheet.setStyleCell(sheetNode.get("isc") == null ? false : sheetNode.get("isc").asBoolean());
        if (sheetNode.get("defaults") != null && (colWidth = sheetNode.get("defaults").get("colWidth")) instanceof TextNode) {
            HashMap<String, String> sheetDefaults = new HashMap<String, String>(1);
            sheetDefaults.put("colWidth", ((TextNode)colWidth).textValue());
            sheet.setSheetDefaults(sheetDefaults);
        }
        this.readTable((ISheet)sheet, sheetNode);
        return sheet;
    }

    protected void readTable(ISheet sheet, JsonNode sheetNode) {
        Iterator row_Nodes = sheetNode.get("tb").elements();
        int row = 0;
        while (row_Nodes != null && row_Nodes.hasNext()) {
            JsonNode rowNode = (JsonNode)row_Nodes.next();
            Iterator cellNodes = rowNode.elements();
            int col = 0;
            while (cellNodes != null && cellNodes.hasNext()) {
                this.readCell((JsonNode)cellNodes.next(), sheet, row, col);
                ++col;
            }
            ++row;
        }
    }

    protected void readCell(JsonNode cellNode, ISheet sheet, int row, int col) {
        if (cellNode != null && cellNode.elements().hasNext()) {
            JsonNode floatcell = cellNode.get("ifc");
            JsonNode dataChanged = cellNode.get("c");
            Cell cell = sheet.getCell(row, col);
            if (floatcell != null) {
                cell.setFloatCell(true);
            }
            if (dataChanged != null) {
                cell.setChangeVal(true);
            }
            if (cell instanceof StyleCell) {
                if (cellNode.get("ti") != null) {
                    ((StyleCell)cell).setTextIndent(cellNode.get("ti").asInt());
                }
                if (cellNode.get("fm") != null) {
                    ((StyleCell)cell).setFormatter(cellNode.get("fm").asText());
                }
                if (cellNode.get("ft") != null) {
                    ((StyleCell)cell).setFont(cellNode.get("ft").asText());
                }
            }
            this.readCellValue(cell, cellNode);
            this.readUserObject(cell, cellNode);
            this.readCellFormula(cell, cellNode);
        }
    }

    protected void readCellFormula(Cell cell, JsonNode cellNode) {
        JsonNode formulaNode = cellNode.get("f");
        if (formulaNode != null) {
            cell.setFormula(formulaNode.asText());
        }
    }

    protected void readUserObject(Cell cell, JsonNode cellNode) {
        JsonNode userobjnode = cellNode.get("ub");
        if (userobjnode != null) {
            if (cell.isFloatCell() && userobjnode instanceof TextNode) {
                cell.setUserObject((UserObject)ObjectSerialUtil.deSerializedBytes((String)userobjnode.asText()));
            } else {
                Iterator objIt = userobjnode.fields();
                while (objIt.hasNext()) {
                    Map.Entry entry = (Map.Entry)objIt.next();
                    JsonNode value = (JsonNode)entry.getValue();
                    if (value.isInt()) {
                        cell.setUserObject((String)entry.getKey(), (Object)value.asInt());
                        continue;
                    }
                    if (value.isLong()) {
                        cell.setUserObject((String)entry.getKey(), (Object)value.asLong());
                        continue;
                    }
                    if (value.isBoolean()) {
                        cell.setUserObject((String)entry.getKey(), (Object)value.asBoolean());
                        continue;
                    }
                    if (value.isBigDecimal()) {
                        cell.setUserObject((String)entry.getKey(), (Object)value.decimalValue());
                        continue;
                    }
                    if ("null".equalsIgnoreCase(value.asText())) continue;
                    cell.setUserObject((String)entry.getKey(), (Object)value.asText());
                }
            }
        }
    }

    protected void readCellValue(Cell cell, JsonNode cellNode) {
        JsonNode valueNode = cellNode.get("v");
        if (valueNode != null) {
            CellData cellData = null;
            if (valueNode.isArray()) {
                ArrayNode val = (ArrayNode)valueNode;
                Iterator vals = val.elements();
                if (vals.hasNext()) {
                    Variant v;
                    cellData = new CellData();
                    int vt = ((JsonNode)vals.next()).intValue();
                    JsonNode valNode = (JsonNode)vals.next();
                    switch (vt) {
                        case 12: {
                            v = new Variant((Object)new Date(valNode.longValue()), vt);
                            break;
                        }
                        case 10: {
                            v = new Variant((Object)new BigDecimal(valNode.textValue()), vt);
                            break;
                        }
                        case 9: {
                            v = new Variant((Object)valNode.longValue(), vt);
                            break;
                        }
                        case 8: {
                            v = new Variant((Object)valNode.booleanValue(), vt);
                            break;
                        }
                        case 13: {
                            v = new Variant((Object)this.deserializationContext.constructCalendar(new Date(valNode.longValue())), vt);
                            break;
                        }
                        case 7: {
                            v = new Variant((Object)valNode.textValue(), vt);
                            break;
                        }
                        case 3: {
                            v = new Variant((Object)valNode.intValue(), vt);
                            break;
                        }
                        default: {
                            v = new Variant((Object)valNode.textValue(), vt);
                        }
                    }
                    cellData.setData(v);
                }
            } else {
                cellData = new CellData();
                cellData.setData(new Variant((Object)valueNode.decimalValue(), 10));
            }
            cell.setCellData(cellData);
        }
    }
}

