/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.business.template.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.epm.emr.business.template.ISheetManager;
import kd.epm.emr.business.template.SequenceInfo;
import kd.epm.emr.business.template.SheetManager;
import kd.epm.emr.business.template.arearangedim.DefaultRowColDimensionEntry;
import kd.epm.emr.business.template.arearangedim.IRowColDimensionEntry;
import kd.epm.emr.business.template.areasetting.DataAreaSetting;
import kd.epm.emr.business.template.areasetting.IDataAreaSetting;
import kd.epm.emr.business.template.dimension.DefaultDimension;
import kd.epm.emr.business.template.dimension.SortDiminfo;
import kd.epm.emr.business.template.headerarea.HeaderInfo;
import kd.epm.emr.business.template.headerarea.HeaderObject;
import kd.epm.emr.business.template.headerarea.IHeaderInfo;
import kd.epm.emr.business.template.headerarea.IHeaderObject;
import kd.epm.emr.business.template.pagedim.DefaultPageDimensionEntry;
import kd.epm.emr.business.template.pagedim.IPageDimensionEntry;
import kd.epm.emr.business.template.partition.RowColPartition;
import kd.epm.emr.business.template.quote.QuoteTypeEnum;
import kd.epm.emr.business.template.relation.RelationAreaInfo;
import kd.epm.emr.business.template.serializer.ISerializerConstant;
import kd.epm.emr.business.template.serializer.SheetDeSerializer;
import kd.epm.emr.business.template.viewpointdim.DefaultViewPointDimensionEntry;
import kd.epm.emr.common.spread.domain.view.FilterView;
import kd.epm.emr.common.spread.sheet.ISheet;
import kd.epm.emr.common.template.EmrDefaultDimMember;
import kd.epm.emr.common.template.enums.FloatTypeEnum;
import kd.epm.emr.common.template.enums.SeqTypeEnum;
import kd.epm.emr.common.template.enums.SortTypeEnum;
import kd.epm.epbs.common.model.IDimensionMember;
import kd.epm.epbs.common.model.PropertyValueEntry;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import kd.epm.epbs.common.util.SPArrayList;
import org.apache.commons.lang3.StringUtils;

public class SheetManagerDeserializer
extends JsonDeserializer
implements ISerializerConstant {
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        SheetManager sheetManager = new SheetManager();
        JsonNode rootNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        this.readSheet(sheetManager, rootNode, new SheetDeSerializer(deserializationContext));
        this.readAreaRanges(rootNode, sheetManager);
        this.readFilterView(rootNode, sheetManager);
        return sheetManager;
    }

    protected void readFilterView(JsonNode rootNode, ISheetManager sheetAreaManager) {
        JsonNode node = rootNode.get("fv");
        if (node == null || StringUtils.isEmpty((CharSequence)node.asText())) {
            return;
        }
        sheetAreaManager.setFilterView((FilterView)ObjectSerialUtil.deSerializedBytes((String)node.asText()));
    }

    protected void readAreaRanges(JsonNode rootNode, ISheetManager sheetAreaManager) {
        JsonNode area_root = rootNode.get("areaRanges");
        if (area_root == null) {
            return;
        }
        Iterator areanodes = area_root.elements();
        HashMap<String, SequenceInfo> seqMap = new HashMap<String, SequenceInfo>(16);
        while (areanodes != null && areanodes.hasNext()) {
            JsonNode areanode = (JsonNode)areanodes.next();
            DataAreaSetting multiAreaSetting = new DataAreaSetting();
            multiAreaSetting.setAreaRange(areanode.get("ar").asText());
            if (areanode.get("oriar") != null) {
                multiAreaSetting.setOriginalAreaRange(areanode.get("oriar").asText());
            }
            this.readAreaViewEntry(areanode, multiAreaSetting);
            Iterator rowdimnodes = areanode.get("rdims").elements();
            while (rowdimnodes != null && rowdimnodes.hasNext()) {
                multiAreaSetting.getRowdims().add(((JsonNode)rowdimnodes.next()).textValue());
            }
            Iterator coldimnodes = areanode.get("cdims").elements();
            while (coldimnodes != null && coldimnodes.hasNext()) {
                multiAreaSetting.getColdims().add(((JsonNode)coldimnodes.next()).textValue());
            }
            multiAreaSetting.setFloatOnWhere(FloatTypeEnum.getEnumByVal((int)areanode.get("fow").asInt()));
            this.readFloatInfos(multiAreaSetting, areanode);
            this.readHeaderInfos(areanode, multiAreaSetting, "rhds");
            this.readHeaderInfos(areanode, multiAreaSetting, "chds");
            this.readSequenceInfos(multiAreaSetting, areanode, seqMap);
            this.readRelationAreaInfo(multiAreaSetting, areanode);
            this.readAutoFloatValue(multiAreaSetting, areanode);
            sheetAreaManager.getAreaRanges().add(multiAreaSetting);
        }
    }

    private void readAutoFloatValue(IDataAreaSetting multiAreaSetting, JsonNode node) {
        if (node.get("afv") != null) {
            multiAreaSetting.setDelFloatValues((Map)ObjectSerialUtil.deSerializedBytes((String)node.get("afv").asText()));
        }
    }

    private void readRelationAreaInfo(IDataAreaSetting multiAreaSetting, JsonNode areanode) {
        JsonNode node = areanode.get("rai");
        if (multiAreaSetting != null && node != null && node.get("bmn") != null) {
            RelationAreaInfo ri = new RelationAreaInfo(node.get("bmn").asText());
            if (node.get("cols") != null) {
                Iterator coldimnodes = node.get("cols").elements();
                while (coldimnodes != null && coldimnodes.hasNext()) {
                    ri.getCols().add(((JsonNode)coldimnodes.next()).textValue());
                }
            }
            if (node.get("mbs") != null) {
                Iterator fields = node.get("mbs").fields();
                while (fields.hasNext()) {
                    Map.Entry field = (Map.Entry)fields.next();
                    ri.getMemberScopes().put((String)field.getKey(), this.readOnePageEntry((JsonNode)field.getValue()));
                }
            }
            if (node.get("afids") != null) {
                Iterator iterator = node.get("afids").elements();
                while (iterator != null && iterator.hasNext()) {
                    ri.addAutoFloatDataId(((JsonNode)iterator.next()).asLong());
                }
            }
            multiAreaSetting.setRelationAreaInfo(ri);
        }
    }

    private IPageDimensionEntry readOnePageEntry(JsonNode viewnode) {
        JsonNode memberNode;
        DefaultPageDimensionEntry pageentry = new DefaultPageDimensionEntry();
        DefaultDimension dimension = new DefaultDimension();
        dimension.setNumber(viewnode.get("dimnum").asText());
        pageentry.setDimension(dimension);
        if (viewnode.get("vn") != null) {
            pageentry.setViewNumber(viewnode.get("vn").asText());
        }
        if ((memberNode = viewnode.get("mem")) == null) {
            return pageentry;
        }
        Iterator membernodes = memberNode.elements();
        while (membernodes != null && membernodes.hasNext()) {
            JsonNode membernode = (JsonNode)membernodes.next();
            EmrDefaultDimMember dimMember = new EmrDefaultDimMember();
            dimMember.setNumber(membernode.get("dmnum").asText());
            if (membernode.get("pmnum") != null) {
                dimMember.setParentNum(membernode.get("pmnum").asText());
            }
            dimMember.setScope(membernode.get("scp").asInt());
            if (membernode.get("vn") != null) {
                dimMember.setViewNumber(membernode.get("vn").asText());
            }
            pageentry.addOneMember((IDimensionMember)dimMember);
        }
        return pageentry;
    }

    private void readSequenceInfos(IDataAreaSetting m, JsonNode areanode, Map<String, SequenceInfo> seqMap) {
        JsonNode seqNodes = areanode.get("seqi");
        if (seqNodes == null) {
            return;
        }
        Iterator iterator = seqNodes.elements();
        while (iterator != null && iterator.hasNext()) {
            m.getSequenceInfos().add(this.readSequenceInfo((JsonNode)iterator.next(), seqMap));
        }
    }

    private SequenceInfo readSequenceInfo(JsonNode node, Map<String, SequenceInfo> seqMap) {
        SeqTypeEnum seqTypeEnum = SeqTypeEnum.getSeqTypeEnum((String)node.get("st").asText());
        String seqArea = node.get("sa").asText();
        SequenceInfo info = seqMap.get(seqArea);
        if (info != null) {
            return info;
        }
        info = new SequenceInfo(node.get("sda").asText(), seqTypeEnum);
        info.setSeqArea(seqArea);
        info.setDirect(node.get("sd").asInt());
        info.setTypeEnum(seqTypeEnum);
        if (node.get("osa") != null) {
            info.setOriSeqArea(node.get("osa").asText());
        }
        if (SeqTypeEnum.FIX == seqTypeEnum) {
            info.setFixValue(node.get("sf").asText());
        } else {
            if (SeqTypeEnum.RECOUNT == seqTypeEnum) {
                info.setInitvalue(node.get("siv").asInt());
                info.setEndValue(node.get("sev").asInt());
            }
            if (node.get("sp") != null) {
                info.setPrefix(node.get("sp").asText());
            }
            if (node.get("ss") != null) {
                info.setSuffix(node.get("ss").asText());
            }
        }
        if (node.get("sfa") != null) {
            info.setFromArea(this.readSequenceInfo(node.get("sfa"), seqMap));
        }
        seqMap.put(seqArea, info);
        return info;
    }

    private void readFloatInfos(IDataAreaSetting multiAreaSetting, JsonNode areanode) {
        JsonNode float_root = areanode.get("fis");
        if (float_root == null) {
            return;
        }
        Iterator infos = float_root.elements();
        while (infos != null && infos.hasNext()) {
            JsonNode info = (JsonNode)infos.next();
            DataAreaSetting.FloatInfo floatInfo = new DataAreaSetting.FloatInfo();
            floatInfo.setRow_offset(info.get("r_o").asInt());
            floatInfo.setRowEnd_offset(info.get("re_o").asInt());
            floatInfo.setCol_offset(info.get("c_o").asInt());
            floatInfo.setColEnd_offset(info.get("ce_o").asInt());
            if (info.get("rt") != null) {
                floatInfo.setRangeType(info.get("rt").asInt());
            }
            if (info.get("f_o") != null) {
                floatInfo.setFloat_offset(info.get("f_o").asInt());
            }
            if (info.get("memdp") != null) {
                floatInfo.setMemberDisplay(info.get("memdp").asText());
            }
            if (info.get("exptp") != null) {
                floatInfo.setExpandType(info.get("exptp").asText());
            }
            if (info.get("ofr") != null) {
                floatInfo.setOriginalRange(info.get("ofr").asText());
            }
            if (info.get("srtdi") != null) {
                Iterator elements = info.get("srtdi").elements();
                ArrayList<SortDiminfo> sortDiminfos = new ArrayList<SortDiminfo>(16);
                while (elements.hasNext()) {
                    JsonNode sortInfoNode = (JsonNode)elements.next();
                    SortDiminfo dto = new SortDiminfo();
                    if (sortInfoNode.get("sod") != null) {
                        dto.setSortOrder(sortInfoNode.get("sod").asText());
                    }
                    if (sortInfoNode.get("srtt") != null) {
                        dto.setSortType(SortTypeEnum.getEnumByVal((int)sortInfoNode.get("srtt").asInt()));
                    }
                    if (sortInfoNode.get("oby") != null) {
                        dto.setOrderBy(sortInfoNode.get("oby").asText());
                    }
                    if (sortInfoNode.get("top") != null) {
                        dto.setTop(sortInfoNode.get("top").asInt());
                    }
                    sortDiminfos.add(dto);
                }
                floatInfo.setSortDimInfos(sortDiminfos);
            }
            floatInfo.setPartition(this.readRCPartition(info.get("pt")));
            multiAreaSetting.getFloatInfos().add(floatInfo);
        }
    }

    private RowColPartition readRCPartition(JsonNode jsonNode) {
        if (jsonNode == null || jsonNode.get("rcde") == null) {
            return null;
        }
        RowColPartition partition = new RowColPartition();
        Iterator entityNodes = jsonNode.get("rcde").elements();
        JsonNode node = null;
        IRowColDimensionEntry entry = null;
        while (entityNodes != null && entityNodes.hasNext()) {
            node = (JsonNode)entityNodes.next();
            entry = this.readRowColDimEntry(node);
            if (entry == null) continue;
            partition.addOneRowColDimensionEntry(entry);
        }
        return partition;
    }

    private IRowColDimensionEntry readRowColDimEntry(JsonNode jsonNode) {
        JsonNode isQuickAddNew;
        if (jsonNode == null || jsonNode.get("dimnum") == null) {
            return null;
        }
        DefaultRowColDimensionEntry pageentry = new DefaultRowColDimensionEntry();
        DefaultDimension dimension = new DefaultDimension();
        dimension.setNumber(jsonNode.get("dimnum").asText());
        pageentry.setDimension(dimension);
        if (jsonNode.get("vn") != null) {
            pageentry.setViewNumber(jsonNode.get("vn").asText());
        }
        pageentry.setDefaultParentNum(jsonNode.get("apnum") == null ? null : jsonNode.get("apnum").asText());
        JsonNode isFloat = jsonNode.get("fl");
        if (isFloat != null) {
            pageentry.setFloat(isFloat.asBoolean());
        }
        if ((isQuickAddNew = jsonNode.get("isQAdd")) != null) {
            pageentry.setQuickAddNew(isQuickAddNew.asBoolean());
        }
        if (jsonNode.get("mem") != null) {
            Iterator membernodes = jsonNode.get("mem").elements();
            while (membernodes != null && membernodes.hasNext()) {
                JsonNode membernode = (JsonNode)membernodes.next();
                EmrDefaultDimMember dimMember = new EmrDefaultDimMember();
                if (membernode.get("dmnum") != null) {
                    dimMember.setNumber(membernode.get("dmnum").asText());
                }
                if (membernode.get("pmnum") != null) {
                    dimMember.setParentNum(membernode.get("pmnum").asText());
                }
                if (membernode.get("dmt") != null) {
                    dimMember.setType(membernode.get("dmt").asText());
                }
                if (membernode.get("dmlnum") != null) {
                    dimMember.setLongNumber(membernode.get("dmlnum").asText());
                }
                if (membernode.get("scp") != null) {
                    dimMember.setScope(membernode.get("scp").asInt());
                }
                if (membernode.get("vn") != null) {
                    dimMember.setViewNumber(membernode.get("vn").asText());
                }
                if (QuoteTypeEnum.PROPERTY.getValue().equals(dimMember.getType()) && StringUtils.isNotEmpty((CharSequence)dimMember.getLongNumber())) {
                    String[] split = dimMember.getLongNumber().split("!");
                    dimMember.setPropertyValue(new PropertyValueEntry(null, null, split[1], split[0], dimMember.getScope()));
                }
                pageentry.addOneMember((IDimensionMember)dimMember);
            }
        }
        return pageentry;
    }

    private void readSheet(ISheetManager sheetAreaManager, JsonNode areanode, SheetDeSerializer eSheetDeSerializer) {
        if (areanode == null || sheetAreaManager == null) {
            return;
        }
        JsonNode sheetnode = areanode.get("sheet");
        if (sheetnode != null) {
            ISheet sheet = eSheetDeSerializer.readSheet(sheetnode);
            sheetAreaManager.setSheet(sheet);
        }
    }

    private void readAreaViewEntry(JsonNode rootNode, IDataAreaSetting multiAreaSetting) {
        this.readAreaViewEntry(rootNode, multiAreaSetting, "avpme");
    }

    private void readAreaViewEntry(JsonNode rootNode, IDataAreaSetting multiAreaSetting, String prefix) {
        if (rootNode == null || rootNode.get(prefix) == null) {
            return;
        }
        Iterator entrys = rootNode.get(prefix).elements();
        while (entrys != null && entrys.hasNext()) {
            JsonNode entry = (JsonNode)entrys.next();
            DefaultViewPointDimensionEntry viewentry = new DefaultViewPointDimensionEntry();
            if (entry.get("dimnum") != null) {
                DefaultDimension dimension = new DefaultDimension();
                dimension.setNumber(entry.get("dimnum").asText());
                viewentry.setDimension(dimension);
            }
            if (entry.get("dmnum") != null) {
                EmrDefaultDimMember member = new EmrDefaultDimMember();
                member.setNumber(entry.get("dmnum").asText());
                JsonNode type = entry.get("dmt");
                member.setType(null != type && !type.isNull() ? type.asText() : null);
                JsonNode viewNumber = entry.get("vn");
                member.setViewNumber(null != viewNumber && !viewNumber.isNull() ? viewNumber.asText() : null);
                viewentry.setMember((IDimensionMember)member);
            }
            if (!"avpme".equals(prefix)) continue;
            multiAreaSetting.addAreaViewpointmembentry(viewentry);
        }
    }

    private void readHeaderInfos(JsonNode rootNode, IDataAreaSetting multiAreaSetting, String prefix) {
        if (rootNode == null || rootNode.get(prefix) == null) {
            return;
        }
        Iterator entrys = rootNode.get(prefix).elements();
        while (entrys != null && entrys.hasNext()) {
            JsonNode entry = (JsonNode)entrys.next();
            HeaderInfo headerInfo = new HeaderInfo();
            headerInfo.setType(entry.get("tp") != null ? entry.get("tp").asText() : null);
            headerInfo.setNumber(entry.get("n") != null ? entry.get("n").asText() : null);
            headerInfo.setRefDimension(entry.get("rd") != null ? entry.get("rd").asText() : null);
            this.readHeaderObjects(entry, headerInfo);
            if ("rhds".equals(prefix)) {
                multiAreaSetting.getRowHeaders().add(headerInfo);
                continue;
            }
            multiAreaSetting.getColHeaders().add(headerInfo);
        }
    }

    private void readHeaderObjects(JsonNode rootNode, IHeaderInfo headerInfo) {
        if (rootNode != null && rootNode.get("hos") != null && headerInfo != null) {
            Iterator entrys = rootNode.get("hos").elements();
            SPArrayList headerObjects = new SPArrayList();
            while (entrys != null && entrys.hasNext()) {
                JsonNode entry = (JsonNode)entrys.next();
                HeaderObject headerObject = new HeaderObject();
                headerObject.setFloat(entry.get("fl") != null ? entry.get("fl").asBoolean() : false);
                headerObject.setNumber(entry.get("n") != null && !entry.get("n").isNull() ? entry.get("n").asText() : null);
                headerObject.setParentNum(entry.get("pmnum") != null && !entry.get("pmnum").isNull() ? entry.get("pmnum").asText() : null);
                headerObject.setType(entry.get("tp") != null && !entry.get("tp").isNull() ? entry.get("tp").asText() : null);
                headerObject.setViewNumber(entry.get("vn") != null && !entry.get("vn").isNull() ? entry.get("vn").asText() : null);
                if (entry.get("uos") != null) {
                    headerObject.setObjects((Map)SerializationUtils.fromJsonString((String)entry.get("uos").asText(), Map.class));
                }
                headerObjects.add(headerObject);
            }
            headerInfo.setHeaderObjects((List<IHeaderObject>)headerObjects);
        }
    }
}

