/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.business.template.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.epm.emr.business.template.ISheetManager;
import kd.epm.emr.business.template.SequenceInfo;
import kd.epm.emr.business.template.arearangedim.IRowColDimensionEntry;
import kd.epm.emr.business.template.areasetting.IDataAreaSetting;
import kd.epm.emr.business.template.areasetting.IFloatInfo;
import kd.epm.emr.business.template.dimension.SortDiminfo;
import kd.epm.emr.business.template.headerarea.IHeaderInfo;
import kd.epm.emr.business.template.headerarea.IHeaderObject;
import kd.epm.emr.business.template.pagedim.IPageDimensionEntry;
import kd.epm.emr.business.template.partition.IRowColPartition;
import kd.epm.emr.business.template.relation.RelationAreaInfo;
import kd.epm.emr.business.template.serializer.ISerializerConstant;
import kd.epm.emr.business.template.serializer.SheetSerializer;
import kd.epm.emr.business.template.viewpointdim.IViewPointDimensionEntry;
import kd.epm.emr.common.spread.domain.view.FilterView;
import kd.epm.emr.common.spread.sheet.ISheet;
import kd.epm.emr.common.template.enums.SeqTypeEnum;
import kd.epm.epbs.common.model.DefaultDimMember;
import kd.epm.epbs.common.model.IDimensionMember;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class SheetManagerSerializer
extends JsonSerializer
implements ISerializerConstant {
    private JsonGenerator jsonGenerator;
    SerializerProvider serializerProvider;
    private SheetSerializer sheetSerializer = new SheetSerializer();

    public void setJsonGenerator(JsonGenerator jsonGenerator) {
        this.jsonGenerator = jsonGenerator;
    }

    public void setSerializerProvider(SerializerProvider serializerProvider) {
        this.serializerProvider = serializerProvider;
    }

    public void serialize(Object obj) throws IOException {
        this.serialize(obj, this.jsonGenerator, this.serializerProvider);
    }

    public void serialize(Object obj, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (jsonGenerator != null && serializerProvider != null && obj instanceof ISheetManager) {
            this.jsonGenerator = jsonGenerator;
            this.serializerProvider = serializerProvider;
            this.sheetSerializer.setJsonGenerator(jsonGenerator);
            this.sheetSerializer.setSerializerProvider(serializerProvider);
            ISheetManager sheetManager = (ISheetManager)obj;
            jsonGenerator.writeStartObject();
            this.writeSheet(sheetManager.getSheet());
            this.writeAreaRanges(sheetManager.getAreaRanges());
            this.writeFilterView(sheetManager.getFilterView());
            jsonGenerator.writeEndObject();
        }
    }

    protected void writeAreaRanges(List<IDataAreaSetting> areaRanges) throws IOException {
        if (areaRanges != null && areaRanges.size() > 0) {
            this.jsonGenerator.writeArrayFieldStart("areaRanges");
            for (IDataAreaSetting areaRange : areaRanges) {
                this.jsonGenerator.writeStartObject();
                this.jsonGenerator.writeStringField("ar", areaRange.getAreaRange());
                if (areaRange.getOriginalAreaRange() != null) {
                    this.jsonGenerator.writeStringField("oriar", areaRange.getOriginalAreaRange());
                }
                this.writeAreaViewEntry(areaRange.getAreaViewpointmembentry());
                this.jsonGenerator.writeArrayFieldStart("rdims");
                for (String rowdim : areaRange.getRowdims()) {
                    this.jsonGenerator.writeString(rowdim);
                }
                this.jsonGenerator.writeEndArray();
                this.jsonGenerator.writeArrayFieldStart("cdims");
                for (String coldim : areaRange.getColdims()) {
                    this.jsonGenerator.writeString(coldim);
                }
                this.jsonGenerator.writeEndArray();
                this.writeHeaders("rhds", areaRange.getRowHeaders());
                this.writeHeaders("chds", areaRange.getColHeaders());
                if (areaRange.getFloatOnWhere() != null) {
                    this.jsonGenerator.writeNumberField("fow", areaRange.getFloatOnWhere().getVal());
                }
                this.writeFloatInfos(areaRange.getFloatInfos());
                this.writeSequenceInfos(areaRange.getSequenceInfos());
                this.writeRelationAreaInfo(areaRange.getRelationAreaInfo());
                this.writeAutoFloatValue(areaRange.getDelFloatValues());
                this.jsonGenerator.writeEndObject();
            }
            this.jsonGenerator.writeEndArray();
        }
    }

    private void writeAutoFloatValue(Map<List<String>, Object> delFloatValue) throws IOException {
        if (MapUtils.isEmpty(delFloatValue)) {
            return;
        }
        this.jsonGenerator.writeStringField("afv", ObjectSerialUtil.toByteSerialized(delFloatValue));
    }

    private void writeRelationAreaInfo(RelationAreaInfo ri) throws IOException {
        if (ri != null) {
            this.jsonGenerator.writeObjectFieldStart("rai");
            this.jsonGenerator.writeStringField("bmn", ri.getRelationModel());
            this.jsonGenerator.writeArrayFieldStart("cols");
            for (String string : ri.getCols()) {
                this.jsonGenerator.writeString(string);
            }
            this.jsonGenerator.writeEndArray();
            if (ri.getMemberScopes() != null) {
                this.jsonGenerator.writeObjectFieldStart("mbs");
                for (Map.Entry entry : ri.getMemberScopes().entrySet()) {
                    this.jsonGenerator.writeObjectFieldStart((String)entry.getKey());
                    this.writeOnePageEntry((IPageDimensionEntry)entry.getValue());
                    this.jsonGenerator.writeEndObject();
                }
                this.jsonGenerator.writeEndObject();
            }
            this.jsonGenerator.writeArrayFieldStart("afids");
            for (Long l : ri.getAutoFloatDataIds()) {
                this.jsonGenerator.writeNumber(l.longValue());
            }
            this.jsonGenerator.writeEndArray();
            this.jsonGenerator.writeEndObject();
        }
    }

    private void writeSequenceInfos(List<SequenceInfo> infos) throws IOException {
        if (CollectionUtils.isNotEmpty(infos)) {
            this.jsonGenerator.writeArrayFieldStart("seqi");
            for (SequenceInfo info : infos) {
                this.writeSequenceInfo(info, true);
            }
            this.jsonGenerator.writeEndArray();
        }
    }

    private void writeSequenceInfo(SequenceInfo info, boolean flag) throws IOException {
        if (flag) {
            this.jsonGenerator.writeStartObject();
        }
        SeqTypeEnum seqTypeEnum = info.getTypeEnum();
        this.jsonGenerator.writeStringField("sda", info.getDataArea());
        this.jsonGenerator.writeStringField("sa", info.getSeqArea());
        if (StringUtils.isNotEmpty((CharSequence)info.getOriSeqArea())) {
            this.jsonGenerator.writeStringField("osa", info.getOriSeqArea());
        }
        this.jsonGenerator.writeNumberField("sd", info.getDirect());
        this.jsonGenerator.writeStringField("st", seqTypeEnum.getNumber());
        if (SeqTypeEnum.FIX == seqTypeEnum) {
            if (StringUtils.isNotEmpty((CharSequence)info.getFixValue())) {
                this.jsonGenerator.writeStringField("sf", info.getFixValue());
            }
        } else {
            if (SeqTypeEnum.RECOUNT == seqTypeEnum) {
                this.jsonGenerator.writeNumberField("siv", info.getInitvalue());
                this.jsonGenerator.writeNumberField("sev", info.getEndValue());
            }
            if (StringUtils.isNotEmpty((CharSequence)info.getPrefix())) {
                this.jsonGenerator.writeStringField("sp", info.getPrefix());
            }
            if (StringUtils.isNotEmpty((CharSequence)info.getSuffix())) {
                this.jsonGenerator.writeStringField("ss", info.getSuffix());
            }
        }
        if (info.getFromArea() != null) {
            this.jsonGenerator.writeObjectFieldStart("sfa");
            this.writeSequenceInfo(info.getFromArea(), false);
            this.jsonGenerator.writeEndObject();
        }
        if (flag) {
            this.jsonGenerator.writeEndObject();
        }
    }

    protected void writeHeaders(String field, List<IHeaderInfo> headerInfos) throws IOException {
        if (headerInfos != null) {
            this.jsonGenerator.writeArrayFieldStart(field);
            for (IHeaderInfo headerInfo : headerInfos) {
                this.jsonGenerator.writeStartObject();
                this.jsonGenerator.writeStringField("tp", headerInfo.getType());
                this.jsonGenerator.writeStringField("n", headerInfo.getNumber());
                if (StringUtils.isNotEmpty((CharSequence)headerInfo.getRefDimension())) {
                    this.jsonGenerator.writeStringField("rd", headerInfo.getRefDimension());
                }
                this.writeHeaderObjects(headerInfo.getHeaderObjects());
                this.jsonGenerator.writeEndObject();
            }
            this.jsonGenerator.writeEndArray();
        }
    }

    protected void writeHeaderObjects(List<IHeaderObject> headerObjects) throws IOException {
        if (headerObjects != null) {
            this.jsonGenerator.writeArrayFieldStart("hos");
            for (IHeaderObject headerObject : headerObjects) {
                this.jsonGenerator.writeStartObject();
                if (headerObject != null) {
                    if (headerObject.isFloat()) {
                        this.jsonGenerator.writeBooleanField("fl", headerObject.isFloat());
                    }
                    if (headerObject.getNumber() != null) {
                        this.jsonGenerator.writeStringField("n", headerObject.getNumber());
                    }
                    if (headerObject.getParentNum() != null) {
                        this.jsonGenerator.writeStringField("pmnum", headerObject.getParentNum());
                    }
                    if (headerObject.getType() != null) {
                        this.jsonGenerator.writeStringField("tp", headerObject.getType());
                    }
                    if (headerObject.getViewNumber() != null) {
                        this.jsonGenerator.writeStringField("vn", headerObject.getViewNumber());
                    }
                    if (headerObject.getObjects() != null && !headerObject.getObjects().isEmpty()) {
                        this.jsonGenerator.writeStringField("uos", SerializationUtils.toJsonString(headerObject.getObjects()));
                    }
                }
                this.jsonGenerator.writeEndObject();
            }
            this.jsonGenerator.writeEndArray();
        }
    }

    protected void writeSheet(ISheet sheet) throws IOException {
        this.jsonGenerator.writeObjectFieldStart("sheet");
        this.sheetSerializer.serialize(sheet);
        this.jsonGenerator.writeEndObject();
    }

    protected void writeFloatInfos(List<IFloatInfo> floatInfos) throws IOException {
        if (floatInfos == null || floatInfos.size() == 0) {
            return;
        }
        this.jsonGenerator.writeArrayFieldStart("fis");
        for (IFloatInfo floatInfo : floatInfos) {
            this.jsonGenerator.writeStartObject();
            this.jsonGenerator.writeNumberField("r_o", floatInfo.getRow_offset());
            this.jsonGenerator.writeNumberField("re_o", floatInfo.getRowEnd_offset());
            this.jsonGenerator.writeNumberField("c_o", floatInfo.getCol_offset());
            this.jsonGenerator.writeNumberField("ce_o", floatInfo.getColEnd_offset());
            this.jsonGenerator.writeNumberField("rt", floatInfo.getRangeType());
            this.jsonGenerator.writeNumberField("f_o", floatInfo.getFloat_offset());
            this.jsonGenerator.writeStringField("memdp", floatInfo.getMemberDisplay());
            this.jsonGenerator.writeStringField("exptp", floatInfo.getExpandType());
            if (floatInfo.getSortDimInfos() != null && !floatInfo.getSortDimInfos().isEmpty()) {
                this.wtireSortDimInfo(floatInfo);
            }
            if (StringUtils.isNotEmpty((CharSequence)floatInfo.getOriginalRange())) {
                this.jsonGenerator.writeStringField("ofr", floatInfo.getOriginalRange());
            }
            this.jsonGenerator.writeObjectFieldStart("pt");
            this.writeOneRCPartion(floatInfo.getPartition());
            this.jsonGenerator.writeEndObject();
            this.jsonGenerator.writeEndObject();
        }
        this.jsonGenerator.writeEndArray();
    }

    private void wtireSortDimInfo(IFloatInfo floatInfo) throws IOException {
        this.jsonGenerator.writeArrayFieldStart("srtdi");
        for (SortDiminfo dto : floatInfo.getSortDimInfos()) {
            this.jsonGenerator.writeStartObject();
            if (dto.getSortType() != null) {
                this.jsonGenerator.writeNumberField("srtt", dto.getSortType().getVal());
            }
            if (dto.getOrderBy() != null) {
                this.jsonGenerator.writeStringField("oby", dto.getOrderBy());
            }
            if (dto.getSortOrder() != null) {
                this.jsonGenerator.writeStringField("sod", dto.getSortOrder());
            }
            if (dto.getTop() != null) {
                this.jsonGenerator.writeNumberField("top", dto.getTop().intValue());
            }
            this.jsonGenerator.writeEndObject();
        }
        this.jsonGenerator.writeEndArray();
    }

    protected void writeOneRCPartion(IRowColPartition rowColPartition) throws IOException {
        if (rowColPartition.getRowColDimensionEntries() != null && rowColPartition.getRowColDimensionEntries().size() > 0) {
            this.jsonGenerator.writeArrayFieldStart("rcde");
            for (IRowColDimensionEntry rcEntity : rowColPartition.getRowColDimensionEntries()) {
                this.jsonGenerator.writeStartObject();
                this.jsonGenerator.writeBooleanField("fl", rcEntity.isFloat());
                if (rcEntity.isQuickAddNew()) {
                    this.jsonGenerator.writeBooleanField("isQAdd", true);
                    if (rcEntity.getDefaultParentNum() != null) {
                        this.jsonGenerator.writeStringField("apnum", rcEntity.getDefaultParentNum());
                    }
                }
                this.writeOnePageEntry(rcEntity);
                this.jsonGenerator.writeEndObject();
            }
            this.jsonGenerator.writeEndArray();
        }
    }

    protected void writeAreaViewEntry(List<IViewPointDimensionEntry> areaviewpointmembentrys) throws IOException {
        this.writeOneDimEntry(areaviewpointmembentrys, "avpme");
    }

    protected void writeOneDimEntry(List<IViewPointDimensionEntry> entrys, String prefix) throws IOException {
        if (entrys == null || entrys.size() == 0) {
            return;
        }
        this.jsonGenerator.writeArrayFieldStart(prefix);
        for (IViewPointDimensionEntry entry : entrys) {
            if (entry == null) continue;
            this.jsonGenerator.writeStartObject();
            if (entry.getDimension() != null) {
                this.jsonGenerator.writeStringField("dimnum", entry.getDimension().getNumber());
            }
            if (entry.getMember() != null) {
                this.jsonGenerator.writeStringField("dmnum", entry.getMember().getNumber());
                this.jsonGenerator.writeStringField("dmt", entry.getMember().getType());
                this.jsonGenerator.writeStringField("vn", entry.getMember().getViewNumber());
            }
            this.jsonGenerator.writeEndObject();
        }
        this.jsonGenerator.writeEndArray();
    }

    protected void writeOnePageEntry(IPageDimensionEntry pagemembentry) throws IOException {
        this.jsonGenerator.writeStringField("dimnum", pagemembentry.getDimension().getNumber());
        if (pagemembentry.getViewNumber() != null) {
            this.jsonGenerator.writeStringField("vn", pagemembentry.getViewNumber());
        }
        if (pagemembentry.getMembers() != null && pagemembentry.getMembers().size() > 0) {
            this.jsonGenerator.writeArrayFieldStart("mem");
            for (IDimensionMember member : pagemembentry.getMembers()) {
                if (member == null || member.getNumber() == null) continue;
                this.jsonGenerator.writeStartObject();
                this.jsonGenerator.writeStringField("dmnum", member.getNumber());
                if (StringUtils.isNotEmpty((CharSequence)member.getParentNum())) {
                    this.jsonGenerator.writeStringField("pmnum", member.getParentNum());
                }
                if (member instanceof DefaultDimMember) {
                    if (member.getType() != null) {
                        this.jsonGenerator.writeStringField("dmt", member.getType());
                    }
                    if (member.getLongNumber() != null) {
                        this.jsonGenerator.writeStringField("dmlnum", member.getLongNumber());
                    }
                    if (member.getViewNumber() != null) {
                        this.jsonGenerator.writeStringField("vn", member.getViewNumber());
                    }
                }
                this.jsonGenerator.writeNumberField("scp", member.getScope());
                this.jsonGenerator.writeEndObject();
            }
            this.jsonGenerator.writeEndArray();
        }
    }

    protected void writeFilterView(FilterView filterView) throws IOException {
        if (filterView != null) {
            this.jsonGenerator.writeStringField("fv", ObjectSerialUtil.toByteSerialized((Object)filterView));
        }
    }
}

